/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.server;

import com.ibm.smarts.core.rest.server.IRestServerConfiguration;
import com.ibm.smarts.core.rest.server.config.RestServerStaticConfig;
import com.ibm.smarts.core.util.RequestContext;
import java.util.Properties;

public abstract class AbstractRestEngine {
    protected final RequestContext requestContext;
    public final IRestServerConfiguration restServerConfig;
    protected final Properties restConfig;
    protected final RestServerStaticConfig staticConfig;

    public AbstractRestEngine(RequestContext requestContext, IRestServerConfiguration restServerConfig) {
        this.requestContext = requestContext;
        this.restServerConfig = restServerConfig;
        this.restConfig = restServerConfig.getConfig();
        this.staticConfig = restServerConfig.getStaticConfig();
    }

    public abstract void start();

    public abstract void stop();

    public int getPort() {
        return Integer.valueOf(this.restConfig.getProperty("smarts.rest.port"));
    }

    protected static String toString(String[] arr) {
        if (arr == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(arr[i]);
        }
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }
}

