/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import com.ibm.bi.platform.moser.common.utils.Cardinality;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JoinGraph {
    protected Map<String, Group> groupsMap = new HashMap<String, Group>();
    protected Map<String, QueryItem> queryItemsMap = new HashMap<String, QueryItem>();

    public JoinGraph(JSONObject joinGraph) {
        if (joinGraph.containsKey((Object)"connector") && joinGraph.containsKey((Object)"queryitem") && joinGraph.containsKey((Object)"group")) {
            JSONArray joinGraphConnectors = (JSONArray)joinGraph.get((Object)"connector");
            JSONArray joinGraphQueryItems = (JSONArray)joinGraph.get((Object)"queryitem");
            JSONArray joinGraphGroups = (JSONArray)joinGraph.get((Object)"group");
            this.populateGroups(joinGraphGroups);
            this.populateConnectors(joinGraphConnectors);
            this.populateQueryItems(joinGraphQueryItems);
        }
    }

    public List<String> getRelated(List<String> inputIDs) {
        return this.getRelatedQueryItems(inputIDs, null);
    }

    public List<String> getRelatedNto1(List<String> inputIDs) {
        return this.getRelatedQueryItems(inputIDs, Cardinality.MANY_TO_ONE);
    }

    protected List<String> getRelatedQueryItems(List<String> inputIDs, Cardinality cardinality) {
        GroupSet inputGroups = new GroupSet();
        if (inputIDs == null || inputIDs.isEmpty()) {
            return new ArrayList<String>();
        }
        for (String id : inputIDs) {
            if (this.queryItemsMap.containsKey(id)) {
                for (Group group : this.queryItemsMap.get(id).getGroups()) {
                    inputGroups.add(group);
                }
                continue;
            }
            if (this.groupsMap.containsKey(id)) {
                inputGroups.add(this.groupsMap.get(id));
                continue;
            }
            throw new IllegalArgumentException("ID is not found or accessible: " + id);
        }
        if (inputGroups.isEmpty()) {
            return new ArrayList<String>();
        }
        if (!this.isConnected(inputGroups)) {
            throw new IllegalArgumentException("Error while processing : graph is disconnected");
        }
        GroupSet relatedNto1 = new GroupSet();
        GroupSet related1toN = new GroupSet();
        for (Group g : inputGroups.getKeys()) {
            if (cardinality == Cardinality.MANY_TO_ONE) {
                this.getRelatedExplore(g, relatedNto1, Cardinality.MANY_TO_ONE);
                continue;
            }
            if (cardinality != null) continue;
            this.getRelatedExplore(g, relatedNto1, Cardinality.MANY_TO_ONE);
            this.getRelatedExplore(g, related1toN, Cardinality.ONE_TO_MANY);
        }
        GroupSet allRelatedGroups = new GroupSet();
        allRelatedGroups.addAll(relatedNto1);
        allRelatedGroups.addAll(related1toN);
        return JoinGraph.getAllQueryItemIDs(allRelatedGroups);
    }

    protected boolean isConnected(GroupSet groups) {
        GroupSet connectedSet = this.getRelatedInitial(groups.get(0), null);
        return connectedSet.containsAll(groups);
    }

    protected List<Group> getConnections(Group group, Cardinality cardinality) {
        ArrayList<Group> adjacentGroups = new ArrayList<Group>();
        for (Connector connector : group.getConnectors()) {
            if (cardinality != null && connector.getCardinality() != cardinality && connector.getCardinality() != Cardinality.ONE_TO_ONE) continue;
            adjacentGroups.add(this.groupsMap.get(connector.getRightGroupID()));
        }
        return adjacentGroups;
    }

    protected GroupSet getRelatedInitial(Group initialGroup, Cardinality cardinality) {
        GroupSet relatedGroups = new GroupSet();
        relatedGroups.add(initialGroup);
        for (Group adjacentGroup : this.getConnections(initialGroup, cardinality)) {
            this.getRelatedExplore(adjacentGroup, relatedGroups, cardinality);
        }
        return relatedGroups;
    }

    protected void getRelatedExplore(Group current, GroupSet relatedGroups, Cardinality cardinality) {
        if (!relatedGroups.contains(current)) {
            relatedGroups.add(current);
            List<Group> connectedGroups = this.getConnections(current, cardinality);
            for (Object group : connectedGroups.toArray()) {
                this.getRelatedExplore((Group)group, relatedGroups, cardinality);
            }
        }
    }

    protected void populateGroups(JSONArray joinGraphGroups) {
        for (Object groupObj : joinGraphGroups) {
            String groupID = (String)groupObj;
            this.groupsMap.put(groupID, new Group(groupID));
        }
    }

    protected void populateConnectors(JSONArray joinGraphConnectors) {
        for (Object edge : joinGraphConnectors) {
            JSONObject connectorObj = (JSONObject)edge;
            String leftGroupID = (String)connectorObj.get((Object)"leftId");
            String rightGroupID = (String)connectorObj.get((Object)"rightId");
            String cardinality = (String)connectorObj.get((Object)"cardinality");
            Cardinality cardinalityEnum = JoinGraph.extractCardinality(cardinality);
            if (cardinalityEnum == null) continue;
            Connector connector = new Connector(leftGroupID, rightGroupID, cardinalityEnum);
            Connector oppositeConnector = new Connector(rightGroupID, leftGroupID, JoinGraph.getOppositeCardinality(cardinalityEnum));
            if (this.groupsMap.containsKey(leftGroupID)) {
                this.groupsMap.get(leftGroupID).addConnector(connector);
            } else {
                Group leftGroup = new Group(leftGroupID);
                leftGroup.addConnector(connector);
                this.groupsMap.put(leftGroupID, leftGroup);
            }
            if (this.groupsMap.containsKey(rightGroupID)) {
                this.groupsMap.get(rightGroupID).addConnector(oppositeConnector);
                continue;
            }
            Group rightGroup = new Group(rightGroupID);
            rightGroup.addConnector(oppositeConnector);
            this.groupsMap.put(rightGroupID, rightGroup);
        }
    }

    protected void populateQueryItems(JSONArray joinGraphQueryItems) {
        for (Object queryItemObj : joinGraphQueryItems) {
            JSONObject queryItemJSON = (JSONObject)queryItemObj;
            Object[] array = queryItemJSON.keySet().toArray();
            if (array[0] == null) continue;
            String queryItemID = (String)array[0];
            JSONArray groups = (JSONArray)queryItemJSON.get((Object)queryItemID);
            QueryItem queryItem = new QueryItem(queryItemID);
            for (Object groupObj : groups) {
                String groupID = (String)groupObj;
                Group group = this.groupsMap.containsKey(groupID) ? this.groupsMap.get(groupID) : new Group(groupID);
                group.addQueryItem(queryItem);
                queryItem.addGroup(group);
            }
            this.queryItemsMap.put(queryItemID, queryItem);
        }
    }

    protected static List<String> getAllQueryItemIDs(GroupSet groups) {
        HashMap<String, Integer> idsMap = new HashMap<String, Integer>();
        ArrayList<String> queryItemIDs = new ArrayList<String>();
        for (Group group : groups.getKeys()) {
            for (String id : group.getQueryItemsIDs()) {
                if (idsMap.containsKey(id)) continue;
                idsMap.put(id, 1);
                queryItemIDs.add(id);
            }
        }
        return queryItemIDs;
    }

    protected static Cardinality extractCardinality(String cardinality) {
        if (cardinality.equals("N:1")) {
            return Cardinality.MANY_TO_ONE;
        }
        if (cardinality.equals("1:N")) {
            return Cardinality.ONE_TO_MANY;
        }
        if (cardinality.equals("1:1")) {
            return Cardinality.ONE_TO_ONE;
        }
        if (cardinality.equals("N:N")) {
            return Cardinality.MANY_TO_MANY;
        }
        return null;
    }

    protected static Cardinality getOppositeCardinality(Cardinality cardinality) {
        switch (cardinality) {
            case MANY_TO_ONE: {
                return Cardinality.ONE_TO_MANY;
            }
            case ONE_TO_MANY: {
                return Cardinality.MANY_TO_ONE;
            }
        }
        return cardinality;
    }

    protected static class QueryItem {
        protected String queryItemID;
        protected List<Group> groups;

        protected QueryItem(String queryItemID) {
            this.queryItemID = queryItemID;
            this.groups = new ArrayList<Group>();
        }

        protected String getQueryItemID() {
            return this.queryItemID;
        }

        protected List<Group> getGroups() {
            return this.groups;
        }

        protected void addGroup(Group group) {
            this.groups.add(group);
        }
    }

    protected static class Group {
        protected String groupID;
        protected List<QueryItem> queryItems;
        protected List<Connector> connectors;

        protected Group(String groupID) {
            this.groupID = groupID;
            this.queryItems = new ArrayList<QueryItem>();
            this.connectors = new ArrayList<Connector>();
        }

        protected List<String> getQueryItemsIDs() {
            ArrayList<String> queryItemIDs = new ArrayList<String>();
            for (QueryItem queryItem : this.getQueryItems()) {
                queryItemIDs.add(queryItem.getQueryItemID());
            }
            return queryItemIDs;
        }

        protected void addConnector(Connector connector) {
            this.connectors.add(connector);
        }

        protected void addQueryItem(QueryItem queryItem) {
            this.queryItems.add(queryItem);
        }

        protected String getGroupID() {
            return this.groupID;
        }

        protected List<QueryItem> getQueryItems() {
            return this.queryItems;
        }

        protected List<Connector> getConnectors() {
            return this.connectors;
        }
    }

    protected static class GroupSet {
        protected Map<String, Group> map = new HashMap<String, Group>();
        protected List<Group> keys = new ArrayList<Group>();

        protected GroupSet() {
        }

        protected void add(Group item) {
            if (!this.map.containsKey(item.getGroupID())) {
                this.map.put(item.getGroupID(), item);
                this.keys.add(item);
            }
        }

        protected void addAll(GroupSet items) {
            for (Group item : items.getKeys()) {
                this.add(item);
            }
        }

        protected boolean contains(Group item) {
            return this.map.containsKey(item.getGroupID());
        }

        protected boolean containsAll(GroupSet groups) {
            for (Group group : groups.getKeys()) {
                if (this.contains(group)) continue;
                return false;
            }
            return true;
        }

        protected Group get(int i) {
            return this.keys.get(i);
        }

        protected List<Group> getKeys() {
            return this.keys;
        }

        protected int size() {
            return this.keys.size();
        }

        protected boolean isEmpty() {
            return this.keys.isEmpty();
        }
    }

    protected static class Connector {
        protected String leftGroupID;
        protected String rightGroupID;
        protected Cardinality cardinality;

        protected Connector(String leftGroupID, String rightGroupID, Cardinality cardinality) {
            this.leftGroupID = leftGroupID;
            this.rightGroupID = rightGroupID;
            this.cardinality = cardinality;
        }

        protected Cardinality getCardinality() {
            return this.cardinality;
        }

        protected String getLeftGroupID() {
            return this.leftGroupID;
        }

        protected String getRightGroupID() {
            return this.rightGroupID;
        }
    }
}

