/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.question.generator.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import com.ibm.smarts.model.qg.DataContext;
import com.ibm.smarts.model.qg.LearningContext;
import com.ibm.smarts.model.qg.QuestionType;
import com.ibm.smarts.model.qg.SemanticGraph;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.store.api.provider.IPersistenceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QuestionContext {
    private RequestContext requestContext;
    private DataContext dataContext;
    private LearningContext learningContext;
    private AnalysisScope analysisScope;
    private String smartsModuleId;
    private SemanticGraph graph;
    private List<String> qgStrategies;
    private Set<String> includedColumnIds;
    private Set<String> excludedColumnIds;
    private Map<QuestionType, Integer> questionTypeLimitsMap;
    private InterestingFieldsRecommender ifr;
    private IPersistenceProvider persistenceProvider;

    @JsonCreator
    public QuestionContext(@JsonProperty(value="requestContext") RequestContext requestContext, @JsonProperty(value="dataContext") DataContext dataContext, @JsonProperty(value="learningContext") LearningContext learningContext, @JsonProperty(value="analysisScope") AnalysisScope analysisScope, @JsonProperty(value="smartsModuleId") String smartsModuleId, @JsonProperty(value="graph") SemanticGraph graph, @JsonProperty(value="qgStrategies") List<String> qgStrategies) {
        this.requestContext = requestContext;
        this.dataContext = dataContext;
        this.learningContext = learningContext;
        this.analysisScope = analysisScope;
        this.smartsModuleId = smartsModuleId;
        this.graph = graph;
        this.qgStrategies = qgStrategies;
    }

    public QuestionContext(RequestContext requestContext, DataContext dataContext, LearningContext learningContext, AnalysisScope analysisScope, String smartsModuleId, SemanticGraph graph, List<String> qgStrategies, InterestingFieldsRecommender ifr, IPersistenceProvider persistenceProvider) {
        this(requestContext, dataContext, learningContext, analysisScope, smartsModuleId, graph, qgStrategies);
        this.ifr = ifr;
        this.persistenceProvider = persistenceProvider;
    }

    public QuestionContext(RequestContext requestContext, DataContext dataContext, LearningContext learningContext, AnalysisScope analysisScope, String smartsModuleId, SemanticGraph graph, List<String> qgStrategies, Set<String> includedColumnIds, Set<String> excludedColumnIds) {
        this(requestContext, dataContext, learningContext, analysisScope, smartsModuleId, graph, qgStrategies);
        this.includedColumnIds = includedColumnIds;
        this.excludedColumnIds = excludedColumnIds;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public SemanticGraph getGraph() {
        return this.graph;
    }

    public void setGraph(SemanticGraph graph) {
        this.graph = graph;
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public void setDataContext(DataContext dataContext) {
        this.dataContext = dataContext;
    }

    public AnalysisScope getAnalysisScope() {
        return this.analysisScope;
    }

    public void setAnalysisScope(AnalysisScope analysisScope) {
        this.analysisScope = analysisScope;
    }

    public String getSmartsModuleId() {
        return this.smartsModuleId;
    }

    public void setSmartsModuleId(String smartsModuleId) {
        this.smartsModuleId = smartsModuleId;
    }

    public List<String> getQgStrategies() {
        if (this.qgStrategies == null) {
            this.qgStrategies = new ArrayList<String>();
        }
        return this.qgStrategies;
    }

    public Set<String> getIncludedColumnIds() {
        if (this.includedColumnIds == null) {
            this.includedColumnIds = new HashSet<String>();
        }
        return this.includedColumnIds;
    }

    public Set<String> getExcludedColumnIds() {
        if (this.excludedColumnIds == null) {
            this.excludedColumnIds = new HashSet<String>();
        }
        return this.excludedColumnIds;
    }

    public LearningContext getLearningContext() {
        return this.learningContext;
    }

    public void setLearningContext(LearningContext learningContext) {
        this.learningContext = learningContext;
    }

    public Map<QuestionType, Integer> getQuestionTypeLimitsMap() {
        if (this.questionTypeLimitsMap == null) {
            this.questionTypeLimitsMap = new HashMap<QuestionType, Integer>();
        }
        return this.questionTypeLimitsMap;
    }

    public InterestingFieldsRecommender getInterestingFieldsRecommender() {
        return this.ifr;
    }

    public void serInterestingFieldsRecommender(InterestingFieldsRecommender ifr) {
        this.ifr = ifr;
    }

    public IPersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public void setPersistenceProvider(IPersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }
}

