/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.question.generator.api;

import com.ibm.smarts.model.qg.ScoredIQR;
import com.ibm.smarts.question.generator.api.QuestionContext;
import com.ibm.smarts.question.generator.internal.strategies.QGStrategy;
import com.ibm.smarts.question.generator.internal.strategies.QGStrategyFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QuestionGenerator {
    private List<QGStrategy> strategies;
    private QuestionContext questionContext;

    public QuestionGenerator(QuestionContext questionContext) {
        this.questionContext = questionContext;
        this.strategies = new ArrayList<QGStrategy>();
        this.createQStrategies(questionContext);
    }

    public List<QGStrategy> getStrategies() {
        if (this.strategies == null) {
            this.strategies = new ArrayList<QGStrategy>();
        }
        return this.strategies;
    }

    public QuestionContext getQuestionContext() {
        return this.questionContext;
    }

    public void createQStrategies(QuestionContext questionContext) {
        if (questionContext.getQgStrategies().isEmpty()) {
            this.strategies.add(QGStrategyFactory.createCausalQStrategy(questionContext));
            this.strategies.add(QGStrategyFactory.createSemanticQStrategy(questionContext));
            this.strategies.add(QGStrategyFactory.createTemplatedQStrategy(questionContext));
        } else {
            Iterator<String> iterator = questionContext.getQgStrategies().iterator();
            while (iterator.hasNext()) {
                String qgStrategy;
                switch (qgStrategy = iterator.next()) {
                    case "CausalQuestion": {
                        this.strategies.add(QGStrategyFactory.createCausalQStrategy(questionContext));
                        break;
                    }
                    case "SemanticQuestion": {
                        this.strategies.add(QGStrategyFactory.createSemanticQStrategy(questionContext));
                        break;
                    }
                    case "TemplateQuestion": {
                        this.strategies.add(QGStrategyFactory.createTemplatedQStrategy(questionContext));
                        break;
                    }
                }
            }
        }
    }

    public List<ScoredIQR> generate() {
        ArrayList<ScoredIQR> scoredIQRList = new ArrayList<ScoredIQR>();
        for (QGStrategy strategy : this.strategies) {
            scoredIQRList.addAll(strategy.generateScoredIQR());
        }
        return scoredIQRList;
    }
}

