/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.question.generator.api;

import com.ibm.smarts.model.builder.QGEncodedSamples;
import com.ibm.smarts.model.qg.Question;
import com.ibm.smarts.model.qg.QuestionType;
import com.ibm.smarts.model.qg.ScoredIQR;
import com.ibm.smarts.question.generator.api.QuestionContext;
import com.ibm.smarts.question.generator.api.QuestionGenerator;
import com.ibm.smarts.question.generator.internal.realizers.TemplateRealizer;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsQuestionGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsQuestionGenerator.class);
    private static final int MAX_NO_OF_SAMPLES = 3;
    private static final int TYPE_QUESTIONS_MAX = 10;
    private static final int TYPE_QUESTIONS_COUNT_DEFAULT = 2;
    private static final int WHICH_QUESTIONS_COUNT_DEFAULT = 2;
    private static final int WHAT_QUESTIONS_COUNT_DEFAULT = 1;
    private static final int COMPARE_QUESTIONS_COUNT_DEFAULT = 2;
    private static final int KPI_QUESTIONS_COUNT_DEFAULT = 2;

    private SmartsQuestionGenerator() {
    }

    public static List<Question> generateQuestions(QuestionContext questionContext) {
        SmartsQuestionGenerator.updateQuestionTypeLimits(questionContext.getQuestionTypeLimitsMap());
        QuestionGenerator questionGenerator = new QuestionGenerator(questionContext);
        TemplateRealizer qr = new TemplateRealizer();
        ArrayList<Question> questions = new ArrayList<Question>();
        List<ScoredIQR> scoredIQRList = questionGenerator.generate();
        for (ScoredIQR scoredIQR : scoredIQRList) {
            List<String> text = qr.realize(scoredIQR.getIqr());
            List qs = text.stream().map(t -> new Question(scoredIQR.getIqr(), t, scoredIQR.getScore())).collect(Collectors.toList());
            questions.addAll(qs);
        }
        return questions;
    }

    public static void updateQuestionTypeLimits(Map<QuestionType, Integer> limitsMap) {
        for (QuestionType questionType : QuestionType.values()) {
            if (!limitsMap.containsKey(questionType)) {
                limitsMap.put(questionType, SmartsQuestionGenerator.getQuestionTypeDefaultLimit(questionType));
                continue;
            }
            int questionCount = limitsMap.get(questionType);
            if (questionCount <= 10) continue;
            limitsMap.replace(questionType, 10);
            LOGGER.debug("Client requested [{}] questions of type [{}], which is too large. Reducing to [{}]", new Object[]{questionCount, questionType.value(), 10});
        }
    }

    private static int getQuestionTypeDefaultLimit(QuestionType questionType) {
        switch (questionType) {
            case WHAT: {
                return 1;
            }
            case WHICH: {
                return 2;
            }
            case COMPARE: {
                return 2;
            }
            case DO: {
                return 2;
            }
        }
        return 2;
    }

    public static List<QGEncodedSamples> encodeSamples(DatasetInfo dataSetInfo) {
        long startTime = System.currentTimeMillis();
        ArrayList<QGEncodedSamples> results = new ArrayList<QGEncodedSamples>();
        SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataSetInfo).forEach(col -> {
            List<String> samples;
            if (SmartsQuestionGenerator.isEncodable(col) && !(samples = SmartsQuestionGenerator.getCleanDistinctSamples(col, 3)).isEmpty()) {
                QGEncodedSamples qgEncodedSamples = new QGEncodedSamples(col.getIdForExpression(), dataSetInfo.getId(), samples);
                results.add(qgEncodedSamples);
            }
        });
        LOGGER.debug("Encoded QGSamples for the DataSet [{}] in {}ms. Number of encoded columns={}", new Object[]{dataSetInfo.getId(), System.currentTimeMillis() - startTime, results.size()});
        return results;
    }

    private static List<String> getCleanDistinctSamples(ColumnInfo columnInfo, int maxSamples) {
        return columnInfo.getSampleDistinctValues().stream().filter(Objects::nonNull).filter(s -> !StringUtils.isBlank((CharSequence)s)).limit(maxSamples).collect(Collectors.toList());
    }

    public static boolean isEncodable(ColumnInfo columnInfo) {
        return columnInfo.getUsage() != UsageType.FACT;
    }
}

