/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.question.generator.internal.realizers;

import com.ibm.smarts.model.qg.Column;
import com.ibm.smarts.model.qg.ColumnType;
import com.ibm.smarts.model.qg.IQR;
import com.ibm.smarts.model.qg.Modifier;
import com.ibm.smarts.model.qg.QuestionType;
import com.ibm.smarts.model.qg.TokenType;
import com.ibm.smarts.question.generator.internal.realizers.QuestionRealizer;
import com.ibm.smarts.question.generator.internal.templates.QuestionParameter;
import com.ibm.smarts.question.generator.internal.templates.QuestionTemplate;
import com.ibm.smarts.question.generator.internal.templates.QuestionTemplateRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateRealizer
implements QuestionRealizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateRealizer.class);

    @Override
    public List<String> realize(IQR iqr) {
        if (null == iqr) {
            return Collections.emptyList();
        }
        List<QuestionTemplate> qTemplates = QuestionTemplateRegistry.instance().get();
        QuestionType qType = iqr.getQuestionType();
        List<Column> iqrCols = this.findColumnsWithProperName(iqr);
        long iqrColCount = iqrCols.size();
        ArrayList<String> realizations = new ArrayList<String>();
        for (QuestionTemplate t : qTemplates) {
            long startTime = System.currentTimeMillis();
            if (!t.getQuestionType().equals((Object)qType)) continue;
            long tColCount = t.getParameters().stream().filter(p -> p.getType().equals((Object)TokenType.COLUMN)).count();
            if (tColCount == iqrColCount) {
                List<QuestionParameter> params = t.getParameters();
                int paramsCount = params.size();
                ArrayList paramValues = new ArrayList();
                for (QuestionParameter param : params) {
                    iqrCols.stream().filter(c -> !paramValues.contains(c.getPrettyName())).filter(c -> this.columnMatchesParameter((Column)c, param)).findAny().ifPresent(c -> paramValues.add(c.getPrettyName()));
                }
                if (paramsCount == paramValues.size()) {
                    realizations.add(String.format(t.getText(), paramValues.toArray()));
                }
            }
            LOGGER.debug("Realized a {}-template in {}ms", (Object)t.getQuestionType(), (Object)(System.currentTimeMillis() - startTime));
        }
        return realizations;
    }

    private List<Column> findColumnsWithProperName(IQR iqr) {
        return iqr.getColumns().stream().filter(c -> null != c.getPrettyName()).filter(c -> !StringUtils.isBlank((CharSequence)c.getPrettyName())).collect(Collectors.toList());
    }

    private boolean columnMatchesParameter(Column column, QuestionParameter parameter) {
        if (null == column || null == parameter) {
            return false;
        }
        if (!parameter.getType().equals((Object)TokenType.COLUMN)) {
            return false;
        }
        List<ColumnType> parameterConcepts = parameter.getConcepts();
        if (null == parameterConcepts || !parameterConcepts.contains(column.getType())) {
            return false;
        }
        Modifier parameterModifier = parameter.getModifier();
        Modifier columnModifier = column.getModifier();
        if (null == parameterModifier && null != columnModifier || null != parameterModifier && null == columnModifier) {
            return false;
        }
        return null == parameterModifier && null == columnModifier || parameter.getModifier().equals((Object)column.getModifier());
    }
}

