/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.question.generator.internal.strategies;

import com.ibm.smarts.model.qg.Column;
import com.ibm.smarts.model.qg.ColumnType;
import com.ibm.smarts.model.qg.IQR;
import com.ibm.smarts.model.qg.Modifier;
import com.ibm.smarts.model.qg.Order;
import com.ibm.smarts.model.qg.QuestionIntent;
import com.ibm.smarts.model.qg.QuestionType;
import com.ibm.smarts.model.qg.ScoredIQR;
import com.ibm.smarts.question.generator.api.QuestionContext;
import com.ibm.smarts.question.generator.internal.containers.ScoredColumnInfo;
import com.ibm.smarts.question.generator.internal.strategies.QGStrategy;
import com.ibm.smarts.question.generator.provider.IQuestionGeneratorProvider;
import com.ibm.smarts.question.generator.provider.QuestionGeneratorCaProvider;
import com.ibm.smarts.question.generator.util.QuestionGeneratorUtility;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.LogicalGroup;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.schema.util.SmartsUtil;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatedQuestionStrategy
implements QGStrategy {
    private Logger LOGGER = LoggerFactory.getLogger(TemplatedQuestionStrategy.class);
    private static final int MAX_INTERESTING_FIELDS = 10;
    private static final float MIN_INTERESTING_FIELD_SCORE = 0.2f;
    private static final int MAX_OBJECT_QUESTIONS = 1;
    private QuestionContext questionContext;

    public TemplatedQuestionStrategy(QuestionContext questionContext) {
        this.questionContext = questionContext;
    }

    @Override
    public List<ScoredIQR> generateScoredIQR() {
        QuestionGeneratorCaProvider provider = new QuestionGeneratorCaProvider(this.questionContext.getRequestContext());
        provider.setInterestingFieldsRecommender(this.questionContext.getInterestingFieldsRecommender());
        provider.setPersistenceProvider(this.questionContext.getPersistenceProvider());
        return this.generateScoredIQR(provider);
    }

    public List<ScoredIQR> generateScoredIQR(IQuestionGeneratorProvider provider) {
        try {
            String moduleId = this.questionContext.getSmartsModuleId();
            SmartsModule smartsModule = provider.getSmartsModuleByModuleId(moduleId);
            if (smartsModule == null) {
                this.LOGGER.error("Smarts module could not be fetched for moduleId: {}", (Object)moduleId);
                return Collections.emptyList();
            }
            ArrayList<ScoredIQR> scoredIQRList = new ArrayList<ScoredIQR>();
            List<ScoredColumnInfo> focusColumns = this.findFocusColumns(smartsModule, 10, provider);
            List<ScoredColumnInfo> entities = this.findAllEntities(smartsModule);
            Modifier modifier = new Modifier("top", Order.DESC, "10", false);
            focusColumns = focusColumns.stream().filter(fc -> !this.questionContext.getExcludedColumnIds().contains(fc.getColumnInfo().getIdForExpression())).collect(Collectors.toList());
            entities = entities.stream().filter(e -> !this.questionContext.getExcludedColumnIds().contains(e.getColumnInfo().getIdForExpression())).collect(Collectors.toList());
            scoredIQRList.addAll(this.generateWhichQuestionsWithModifier(focusColumns, modifier));
            scoredIQRList.addAll(this.generateInfluencerQuestions(focusColumns));
            scoredIQRList.addAll(this.generateCompareQuestions(focusColumns, entities));
            scoredIQRList.addAll(this.generateKPIQuestions(smartsModule));
            return scoredIQRList;
        }
        catch (ProviderException e2) {
            this.LOGGER.error("Scored IQR generation Failed.", (Throwable)e2);
            return Collections.emptyList();
        }
    }

    private List<ScoredIQR> generateWhichQuestionsWithModifier(List<ScoredColumnInfo> focusColumns, Modifier modifier) {
        ArrayList<ScoredIQR> scoredIQRList = new ArrayList<ScoredIQR>();
        long startTime = System.currentTimeMillis();
        HashSet<String> observed = new HashSet<String>();
        Set<String> includedColumnIds = this.questionContext.getIncludedColumnIds();
        Set<String> excludedColumnIds = this.questionContext.getExcludedColumnIds();
        for (ScoredColumnInfo object : focusColumns) {
            String objColumnId = object.getColumnInfo().getIdForExpression();
            ColumnInfo objectColumnInfo = object.getColumnInfo();
            if (QuestionGeneratorUtility.isMeasure(objectColumnInfo)) {
                boolean measureIncluded = includedColumnIds.isEmpty() || includedColumnIds.contains(objColumnId);
                Column objCol = new Column(objColumnId, object.getDatasetId(), this.questionContext.getSmartsModuleId(), true);
                objCol.setModifier(modifier);
                objCol.setType(ColumnType.MEASURE);
                objCol.setPrettyName(QuestionGeneratorUtility.getPrettyText(objectColumnInfo));
                List<ScoredColumnInfo> relatedEntities = object.getRelatedColumns();
                List unobserved = relatedEntities.stream().filter(e -> !excludedColumnIds.contains(e.getColumnInfo().getIdForExpression()) && !observed.contains(e.getColumnInfo().getName())).collect(Collectors.toList());
                Iterator iter = unobserved.iterator();
                int count = 0;
                while (iter.hasNext() && count < 1 && scoredIQRList.size() < this.questionContext.getQuestionTypeLimitsMap().get(QuestionType.WHICH)) {
                    boolean entityIncluded;
                    ScoredColumnInfo subj = (ScoredColumnInfo)iter.next();
                    ColumnInfo subjColumnInfo = subj.getColumnInfo();
                    boolean bl = entityIncluded = includedColumnIds.isEmpty() || includedColumnIds.contains(subjColumnInfo.getIdForExpression());
                    if (!measureIncluded && !entityIncluded) continue;
                    ArrayList<Column> columns = new ArrayList<Column>();
                    columns.add(objCol);
                    observed.add(subjColumnInfo.getName());
                    Column subjCol = new Column(subjColumnInfo.getIdForExpression(), subj.getDatasetId(), this.questionContext.getSmartsModuleId(), true);
                    subjCol.setType(ColumnType.ENTITY);
                    subjCol.setPrettyName(QuestionGeneratorUtility.getPrettyText(subjColumnInfo));
                    columns.add(subjCol);
                    IQR iqr = new IQR(QuestionType.WHICH, QuestionIntent.SHOW, columns);
                    ScoredIQR scoredIQR = new ScoredIQR(iqr, 1.0f);
                    scoredIQRList.add(scoredIQR);
                    ++count;
                }
            }
            if (scoredIQRList.size() != this.questionContext.getQuestionTypeLimitsMap().get(QuestionType.WHICH).intValue()) continue;
            break;
        }
        this.LOGGER.debug("Generated [{}] which questions in {}ms", (Object)scoredIQRList.size(), (Object)(System.currentTimeMillis() - startTime));
        return scoredIQRList;
    }

    private List<ScoredIQR> generateCompareQuestions(List<ScoredColumnInfo> focusColumns, List<ScoredColumnInfo> entities) {
        ArrayList<ScoredIQR> scoredIQRList = new ArrayList<ScoredIQR>();
        long startTime = System.currentTimeMillis();
        Set<String> includedColumnIds = this.questionContext.getIncludedColumnIds();
        for (ScoredColumnInfo entity : entities) {
            ColumnInfo entityColumnInfo = entity.getColumnInfo();
            boolean entityIncluded = includedColumnIds.isEmpty() || includedColumnIds.contains(entityColumnInfo.getIdForExpression());
            List<ScoredColumnInfo> entityRelatedMeasures = this.findEntityRelatedMeasures(entity, focusColumns);
            ArrayList<ScoredColumnInfo> filteredMeasures = new ArrayList<ScoredColumnInfo>();
            for (ScoredColumnInfo measure : entityRelatedMeasures) {
                String columnId = measure.getColumnInfo().getIdForExpression();
                if (!includedColumnIds.isEmpty() && !includedColumnIds.contains(columnId) || filteredMeasures.size() >= 2) continue;
                filteredMeasures.add(measure);
            }
            boolean measureIncluded = filteredMeasures.size() > 0;
            for (int i = 0; filteredMeasures.size() < 2 && i < entityRelatedMeasures.size(); ++i) {
                ScoredColumnInfo measure = entityRelatedMeasures.get(i);
                if (filteredMeasures.contains(measure)) continue;
                filteredMeasures.add(measure);
            }
            if (filteredMeasures.size() != 2 || !measureIncluded && !entityIncluded) continue;
            ArrayList<Column> columns = new ArrayList<Column>();
            for (ScoredColumnInfo measure : filteredMeasures) {
                ColumnInfo measureColumnInfo = measure.getColumnInfo();
                Column m = new Column(measureColumnInfo.getIdForExpression(), measure.getDatasetId(), this.questionContext.getSmartsModuleId(), true);
                m.setType(ColumnType.MEASURE);
                m.setPrettyName(QuestionGeneratorUtility.getPrettyText(measureColumnInfo));
                columns.add(m);
            }
            Column e = new Column(entityColumnInfo.getIdForExpression(), entity.getDatasetId(), this.questionContext.getSmartsModuleId(), true);
            e.setType(ColumnType.ENTITY);
            e.setPrettyName(QuestionGeneratorUtility.getPrettyText(entityColumnInfo));
            columns.add(e);
            IQR iqr = new IQR(QuestionType.COMPARE, QuestionIntent.SHOW, columns);
            ScoredIQR scoredIQR = new ScoredIQR(iqr, 0.5f);
            if (scoredIQRList.size() >= this.questionContext.getQuestionTypeLimitsMap().get(QuestionType.COMPARE)) break;
            scoredIQRList.add(scoredIQR);
        }
        this.LOGGER.debug("Generated [{}] compare questions in {}ms", (Object)scoredIQRList.size(), (Object)(System.currentTimeMillis() - startTime));
        return scoredIQRList;
    }

    private List<ScoredIQR> generateInfluencerQuestions(List<ScoredColumnInfo> focusColumns) {
        ArrayList<ScoredIQR> scoredIQRList = new ArrayList<ScoredIQR>();
        long startTime = System.currentTimeMillis();
        Set<String> includedColumnIds = this.questionContext.getIncludedColumnIds();
        if (!includedColumnIds.isEmpty()) {
            focusColumns = focusColumns.stream().filter(fc -> includedColumnIds.contains(fc.getColumnInfo().getIdForExpression())).collect(Collectors.toList());
        }
        for (ScoredColumnInfo object : focusColumns) {
            String objColumnId = object.getColumnInfo().getIdForExpression();
            ColumnInfo objectColumnInfo = object.getColumnInfo();
            if (!QuestionGeneratorUtility.isMeasure(objectColumnInfo)) continue;
            ArrayList<Column> columns = new ArrayList<Column>();
            Column objCol = new Column(objColumnId, object.getDatasetId(), this.questionContext.getSmartsModuleId(), true);
            objCol.setType(ColumnType.MEASURE);
            objCol.setPrettyName(QuestionGeneratorUtility.getPrettyText(objectColumnInfo));
            columns.add(objCol);
            IQR iqr = new IQR(QuestionType.WHAT, QuestionIntent.SHOW_INFLUENCER, columns);
            ScoredIQR scoredIQR = new ScoredIQR(iqr, 0.25f);
            if (scoredIQRList.size() >= this.questionContext.getQuestionTypeLimitsMap().get(QuestionType.WHAT)) break;
            scoredIQRList.add(scoredIQR);
        }
        this.LOGGER.debug("Generated [{}] influencer questions in {}ms", (Object)scoredIQRList.size(), (Object)(System.currentTimeMillis() - startTime));
        return scoredIQRList;
    }

    private List<ScoredIQR> generateKPIQuestions(SmartsModule smartsModule) {
        ArrayList<ScoredIQR> scoredIQRList = new ArrayList<ScoredIQR>();
        long startTime = System.currentTimeMillis();
        scoredIQRList.addAll(this.scoredIQRsFromLogicalGroups(smartsModule, smartsModule.getLogicalGroups()));
        smartsModule.getDatasets().forEach(ds -> scoredIQRList.addAll(this.scoredIQRsFromLogicalGroups(smartsModule, ds.getLogicalGroups())));
        this.LOGGER.debug("Generated [{}] KPI questions in {}ms", (Object)scoredIQRList.size(), (Object)(System.currentTimeMillis() - startTime));
        return scoredIQRList.stream().sorted(Comparator.comparing(ScoredIQR::getScore).reversed()).limit(this.questionContext.getQuestionTypeLimitsMap().get(QuestionType.DO).intValue()).collect(Collectors.toList());
    }

    private List<ScoredIQR> scoredIQRsFromLogicalGroups(SmartsModule smartsModule, List<LogicalGroup> logicalGroups) {
        ArrayList<ScoredIQR> scoredIQRList = new ArrayList<ScoredIQR>();
        Set<String> includedColumnIds = this.questionContext.getIncludedColumnIds();
        Set<String> excludedColumnIds = this.questionContext.getExcludedColumnIds();
        logicalGroups.stream().filter(QuestionGeneratorUtility::isKPILogicalGroup).forEach(lg -> {
            LogicalGroup.Member member;
            int i;
            List members = lg.getMember().stream().filter(m -> !excludedColumnIds.contains(m.getIdForExpression())).collect(Collectors.toList());
            List<LogicalGroup.Member> filteredMembers = new ArrayList<LogicalGroup.Member>();
            int includedIndex = 0;
            for (i = 0; i < members.size(); ++i) {
                member = (LogicalGroup.Member)members.get(i);
                String columnId = member.getIdForExpression();
                if (!includedColumnIds.isEmpty() && !includedColumnIds.contains(columnId) || filteredMembers.size() >= 2) continue;
                includedIndex = i;
                filteredMembers.add(member);
            }
            if (filteredMembers.size() > 0) {
                for (i = 0; i < members.size(); ++i) {
                    member = (LogicalGroup.Member)members.get(i);
                    if (filteredMembers.contains(member)) continue;
                    if (i > includedIndex) {
                        filteredMembers.add(member);
                        break;
                    }
                    filteredMembers = Arrays.asList(member, (LogicalGroup.Member)filteredMembers.get(0));
                    break;
                }
                if (filteredMembers.size() == 2) {
                    LogicalGroup.Member planned = (LogicalGroup.Member)filteredMembers.get(0);
                    LogicalGroup.Member actual = (LogicalGroup.Member)filteredMembers.get(1);
                    ArrayList<Column> columns = new ArrayList<Column>();
                    Column plannedCol = new Column(planned.getIdForExpression(), planned.getDatasetId(), this.questionContext.getSmartsModuleId(), true);
                    Column actualCol = new Column(actual.getIdForExpression(), actual.getDatasetId(), this.questionContext.getSmartsModuleId(), true);
                    plannedCol.setType(ColumnType.PLANNED);
                    actualCol.setType(ColumnType.ACTUAL);
                    plannedCol.setPrettyName(QuestionGeneratorUtility.getPrettyText(SmartsUtil.getColumnInfo((SmartsModule)smartsModule, (String)planned.getDatasetId(), (String)planned.getColumnId())));
                    actualCol.setPrettyName(QuestionGeneratorUtility.getPrettyText(SmartsUtil.getColumnInfo((SmartsModule)smartsModule, (String)actual.getDatasetId(), (String)actual.getColumnId())));
                    columns.add(plannedCol);
                    columns.add(actualCol);
                    IQR iqr = new IQR(QuestionType.DO, QuestionIntent.SHOW, columns);
                    float score = (float)((double)(planned.getAttribute().getConfidence() + actual.getAttribute().getConfidence()) / 2.0);
                    scoredIQRList.add(new ScoredIQR(iqr, score));
                }
            }
        });
        return scoredIQRList;
    }

    private List<ScoredColumnInfo> findAllEntities(SmartsModule smartsModule) {
        ArrayList<ScoredColumnInfo> entities = new ArrayList<ScoredColumnInfo>();
        long startTime = System.currentTimeMillis();
        smartsModule.getDatasets().forEach(ds -> {
            List es = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds).stream().filter(QuestionGeneratorUtility::isEntity).map(c -> new ScoredColumnInfo((ColumnInfo)c, ds.getId(), 0.0f)).collect(Collectors.toList());
            entities.addAll(es);
        });
        this.LOGGER.debug("Found all entities in SmartsModule [{}] in {}ms", (Object)smartsModule.getId(), (Object)(System.currentTimeMillis() - startTime));
        return entities;
    }

    private List<ScoredColumnInfo> findEntityRelatedMeasures(ScoredColumnInfo entity, List<ScoredColumnInfo> focusColumns) {
        ArrayList<ScoredColumnInfo> entityRelatedMeasures = new ArrayList<ScoredColumnInfo>();
        for (ScoredColumnInfo col : focusColumns) {
            Optional<ScoredColumnInfo> sameEntity = col.getRelatedColumns().stream().filter(f -> f.getColumnInfo().getIdForExpression().equals(entity.getColumnInfo().getIdForExpression())).findAny();
            if (!sameEntity.isPresent()) continue;
            entityRelatedMeasures.add(col);
        }
        return entityRelatedMeasures;
    }

    private List<ScoredColumnInfo> findFocusColumns(SmartsModule smartsModule, int maxInterestingFields, IQuestionGeneratorProvider provider) {
        long startTime = System.currentTimeMillis();
        List<ScoredColumnInfo> interestingFields = provider.getInterestingFields(smartsModule).stream().filter(f -> f.getColumnInfo() != null).filter(f -> f.getScore() >= 0.2f).limit(maxInterestingFields).collect(Collectors.toList());
        this.LOGGER.debug("Obtained interesting fields for SmartsModule [{}] in {}ms", (Object)smartsModule.getId(), (Object)(System.currentTimeMillis() - startTime));
        for (ScoredColumnInfo field : interestingFields) {
            ColumnInfo fieldCol = field.getColumnInfo();
            startTime = System.currentTimeMillis();
            List<ScoredColumnInfo> influencers = provider.getInfluencers(smartsModule, fieldCol.getIdForExpression());
            this.LOGGER.debug("Obtained influencers of column [{}] in {}ms", (Object)fieldCol.getIdForExpression(), (Object)(System.currentTimeMillis() - startTime));
            if (influencers.isEmpty()) continue;
            List validInfluencers = influencers.stream().filter(r -> this.isValidRelatedColumn(fieldCol, r.getColumnInfo())).filter(r -> !TemplatedQuestionStrategy.isMoreIdentifierThanEntity(r.getColumnInfo())).collect(Collectors.toList());
            field.getRelatedColumns().addAll(validInfluencers);
        }
        return interestingFields;
    }

    private boolean isValidRelatedColumn(ColumnInfo column, ColumnInfo related) {
        return (related.getUsage() != UsageType.FACT || column.getUsage() != UsageType.FACT) && !QuestionGeneratorUtility.hasUndesiredConcept(related);
    }

    private static boolean isMoreIdentifierThanEntity(ColumnInfo column) {
        if (!QuestionGeneratorUtility.isIdentifier(column)) {
            return false;
        }
        String topIdentifierConceptIRI = QuestionGeneratorUtility.getTopIdentifierConcept(column.getSemanticInfo().getConcepts()).getIRI();
        String topEntityConceptIRI = QuestionGeneratorUtility.getTopEntityConcept(column.getSemanticInfo().getConcepts()).getIRI();
        return QuestionGeneratorUtility.getConceptScore(column, topIdentifierConceptIRI) > QuestionGeneratorUtility.getConceptScore(column, topEntityConceptIRI);
    }
}

