/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.question.generator.provider;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.smarts.ca.core.impl.insights.ColRecommendation;
import com.ibm.smarts.ca.core.impl.insights.RelatedColResponse;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.common.content.ContentObject;
import com.ibm.smarts.question.generator.internal.containers.ScoredColumnInfo;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.FieldsRecommendationResponse;
import com.ibm.smarts.schema.MatchedEntity;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsUtil;
import com.ibm.smarts.visualization.recommender.schema.VisColumn;
import com.ibm.smarts.visualization.recommender.schema.VisRecommendation;
import java.util.ArrayList;
import java.util.List;

public interface IQuestionGeneratorProvider {
    public RequestContext getRequestContext();

    public List<ContentObject> getDataSources();

    public SmartsModule getSmartsModuleByModuleId(String var1);

    public SmartsModule getSmartsModule(String var1, List<String> var2);

    public List<ScoredColumnInfo> getRelatedColumns(SmartsModule var1, String var2);

    public List<ScoredColumnInfo> getInfluencers(SmartsModule var1, String var2);

    public List<ScoredColumnInfo> getInterestingFields(SmartsModule var1);

    public List<MatchedEntity> findSemanticEntitiesFromSources(String var1);

    public List<MatchedEntity> findSemanticEntitiesFromSources(String var1, String var2);

    public Module getModuleMetadata(String var1);

    public Module getModule(String var1);

    default public List<ScoredColumnInfo> getScoredColumnInfoByInterestingFields(SmartsModule smarts, FieldsRecommendationResponse recommendedFields) {
        ArrayList<ScoredColumnInfo> scoredColumnInfoList = new ArrayList<ScoredColumnInfo>();
        List fields = recommendedFields.getRecommendation().getRecommendedFields();
        for (FieldRecommendationRecord field : fields) {
            ColumnInfo columnInfo = SmartsUtil.getColumnInfo((SmartsModule)smarts, (String)field.getTableID(), (String)field.getFieldID());
            float score = field.getConfidence();
            scoredColumnInfoList.add(new ScoredColumnInfo(columnInfo, field.getTableID(), score));
        }
        return scoredColumnInfoList;
    }

    default public List<ScoredColumnInfo> getScoredColumnInfoByInterestingFieldsJar(SmartsModule smarts, FieldsRecommendation recommendedFields) {
        ArrayList<ScoredColumnInfo> scoredColumnInfoList = new ArrayList<ScoredColumnInfo>();
        List fields = recommendedFields.getRecommendedFields();
        for (FieldRecommendationRecord field : fields) {
            ColumnInfo columnInfo = SmartsUtil.getColumnInfo((SmartsModule)smarts, (String)field.getTableID(), (String)field.getFieldID());
            float score = field.getConfidence();
            scoredColumnInfoList.add(new ScoredColumnInfo(columnInfo, field.getTableID(), score));
        }
        return scoredColumnInfoList;
    }

    default public List<ScoredColumnInfo> getScoredColumnInfoByInfluencers(SmartsModule smarts, FieldsRecommendationResponse influencers) {
        ArrayList<ScoredColumnInfo> scoredColumnInfoList = new ArrayList<ScoredColumnInfo>();
        List fields = influencers.getRecommendation().getRecommendedFields();
        for (FieldRecommendationRecord field : fields) {
            String id = field.getFieldIDForExpression();
            ColumnInfo columnInfo = SmartsUtil.getColumnInfoByIdForExpression((SmartsModule)smarts, (String)id);
            float score = field.getConfidence();
            scoredColumnInfoList.add(new ScoredColumnInfo(columnInfo, field.getTableID(), score));
        }
        return scoredColumnInfoList;
    }

    default public List<ScoredColumnInfo> getScoredColumnInfoByInfluencersJar(SmartsModule smarts, FieldsRecommendation influencers) {
        ArrayList<ScoredColumnInfo> scoredColumnInfoList = new ArrayList<ScoredColumnInfo>();
        List fields = influencers.getRecommendedFields();
        for (FieldRecommendationRecord field : fields) {
            String id = field.getFieldIDForExpression();
            ColumnInfo columnInfo = SmartsUtil.getColumnInfoByIdForExpression((SmartsModule)smarts, (String)id);
            float score = field.getConfidence();
            scoredColumnInfoList.add(new ScoredColumnInfo(columnInfo, field.getTableID(), score));
        }
        return scoredColumnInfoList;
    }

    default public List<ScoredColumnInfo> getScoredColumnInfoByRelatedFields(SmartsModule smarts, RelatedColResponse relatedCol, String columnId) {
        ArrayList<ScoredColumnInfo> scoredColumnInfoList = new ArrayList<ScoredColumnInfo>();
        List recs = relatedCol.getRecommendations();
        for (ColRecommendation rec : recs) {
            List cols = rec.getColumns();
            for (VisColumn col : cols) {
                List ids = col.getId();
                for (String id : ids) {
                    if (id.equals(columnId)) continue;
                    ColumnInfo columnInfo = SmartsUtil.getColumnInfoByIdForExpression((SmartsModule)smarts, (String)id);
                    float score = rec.getScore().floatValue();
                    scoredColumnInfoList.add(new ScoredColumnInfo(columnInfo, null, score));
                }
            }
        }
        return scoredColumnInfoList;
    }

    default public List<ScoredColumnInfo> getScoredColumnInfoByRelatedFieldsJar(SmartsModule smarts, List<VisRecommendation> recs, String columnId) {
        ArrayList<ScoredColumnInfo> scoredColumnInfoList = new ArrayList<ScoredColumnInfo>();
        for (VisRecommendation rec : recs) {
            List cols = rec.getColumns();
            for (VisColumn col : cols) {
                List ids = col.getId();
                for (String id : ids) {
                    if (id.equals(columnId)) continue;
                    ColumnInfo columnInfo = SmartsUtil.getColumnInfoByIdForExpression((SmartsModule)smarts, (String)id);
                    float score = rec.getScore().floatValue();
                    scoredColumnInfoList.add(new ScoredColumnInfo(columnInfo, null, score));
                }
            }
        }
        return scoredColumnInfoList;
    }
}

