/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.question.generator.provider;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.smarts.ca.core.impl.Messages;
import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.ca.core.impl.insights.CaInsightsClient;
import com.ibm.smarts.ca.core.impl.insights.RelatedColRequest;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.model.common.content.ContentObject;
import com.ibm.smarts.question.generator.internal.containers.ScoredColumnInfo;
import com.ibm.smarts.question.generator.provider.IQuestionGeneratorProvider;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.FieldsRequest;
import com.ibm.smarts.schema.InfluencersRequest;
import com.ibm.smarts.schema.MatchedEntity;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.store.api.provider.IPersistenceProvider;
import com.ibm.smarts.store.api.query.IRecord;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionGeneratorCaProvider
implements IQuestionGeneratorProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestionGeneratorCaProvider.class);
    private static final int RELATED_COLUMNS_COUNT = 5;
    private RequestContext requestContext;
    private InterestingFieldsRecommender ifr;
    private IPersistenceProvider persistenceProvider;
    public static final SmartsModuleOptions QG_DEFAULT_SMARTS_MODULE_OPTIONS = new SmartsModuleOptions.SmartsModuleOptionsBuilder().addBivariates(true).excludeLabels(true).build();

    @Override
    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public QuestionGeneratorCaProvider(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    @Override
    public List<ContentObject> getDataSources() {
        try {
            return this.getSmartsCaClientManager().getSearchClient().getAllCMItems();
        }
        catch (JaxRs20Exceptions.LocalWebApplicationException | JaxRs20Exceptions.ProcessingException e) {
            throw new ProviderException(Messages.getString((String)"Service.Search"), e);
        }
    }

    @Override
    public SmartsModule getSmartsModuleByModuleId(String moduleId) {
        return this.getSmartsModule(moduleId, Collections.emptyList());
    }

    @Override
    public SmartsModule getSmartsModule(String moduleId, List<String> tags) {
        try {
            IRecord record = this.persistenceProvider.get(this.requestContext, moduleId, tags, QG_DEFAULT_SMARTS_MODULE_OPTIONS);
            return record != null ? (SmartsModule)record.getRecord() : null;
        }
        catch (JaxRs20Exceptions.ResponseProcessingException e) {
            if (e.getResponse().getStatus() == 404) {
                LOGGER.warn("SmartsModule [{}] was not found.", (Object)moduleId);
                return null;
            }
            throw new ProviderException(Messages.getString((String)"Service.KnowledgeDiscovery"), e);
        }
        catch (JaxRs20Exceptions.LocalWebApplicationException | JaxRs20Exceptions.ProcessingException e) {
            throw new ProviderException(Messages.getString((String)"Service.KnowledgeDiscovery"), e);
        }
    }

    public List<ScoredColumnInfo> getRelatedColumnsAPI(SmartsModule smarts, String columnId) {
        CaInsightsClient insightsClient = this.getSmartsCaClientManager().getInsightsClient();
        RelatedColRequest request = new RelatedColRequest();
        request.setSourceModule(CommonJAXBHelper.marshalToJSON((Object)smarts));
        if (columnId != null) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(columnId);
            request.setColumns(ids);
        }
        request.setNumResults(5);
        try {
            return this.getScoredColumnInfoByRelatedFields(smarts, insightsClient.relatedColumns(request), columnId);
        }
        catch (JaxRs20Exceptions.LocalWebApplicationException | JaxRs20Exceptions.ProcessingException e) {
            throw new ProviderException(Messages.getString((String)"Service.Insights"), e);
        }
    }

    @Override
    public List<ScoredColumnInfo> getRelatedColumns(SmartsModule smartsModule, String columnId) {
        return Collections.emptyList();
    }

    public List<ScoredColumnInfo> getInfluencersApi(SmartsModule smarts, String columnId) {
        CaInsightsClient insightsClient = this.getSmartsCaClientManager().getInsightsClient();
        InfluencersRequest request = new InfluencersRequest();
        request.setSmartsModuleJSON(CommonJAXBHelper.marshalToJSON((Object)smarts));
        request.setTargetFieldIDForExpression(columnId);
        try {
            return this.getScoredColumnInfoByInfluencers(smarts, insightsClient.relatedFields(request));
        }
        catch (JaxRs20Exceptions.LocalWebApplicationException | JaxRs20Exceptions.ProcessingException e) {
            throw new ProviderException(Messages.getString((String)"Service.Insights"), e);
        }
    }

    @Override
    public List<ScoredColumnInfo> getInfluencers(SmartsModule smarts, String columnId) {
        if (this.ifr == null) {
            LOGGER.debug("Cannot get influencers because IFR is null");
            return Collections.emptyList();
        }
        FieldsRecommendation recommendation = this.ifr.recommendInfluencers(this.requestContext, smarts, columnId, null);
        return this.getScoredColumnInfoByInfluencersJar(smarts, recommendation);
    }

    public List<ScoredColumnInfo> getInterestingFieldsAPI(SmartsModule smarts) {
        if (smarts == null) {
            return Collections.emptyList();
        }
        CaInsightsClient insightsClient = this.getSmartsCaClientManager().getInsightsClient();
        FieldsRequest request = new FieldsRequest();
        request.setSmartsModuleJSON(CommonJAXBHelper.marshalToJSON((Object)smarts));
        try {
            return this.getScoredColumnInfoByInterestingFields(smarts, insightsClient.interestingFields(request));
        }
        catch (JaxRs20Exceptions.LocalWebApplicationException | JaxRs20Exceptions.ProcessingException e) {
            throw new ProviderException(Messages.getString((String)"Service.Insights"), e);
        }
    }

    @Override
    public List<ScoredColumnInfo> getInterestingFields(SmartsModule smartsModule) {
        if (this.ifr == null) {
            LOGGER.debug("Cannot get interesting fields because IFR is null");
            return Collections.emptyList();
        }
        FieldsRecommendation recommendation = this.ifr.recommendInterestingFields(this.requestContext, smartsModule, null);
        return this.getScoredColumnInfoByInterestingFieldsJar(smartsModule, recommendation);
    }

    private SmartsCaClientManager getSmartsCaClientManager() {
        ObjectCreator clientManagerCreator = (ObjectCreator)this.requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager");
        return (SmartsCaClientManager)clientManagerCreator.create(this.requestContext);
    }

    @Override
    public List<MatchedEntity> findSemanticEntitiesFromSources(String sentence) {
        return this.findSemanticEntitiesFromSources(sentence, null);
    }

    @Override
    public List<MatchedEntity> findSemanticEntitiesFromSources(String sentence, String moduleId) {
        try {
            return this.getSmartsCaClientManager().getInsightsClient().semanticSearch(sentence, "module|uploadedFile|package|dataSet2|data_asset", moduleId, true).getMatchedEntity();
        }
        catch (JaxRs20Exceptions.LocalWebApplicationException | JaxRs20Exceptions.ProcessingException e) {
            throw new ProviderException(Messages.getString((String)"Service.Insights"), e);
        }
    }

    @Override
    public Module getModuleMetadata(String moduleId) {
        try {
            return this.getSmartsCaClientManager().getMoserClient().getBusinessModuleMetadata(moduleId);
        }
        catch (JaxRs20Exceptions.LocalWebApplicationException | JaxRs20Exceptions.ProcessingException e) {
            throw new ProviderException(Messages.getString((String)"Service.Modelling"), e);
        }
    }

    @Override
    public Module getModule(String moduleId) {
        try {
            return this.getSmartsCaClientManager().getMoserClient().getBusinessModule(moduleId);
        }
        catch (JaxRs20Exceptions.LocalWebApplicationException | JaxRs20Exceptions.ProcessingException e) {
            throw new ProviderException(Messages.getString((String)"Service.Modelling"), e);
        }
    }

    public void setInterestingFieldsRecommender(InterestingFieldsRecommender ifr) {
        this.ifr = ifr;
    }

    public void setPersistenceProvider(IPersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }
}

