/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.question.generator.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import com.ibm.smarts.model.qg.GenerateQuestionsRequest;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.question.generator.api.QuestionContext;
import com.ibm.smarts.question.generator.internal.templates.QuestionTemplate;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.LogicalGroup;
import com.ibm.smarts.schema.LogicalGroupType;
import com.ibm.smarts.store.api.provider.IPersistenceProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionGeneratorUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestionGeneratorUtility.class);
    private static final String TEMPLATE_DIR = "/templates";
    private static final String JAR_SCHEME = "jar";
    private static final String PATH_NOT_FOUND = "Path not found";
    private static final String MEASURE_CONCEPT_NAME = "measure";
    private static final String ENTITY_CONCEPT_NAME = "entity";
    private static final String IDENTIFIER_CONCEPT_NAME = "identifier";
    private static final String ROWIDENTIFIER_CONCEPT_NAME = "rowidentifier";
    private static final String PLANNED_CONCEPT_NAME = "planned";
    private static final String ACTUAL_CONCEPT_NAME = "actual";
    private static final List<String> UNDESIRED_CONCEPTS = Arrays.asList("binary", "boolean");

    private QuestionGeneratorUtility() {
    }

    public static QuestionContext getQuestionContext(GenerateQuestionsRequest generateQuestionsRequest, RequestContext requestContext, InterestingFieldsRecommender ifr, IPersistenceProvider persistenceProvider) {
        QuestionContext ctx = new QuestionContext(requestContext, null, null, generateQuestionsRequest.getAnalysisScope(), generateQuestionsRequest.getSmartsModuleId(), null, null, ifr, persistenceProvider);
        ctx.getIncludedColumnIds().addAll(generateQuestionsRequest.getIncludedColumnIds());
        return ctx;
    }

    public static boolean isMeasure(ColumnInfo columnInfo) {
        return QuestionGeneratorUtility.hasConcept(columnInfo, MEASURE_CONCEPT_NAME);
    }

    public static boolean isEntity(ColumnInfo columnInfo) {
        return QuestionGeneratorUtility.hasConcept(columnInfo, ENTITY_CONCEPT_NAME);
    }

    public static boolean isIdentifier(ColumnInfo columnInfo) {
        return QuestionGeneratorUtility.hasConcept(columnInfo, IDENTIFIER_CONCEPT_NAME) || QuestionGeneratorUtility.hasConcept(columnInfo, ROWIDENTIFIER_CONCEPT_NAME);
    }

    public static float getConceptScore(ColumnInfo columnInfo, String conceptID) {
        Optional<ConceptInfo> ci = columnInfo.getSemanticInfo().getConcepts().stream().filter(c -> c.getConceptID().equals(conceptID)).findFirst();
        return ci.isPresent() ? ci.get().getConfidence() : -1.0f;
    }

    public static Concept getTopEntityConcept(List<ConceptInfo> conceptInfoList) {
        ConceptInfo topEntity = new ConceptInfo();
        topEntity.setConfidence(0.0f);
        for (ConceptInfo ci : conceptInfoList) {
            Concept c = ConceptsRegistry.instance().getConcept(ci.getConceptID());
            if (!c.getName().equalsIgnoreCase(ENTITY_CONCEPT_NAME) && !QuestionGeneratorUtility.ancestorHasConcept(c, ENTITY_CONCEPT_NAME) || !(ci.getConfidence() > topEntity.getConfidence())) continue;
            topEntity = ci;
        }
        return ConceptsRegistry.instance().getConcept(topEntity.getConceptID());
    }

    public static Concept getTopIdentifierConcept(List<ConceptInfo> conceptInfoList) {
        ConceptInfo topIdentifier = new ConceptInfo();
        Concept identifier = ConceptsRegistry.instance().getConcept("http://www.ibm.com/ontologies/waca/domain/common#Identifier");
        Concept rowIdentifier = ConceptsRegistry.instance().getConcept("http://www.ibm.com/ontologies/waca/domain/common#RowIdentifier");
        topIdentifier.setConfidence(0.0f);
        for (ConceptInfo ci : conceptInfoList) {
            Concept c = ConceptsRegistry.instance().getConcept(ci.getConceptID());
            if (!c.equals(identifier) && !c.equals(rowIdentifier) && !QuestionGeneratorUtility.ancestorHasConcept(c, IDENTIFIER_CONCEPT_NAME) && !QuestionGeneratorUtility.ancestorHasConcept(c, ROWIDENTIFIER_CONCEPT_NAME) || !(ci.getConfidence() > topIdentifier.getConfidence())) continue;
            topIdentifier = ci;
        }
        return ConceptsRegistry.instance().getConcept(topIdentifier.getConceptID());
    }

    public static boolean hasUndesiredConcept(ColumnInfo columnInfo) {
        for (String concept : UNDESIRED_CONCEPTS) {
            if (!QuestionGeneratorUtility.hasConcept(columnInfo, concept)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConcept(ColumnInfo col, String conceptName) {
        List<Concept> concepts = col.getSemanticInfo().getConcepts().stream().map(ci -> ConceptsRegistry.instance().getConcept(ci.getConceptID())).collect(Collectors.toList());
        return QuestionGeneratorUtility.hasConcept(concepts, conceptName);
    }

    public static boolean hasConcept(List<Concept> concepts, String conceptName) {
        for (Concept c : concepts) {
            if (!QuestionGeneratorUtility.hasConcept(c, conceptName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConcept(Concept concept, String conceptName) {
        return concept.getName().equalsIgnoreCase(conceptName) || QuestionGeneratorUtility.ancestorHasConcept(concept, conceptName);
    }

    private static boolean ancestorHasConcept(Concept concept, String conceptName) {
        return concept.getAncestors().stream().anyMatch(a -> a.getName().equalsIgnoreCase(conceptName));
    }

    public static boolean isKPILogicalGroup(LogicalGroup logicalGroup) {
        if (null == logicalGroup.getLogicGroupType() || !logicalGroup.getLogicGroupType().equals((Object)LogicalGroupType.SCENARIO) || logicalGroup.getMember().size() != 2) {
            return false;
        }
        String m1Concept = ConceptsRegistry.instance().getConcept(((LogicalGroup.Member)logicalGroup.getMember().get(0)).getAttribute().getConceptID()).getName();
        String m2Concept = ConceptsRegistry.instance().getConcept(((LogicalGroup.Member)logicalGroup.getMember().get(1)).getAttribute().getConceptID()).getName();
        return m1Concept.equalsIgnoreCase(PLANNED_CONCEPT_NAME) && m2Concept.equalsIgnoreCase(ACTUAL_CONCEPT_NAME) || m1Concept.equalsIgnoreCase(ACTUAL_CONCEPT_NAME) && m2Concept.equalsIgnoreCase(PLANNED_CONCEPT_NAME);
    }

    public static String getPrettyText(ColumnInfo columnInfo) {
        String prettyName = columnInfo.getPrettyName();
        if (null == prettyName || StringUtils.isBlank((CharSequence)prettyName)) {
            return columnInfo.getName();
        }
        return prettyName;
    }

    public static List<QuestionTemplate> loadTemplates() throws IOException, URISyntaxException {
        ArrayList<QuestionTemplate> qTemplates = new ArrayList<QuestionTemplate>();
        List<String> files = QuestionGeneratorUtility.walkResourceDir(TEMPLATE_DIR);
        for (String file : files) {
            InputStream stream = QuestionTemplate.class.getResourceAsStream(file);
            qTemplates.add((QuestionTemplate)JsonParserHelper.parseJson((JsonNode)JsonParserHelper.getJsonFromStream((InputStream)stream), QuestionTemplate.class));
        }
        return qTemplates;
    }

    private static List<String> walkResourceDir(String dir) throws IOException, URISyntaxException {
        List<String> files;
        block39: {
            URI uri = QuestionGeneratorUtility.class.getResource(dir).toURI();
            if (uri.getScheme().equals(JAR_SCHEME)) {
                try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                    Path path = fileSystem.getPath(dir, new String[0]);
                    if (path == null) {
                        throw new IOException(PATH_NOT_FOUND + dir);
                    }
                    try (Stream<Path> stream = Files.walk(path, 1, new FileVisitOption[0]);){
                        files = stream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(Path::toString).collect(Collectors.toList());
                        break block39;
                    }
                }
            }
            files = new ArrayList<String>();
            try (BufferedReader bf = new BufferedReader(new InputStreamReader(QuestionGeneratorUtility.class.getResourceAsStream(dir), StandardCharsets.UTF_8));){
                String p2;
                while ((p2 = bf.readLine()) != null) {
                    files.add(dir + "/" + p2);
                }
            }
        }
        return files;
    }
}

