/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.cleanup;

import com.ibm.langware.annotator.Copyright;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.Annotator_ImplBase;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIndexRepository;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.resource.ResourceInitializationException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class TypeCleanupAnnotator
extends Annotator_ImplBase {
    private String[] _discardTypes;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        this._discardTypes = (String[])uimaContext.getConfigParameterValue("DiscardTypes");
    }

    public Class<? extends AbstractCas> getRequiredCasInterface() {
        return CAS.class;
    }

    public void process(AbstractCas abstractCas) {
        LowLevelCAS lowLevelCAS = ((CAS)abstractCas).getLowLevelCAS();
        LowLevelTypeSystem lowLevelTypeSystem = lowLevelCAS.ll_getTypeSystem();
        LowLevelIndexRepository lowLevelIndexRepository = lowLevelCAS.ll_getIndexRepository();
        for (String string : this._discardTypes) {
            int n;
            LowLevelIndex lowLevelIndex;
            int n2 = lowLevelTypeSystem.ll_getCodeForTypeName(string);
            if (n2 == 0 || (lowLevelIndex = lowLevelIndexRepository.ll_getIndex("AnnotationIndex", n2)) == null) continue;
            LowLevelIterator lowLevelIterator = lowLevelIndex.ll_iterator();
            int[] nArray = new int[lowLevelIterator.ll_indexSize()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = lowLevelIterator.ll_get();
                lowLevelIterator.moveToNext();
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                lowLevelIndexRepository.ll_removeFS(nArray[n]);
            }
        }
    }
}

