/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.entity_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.crf.FeatureMapping;
import com.ibm.dltj.crf.feature.handler.FeatureHandler;
import com.ibm.dltj.uima_annotator.lex_analysis.TokenInfo;
import com.ibm.langware.annotator.Copyright;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.Type;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
abstract class CASFeaturePath {
    protected final FeatureMapping _mapping;
    protected final FeatureHandler _handler;
    protected final boolean _isEditable;

    protected CASFeaturePath(FeatureMapping featureMapping, FeatureHandler featureHandler) {
        assert (featureMapping != null);
        this._mapping = featureMapping;
        this._handler = featureHandler;
        this._isEditable = featureMapping.isEditable();
    }

    public int getValue(int n, String string, int n2) throws DLTException {
        CharSequence charSequence = this.evaluate(n, string, n2);
        if (this._handler != null) {
            charSequence = this._handler.getFeature(charSequence);
        }
        if (this._isEditable) {
            return this._mapping.addFeature(charSequence);
        }
        return this._mapping.getFeature(charSequence);
    }

    public int getValue(TokenInfo tokenInfo, String string, int n) throws DLTException {
        CharSequence charSequence = this.evaluate(tokenInfo, string, n);
        if (this._handler != null) {
            charSequence = this._handler.getFeature(charSequence);
        }
        if (this._isEditable) {
            return this._mapping.addFeature(charSequence);
        }
        return this._mapping.getFeature(charSequence);
    }

    public final CharSequence getValueString(int n, String string, int n2) throws DLTException {
        CharSequence charSequence = this.evaluate(n, string, n2);
        if (this._handler != null) {
            charSequence = this._handler.getFeature(charSequence);
        }
        return charSequence;
    }

    public final CharSequence getValueString(TokenInfo tokenInfo, String string, int n) throws DLTException {
        CharSequence charSequence = this.evaluate(tokenInfo, string, n);
        if (this._handler != null) {
            charSequence = this._handler.getFeature(charSequence);
        }
        return charSequence;
    }

    protected abstract CharSequence evaluate(TokenInfo var1, String var2, int var3) throws DLTException;

    protected abstract CharSequence evaluate(int var1, String var2, int var3) throws DLTException;

    protected static final FeaturePath compile(CAS cAS, Type type, String string) {
        assert (cAS != null);
        assert (type != null);
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            FeaturePath featurePath = cAS.createFeaturePath();
            featurePath.initialize(string);
            featurePath.typeInit(type);
            return featurePath;
        }
        catch (CASException cASException) {
            return null;
        }
    }

    static interface BuiltInFunction {
        public static final String TYPE_NAME = "/:typeName()";
        public static final String COVERED_TEXT = "/:coveredText()";
        public static final String COVERED_TYPE = "/:coveredType()";
        public static final String POS_CODE32 = "/:posCode32()";
        public static final String GRAMMAR_CODE32 = "/:grammarCode32()";
        public static final String POS_CODE64 = "/:posCode64()";
        public static final String GRAMMAR_CODE64 = "/:grammarCode64()";
        public static final String POS_TAG = "posTag";
        public static final String PART_OF_SPEECH = "/:partOfSpeech()";
        public static final String FROST_MORPH_BIT_MASKS = "/:frost_morphBitMasks()";
        public static final String IS_CONNECTED_TO_PREVIOUS = "/:isConnectedToPrevious()";
    }
}

