/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.entity_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.crf.FeatureMapping;
import com.ibm.dltj.crf.feature.handler.FeatureHandler;
import com.ibm.dltj.uima_annotator.entity_analysis.CASFeaturePath;
import com.ibm.dltj.uima_annotator.entity_analysis.Encoder;
import com.ibm.dltj.uima_annotator.lex_analysis.TokenInfo;
import com.ibm.langware.annotator.Copyright;
import java.nio.CharBuffer;
import java.util.Iterator;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.text.AnnotationFS;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
final class CASFeaturePathFactory {
    protected final CAS _cas;
    protected final LowLevelCAS _llCas;
    protected final TypeSystem _typeSystem;
    protected final LowLevelTypeSystem _llTypeSystem;
    protected final FeatureMapping _mapping;

    private CASFeaturePathFactory(CAS cAS, FeatureMapping featureMapping) {
        assert (cAS != null);
        assert (featureMapping != null);
        this._cas = cAS;
        this._llCas = cAS.getLowLevelCAS();
        this._typeSystem = cAS.getTypeSystem();
        this._llTypeSystem = this._typeSystem.getLowLevelTypeSystem();
        this._mapping = featureMapping;
    }

    static final CASFeaturePathFactory newInstance(CAS cAS, FeatureMapping featureMapping) {
        return new CASFeaturePathFactory(cAS, featureMapping);
    }

    public final CASFeaturePath createCASFeaturePath(Type type, String string) throws DLTException {
        return this.createCASFeaturePath(type, string, null);
    }

    public final CASFeaturePath createCASFeaturePath(final Type type, final String string, FeatureHandler featureHandler) throws DLTException {
        if ("/:coveredText()".equals(string)) {
            return new CASFeaturePath(this._mapping, featureHandler){
                private final int _featureCodeBegin;
                private final int _featureCodeEnd;
                {
                    this._featureCodeBegin = CASFeaturePathFactory.this._llTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:begin");
                    this._featureCodeEnd = CASFeaturePathFactory.this._llTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:end");
                }

                @Override
                protected final CharSequence evaluate(int n, String string, int n2) throws DLTException {
                    return string.substring(CASFeaturePathFactory.this._llCas.ll_getIntValue(n, this._featureCodeBegin), CASFeaturePathFactory.this._llCas.ll_getIntValue(n, this._featureCodeEnd));
                }

                @Override
                protected final CharSequence evaluate(TokenInfo tokenInfo, String string, int n) throws DLTException {
                    return string.substring(tokenInfo.begin, tokenInfo.end);
                }
            };
        }
        if ("/:coveredType()".equals(string)) {
            return new CASFeaturePath(this._mapping, featureHandler){
                private final CharSequence EMPTY_STRING;
                {
                    this.EMPTY_STRING = "";
                }

                @Override
                protected final CharSequence evaluate(int n, String string, int n2) throws DLTException {
                    return this.EMPTY_STRING;
                }

                @Override
                protected final CharSequence evaluate(TokenInfo tokenInfo, String string, int n) throws DLTException {
                    return this.EMPTY_STRING;
                }
            };
        }
        if ("/:typeName()".equals(string)) {
            return new CASFeaturePath(this._mapping, featureHandler){
                private final int _value;
                {
                    super(featureMapping, featureHandler);
                    this._value = this._isEditable ? this._mapping.addFeature((CharSequence)type.getName()) : this._mapping.getFeature((CharSequence)type.getName());
                }

                @Override
                public final int getValue(int n, String string, int n2) throws DLTException {
                    return this._value;
                }

                @Override
                public final int getValue(TokenInfo tokenInfo, String string, int n) throws DLTException {
                    return this._value;
                }

                @Override
                protected final CharSequence evaluate(TokenInfo tokenInfo, String string, int n) throws DLTException {
                    return type.getName();
                }

                @Override
                protected final CharSequence evaluate(int n, String string, int n2) throws DLTException {
                    return type.getName();
                }
            };
        }
        if ("/:posCode32()".equals(string)) {
            return new CASFeaturePath(this._mapping, featureHandler){
                private final FeaturePath _path;
                private final Feature _posFS;
                private final char[] _ch;
                private final CharBuffer _cb;
                {
                    super(featureMapping, featureHandler);
                    this._path = 4.compile(CASFeaturePathFactory.this._cas, type, "lemmaEntries");
                    this._posFS = CASFeaturePathFactory.this._typeSystem.getFeatureByFullName("uima.tt.Lemma:partOfSpeech");
                    this._ch = new char[7];
                    this._cb = CharBuffer.wrap(this._ch);
                }

                @Override
                protected final CharSequence evaluate(int n, String string, int n2) {
                    int n3 = 0;
                    ArrayFS arrayFS = (ArrayFS)this._path.getFSValue(CASFeaturePathFactory.this._llCas.ll_getFSForRef(n));
                    if (arrayFS != null) {
                        for (int i = 0; i < arrayFS.size(); ++i) {
                            FeatureStructure featureStructure = arrayFS.get(i);
                            int n4 = featureStructure.getIntValue(this._posFS);
                            n3 |= 1 << n4;
                        }
                    }
                    this._cb.limit(Encoder.toBase32(n3, this._ch));
                    return this._cb;
                }

                @Override
                protected final CharSequence evaluate(TokenInfo tokenInfo, String string, int n) {
                    int n2 = 0;
                    if (!tokenInfo.isEmpty()) {
                        Iterator iterator = tokenInfo.iterator();
                        while (iterator.hasNext()) {
                            TokenInfo.LemmaEntry lemmaEntry = (TokenInfo.LemmaEntry)((Object)iterator.next());
                            int n3 = lemmaEntry.pos;
                            n2 |= 1 << n3;
                        }
                    }
                    this._cb.limit(Encoder.toBase32(n2, this._ch));
                    return this._cb;
                }
            };
        }
        if ("/:grammarCode32()".equals(string)) {
            return new CASFeaturePath(this._mapping, featureHandler){
                private final FeaturePath _path;
                private final Feature _grammarFS;
                private final char[] _ch;
                private final CharBuffer _cb;
                {
                    super(featureMapping, featureHandler);
                    this._path = 5.compile(CASFeaturePathFactory.this._cas, type, "lemmaEntries");
                    this._grammarFS = CASFeaturePathFactory.this._typeSystem.getFeatureByFullName("uima.tt.Lemma:frost_MorphBitMasks");
                    this._ch = new char[7];
                    this._cb = CharBuffer.wrap(this._ch);
                }

                @Override
                protected final CharSequence evaluate(int n, String string, int n2) {
                    int n3 = 0;
                    ArrayFS arrayFS = (ArrayFS)this._path.getFSValue(CASFeaturePathFactory.this._llCas.ll_getFSForRef(n));
                    if (arrayFS != null) {
                        for (int i = 0; i < arrayFS.size(); ++i) {
                            FeatureStructure featureStructure = arrayFS.get(i);
                            IntArrayFS intArrayFS = (IntArrayFS)featureStructure.getFeatureValue(this._grammarFS);
                            if (intArrayFS == null || intArrayFS.size() <= 0) continue;
                            for (int j = 0; j < intArrayFS.size(); ++j) {
                                int n4 = intArrayFS.get(j);
                                n3 |= n4;
                            }
                        }
                    }
                    n3 = Encoder.reverse(n3);
                    this._cb.limit(Encoder.toBase32(n3, this._ch));
                    return this._cb;
                }

                @Override
                protected final CharSequence evaluate(TokenInfo tokenInfo, String string, int n) {
                    int n2 = 0;
                    if (!tokenInfo.isEmpty()) {
                        Iterator iterator = tokenInfo.iterator();
                        while (iterator.hasNext()) {
                            TokenInfo.LemmaEntry lemmaEntry = (TokenInfo.LemmaEntry)((Object)iterator.next());
                            if (lemmaEntry.morphBitMaskArray.length == 0) continue;
                            for (int n3 : lemmaEntry.morphBitMaskArray) {
                                n2 |= n3;
                            }
                        }
                    }
                    n2 = Encoder.reverse(n2);
                    this._cb.limit(Encoder.toBase32(n2, this._ch));
                    return this._cb;
                }
            };
        }
        if ("/:posCode64()".equals(string)) {
            return new CASFeaturePath(this._mapping, featureHandler){
                private final FeaturePath _path;
                private final Feature _posFS;
                private final char[] _ch;
                private final CharBuffer _cb;
                {
                    super(featureMapping, featureHandler);
                    this._path = 6.compile(CASFeaturePathFactory.this._cas, type, "lemmaEntries");
                    this._posFS = CASFeaturePathFactory.this._typeSystem.getFeatureByFullName("uima.tt.Lemma:partOfSpeech");
                    this._ch = new char[6];
                    this._cb = CharBuffer.wrap(this._ch);
                }

                @Override
                protected final CharSequence evaluate(int n, String string, int n2) {
                    int n3 = 0;
                    ArrayFS arrayFS = (ArrayFS)this._path.getFSValue(CASFeaturePathFactory.this._llCas.ll_getFSForRef(n));
                    if (arrayFS != null) {
                        for (int i = 0; i < arrayFS.size(); ++i) {
                            FeatureStructure featureStructure = arrayFS.get(i);
                            int n4 = featureStructure.getIntValue(this._posFS);
                            n3 |= 1 << n4;
                        }
                    }
                    this._cb.limit(Encoder.toBase64(n3, this._ch));
                    return this._cb;
                }

                @Override
                protected final CharSequence evaluate(TokenInfo tokenInfo, String string, int n) {
                    int n2 = 0;
                    if (!tokenInfo.isEmpty()) {
                        Iterator iterator = tokenInfo.iterator();
                        while (iterator.hasNext()) {
                            TokenInfo.LemmaEntry lemmaEntry = (TokenInfo.LemmaEntry)((Object)iterator.next());
                            int n3 = lemmaEntry.pos;
                            n2 |= 1 << n3;
                        }
                    }
                    this._cb.limit(Encoder.toBase64(n2, this._ch));
                    return this._cb;
                }
            };
        }
        if ("/:grammarCode64()".equals(string)) {
            return new CASFeaturePath(this._mapping, featureHandler){
                private final FeaturePath _path;
                private final Feature _grammarFS;
                private final char[] _ch;
                private final CharBuffer _cb;
                {
                    super(featureMapping, featureHandler);
                    this._path = 7.compile(CASFeaturePathFactory.this._cas, type, "lemmaEntries");
                    this._grammarFS = CASFeaturePathFactory.this._typeSystem.getFeatureByFullName("uima.tt.Lemma:frost_MorphBitMasks");
                    this._ch = new char[6];
                    this._cb = CharBuffer.wrap(this._ch);
                }

                @Override
                protected final CharSequence evaluate(int n, String string, int n2) {
                    int n3 = 0;
                    ArrayFS arrayFS = (ArrayFS)this._path.getFSValue(CASFeaturePathFactory.this._llCas.ll_getFSForRef(n));
                    if (arrayFS != null) {
                        for (int i = 0; i < arrayFS.size(); ++i) {
                            FeatureStructure featureStructure = arrayFS.get(i);
                            IntArrayFS intArrayFS = (IntArrayFS)featureStructure.getFeatureValue(this._grammarFS);
                            if (intArrayFS == null || intArrayFS.size() <= 0) continue;
                            for (int j = 0; j < intArrayFS.size(); ++j) {
                                int n4 = intArrayFS.get(j);
                                n3 |= n4;
                            }
                        }
                    }
                    n3 = Encoder.reverse(n3);
                    this._cb.limit(Encoder.toBase64(n3, this._ch));
                    return this._cb;
                }

                @Override
                protected final CharSequence evaluate(TokenInfo tokenInfo, String string, int n) {
                    int n2 = 0;
                    if (!tokenInfo.isEmpty()) {
                        Iterator iterator = tokenInfo.iterator();
                        while (iterator.hasNext()) {
                            TokenInfo.LemmaEntry lemmaEntry = (TokenInfo.LemmaEntry)((Object)iterator.next());
                            if (lemmaEntry.morphBitMaskArray.length == 0) continue;
                            for (int n3 : lemmaEntry.morphBitMaskArray) {
                                n2 |= n3;
                            }
                        }
                    }
                    n2 = Encoder.reverse(n2);
                    this._cb.limit(Encoder.toBase64(n2, this._ch));
                    return this._cb;
                }
            };
        }
        if ("posTag".equals(string)) {
            return new CASFeaturePath(this._mapping, featureHandler){
                private final Feature posTagFS;
                private final CharSequence EMPTY_STRING;
                {
                    super(featureMapping, featureHandler);
                    this.posTagFS = type.getFeatureByBaseName("posTag");
                    this.EMPTY_STRING = "";
                }

                @Override
                protected final CharSequence evaluate(int n, String string, int n2) throws DLTException {
                    if (this.posTagFS == null) {
                        return this.EMPTY_STRING;
                    }
                    return CASFeaturePathFactory.this._llCas.ll_getStringValue(n, CASFeaturePathFactory.this._llTypeSystem.ll_getCodeForFeature(this.posTagFS));
                }

                @Override
                protected final CharSequence evaluate(TokenInfo tokenInfo, String string, int n) throws DLTException {
                    return this.evaluate(tokenInfo.addr, string, n);
                }
            };
        }
        if ("/:partOfSpeech()".equals(string)) {
            return new CASFeaturePath(this._mapping, featureHandler){
                private final FeaturePath _path;
                private final Feature _posFS;
                private final StringBuilder _str;
                {
                    super(featureMapping, featureHandler);
                    this._path = 9.compile(CASFeaturePathFactory.this._cas, type, "lemmaEntries");
                    this._posFS = CASFeaturePathFactory.this._typeSystem.getFeatureByFullName("uima.tt.Lemma:partOfSpeech");
                    this._str = new StringBuilder(8);
                }

                @Override
                protected final CharSequence evaluate(int n, String string, int n2) {
                    ArrayFS arrayFS = (ArrayFS)this._path.getFSValue(CASFeaturePathFactory.this._llCas.ll_getFSForRef(n));
                    if (arrayFS == null || arrayFS.size() == 0) {
                        return type.getName();
                    }
                    int n3 = 0;
                    for (int i = 0; i < arrayFS.size(); ++i) {
                        FeatureStructure featureStructure = arrayFS.get(i);
                        int n4 = featureStructure.getIntValue(this._posFS);
                        n3 |= 1 << n4;
                    }
                    return this.toString(n3);
                }

                @Override
                protected final CharSequence evaluate(TokenInfo tokenInfo, String string, int n) {
                    if (tokenInfo.isEmpty()) {
                        return type.getName();
                    }
                    int n2 = 0;
                    Iterator iterator = tokenInfo.iterator();
                    while (iterator.hasNext()) {
                        TokenInfo.LemmaEntry lemmaEntry = (TokenInfo.LemmaEntry)((Object)iterator.next());
                        int n3 = lemmaEntry.pos;
                        n2 |= 1 << n3;
                    }
                    return this.toString(n2);
                }

                private CharSequence toString(int n) {
                    if (n == 0) {
                        return "";
                    }
                    this._str.delete(0, this._str.length());
                    int n2 = 0;
                    while (true) {
                        if ((n & 1) != 0) {
                            this._str.append((Object)n2);
                            if (n == 1) break;
                            this._str.append(',');
                        }
                        n >>>= 1;
                        ++n2;
                    }
                    return this._str;
                }
            };
        }
        if ("/:frost_morphBitMasks()".equals(string)) {
            return new CASFeaturePath(this._mapping, featureHandler){
                private final FeaturePath _path;
                private final Feature _posFS;
                private final Feature _grammarFS;
                private final StringBuilder _str;
                private final int[] _elements;
                {
                    super(featureMapping, featureHandler);
                    this._path = 10.compile(CASFeaturePathFactory.this._cas, type, "lemmaEntries");
                    this._posFS = CASFeaturePathFactory.this._typeSystem.getFeatureByFullName("uima.tt.Lemma:partOfSpeech");
                    this._grammarFS = CASFeaturePathFactory.this._typeSystem.getFeatureByFullName("uima.tt.Lemma:frost_MorphBitMasks");
                    this._str = new StringBuilder(16);
                    this._elements = new int[32];
                }

                @Override
                protected final CharSequence evaluate(int n, String string, int n2) {
                    ArrayFS arrayFS = (ArrayFS)this._path.getFSValue(CASFeaturePathFactory.this._llCas.ll_getFSForRef(n));
                    if (arrayFS == null || arrayFS.size() == 0) {
                        return type.getName();
                    }
                    int n3 = 0;
                    for (int i = 0; i < arrayFS.size(); ++i) {
                        FeatureStructure featureStructure = arrayFS.get(i);
                        int n4 = featureStructure.getIntValue(this._posFS);
                        n3 |= 1 << n4;
                        IntArrayFS intArrayFS = (IntArrayFS)featureStructure.getFeatureValue(this._grammarFS);
                        if (intArrayFS == null || intArrayFS.size() <= 0) continue;
                        for (int j = 0; j < intArrayFS.size(); ++j) {
                            int n5 = intArrayFS.get(j);
                            int n6 = n4;
                            this._elements[n6] = this._elements[n6] | n5;
                        }
                    }
                    return this.toString(n3);
                }

                @Override
                protected final CharSequence evaluate(TokenInfo tokenInfo, String string, int n) {
                    if (tokenInfo.isEmpty()) {
                        return type.getName();
                    }
                    int n2 = 0;
                    Iterator iterator = tokenInfo.iterator();
                    while (iterator.hasNext()) {
                        TokenInfo.LemmaEntry lemmaEntry = (TokenInfo.LemmaEntry)((Object)iterator.next());
                        int n3 = lemmaEntry.pos;
                        n2 |= 1 << n3;
                        if (lemmaEntry.morphBitMaskArray.length == 0) continue;
                        for (int n4 : lemmaEntry.morphBitMaskArray) {
                            int n5 = n3;
                            this._elements[n5] = this._elements[n5] | n4;
                        }
                    }
                    return this.toString(n2);
                }

                private CharSequence toString(int n) {
                    if (n == 0) {
                        return "";
                    }
                    this._str.delete(0, this._str.length());
                    int n2 = 0;
                    while (true) {
                        if ((n & 1) != 0) {
                            this._str.append((Object)n2);
                            char c = 'a';
                            for (int i = this._elements[n2]; i != 0; i <<= 1) {
                                if ((i & Integer.MIN_VALUE) != 0) {
                                    this._str.append(c);
                                }
                                c = (char)(c == 'z' ? 65 : c + '\u0001');
                            }
                            this._elements[n2] = 0;
                            if (n == 1) break;
                            this._str.append(',');
                        }
                        n >>>= 1;
                        ++n2;
                    }
                    return this._str;
                }
            };
        }
        if ("/:isConnectedToPrevious()".equals(string)) {
            return new CASFeaturePath(this._mapping, featureHandler){

                @Override
                protected final CharSequence evaluate(TokenInfo tokenInfo, String string, int n) throws DLTException {
                    return Boolean.toString(n == tokenInfo.begin);
                }

                @Override
                protected final CharSequence evaluate(int n, String string, int n2) throws DLTException {
                    AnnotationFS annotationFS = (AnnotationFS)CASFeaturePathFactory.this._llCas.ll_getFSForRef(n);
                    return Boolean.toString(n2 == annotationFS.getBegin());
                }
            };
        }
        return new CASFeaturePath(this._mapping, featureHandler){
            private final FeaturePath _path;
            {
                super(featureMapping, featureHandler);
                this._path = 12.compile(CASFeaturePathFactory.this._cas, type, string);
            }

            @Override
            protected final CharSequence evaluate(int n, String string2, int n2) throws DLTException {
                if (this._path == null) {
                    return "__nil__";
                }
                return this._path.ll_getValueAsString(n, CASFeaturePathFactory.this._llCas);
            }

            @Override
            protected final CharSequence evaluate(TokenInfo tokenInfo, String string2, int n) throws DLTException {
                return this.evaluate(tokenInfo.addr, string2, n);
            }
        };
    }
}

