/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.entity_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.crf.CRFDictionary;
import com.ibm.dltj.crf.CRFTrainer;
import com.ibm.dltj.crf.FeatureMapping;
import com.ibm.dltj.crf.FeatureValueMapping;
import com.ibm.dltj.crf.feature.FeatureTable;
import com.ibm.dltj.gloss.CRFLabelSet;
import com.ibm.dltj.gloss.CRFLearningRate;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.uima_annotator.entity_analysis.BitIndexIterator;
import com.ibm.dltj.uima_annotator.entity_analysis.CASFeatureTable;
import com.ibm.dltj.uima_annotator.entity_analysis.LowLevelSubIterator;
import com.ibm.dltj.uima_annotator.entity_analysis.Method;
import com.ibm.dltj.uima_annotator.entity_analysis.Parameter;
import com.ibm.dltj.uima_annotator.util.PropertiesUtil;
import com.ibm.dltj.uima_annotator.util.TypeSystemUtil;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelIndexRepository;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
final class MethodCRFLearner
extends Method {
    private final CRFTrainer _trainer;
    private final CRFDictionary _dic;
    private final List<FeatureTable> _tableList = new ArrayList<FeatureTable>();
    private Type _blockType;
    private Type _baseType;
    private List<Type> _extTypes;
    private List<Type> _objTypes;
    private int[] _typeMap;
    private final Map<String, String> _buildHistory = new TreeMap<String, String>();
    private final PropertiesUtil _recipe;
    private static final String DEFAULT_RECIPE = "crf.properties";

    MethodCRFLearner(UimaContext uimaContext, String string, File file) throws IOException, DLTException {
        super(uimaContext, string);
        URI uRI = this._cfg.getResourceURI("Resources", this._language, Parameter.Recipe);
        this._recipe = uRI == null ? new PropertiesUtil(this.getClass(), DEFAULT_RECIPE) : new PropertiesUtil(new File(uRI));
        boolean bl = this._cfg.getBoolean(this._language, Parameter.Init, true);
        this._buildHistory.put("Trainer", this.getClass().getName());
        this._buildHistory.put("TrainerVersion", "Build id: " + System.getProperty("buildId", "?"));
        if (!file.exists() || bl) {
            EnumMap<CRFDictionary.PropertyName, Object> enumMap = new EnumMap<CRFDictionary.PropertyName, Object>(CRFDictionary.PropertyName.class);
            if (this._cfg.containsKey(this._language, Parameter.Copyright)) {
                enumMap.put(Parameter.Copyright.propertyName(), (Object)this._cfg.getString(this._language, Parameter.Copyright));
            }
            if (this._cfg.containsKey(this._language, Parameter.Version)) {
                enumMap.put(Parameter.Version.propertyName(), (Object)this._cfg.getString(this._language, Parameter.Version));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : this._cfg.getStringArray(this._language, Parameter.ObjectiveTokenType)) {
                arrayList.add("B-" + string2);
                arrayList.add("I-" + string2);
            }
            enumMap.put(Parameter.ObjectiveTokenType.propertyName(), (Object)arrayList);
            if (this._recipe.containsKey(Parameter.FeatureTemplate.id())) {
                enumMap.put(Parameter.FeatureTemplate.propertyName(), (Object)this._recipe.getStringList(Parameter.FeatureTemplate.id(), ",(?![0-9])"));
            }
            if (this._recipe.containsKey(Parameter.FeaturePath.id())) {
                enumMap.put(Parameter.FeaturePath.propertyName(), (Object)this._recipe.getStringList(Parameter.FeaturePath.id()));
            }
            enumMap.put(CRFDictionary.PropertyName.DIC_LANGUAGE, (Object)string);
            this._dic = CRFDictionary.newInstance((File)file, enumMap);
            this._dic.setAttribute((Object)Parameter.BaseTokenType.caps(), this._cfg.getString(this._language, Parameter.BaseTokenType, "uima.tcas.Annotation"));
            this._dic.setAttribute((Object)Parameter.BlockTokenType.caps(), this._cfg.getString(this._language, Parameter.BlockTokenType, "uima.tcas.DocumentAnnotation"));
        } else {
            this._dic = CRFDictionary.newInstance((File)file);
        }
        this._trainer = new CRFTrainer(this._dic);
        assert (this._dic != null);
        assert (this._trainer != null);
        assert (this._recipe != null);
    }

    @Override
    void typeSystemInit(TypeSystem typeSystem) throws DLTException {
        String string2;
        super.typeSystemInit(typeSystem);
        TypeSystemUtil typeSystemUtil = new TypeSystemUtil(this._typeSystem);
        this._blockType = this._typeSystem.getType(this._dic.getAttribute((Object)Parameter.BlockTokenType.caps()));
        this._baseType = this._typeSystem.getType(this._dic.getAttribute((Object)Parameter.BaseTokenType.caps()));
        ArrayList<Type> arrayList = new ArrayList<Type>();
        CRFLabelSet cRFLabelSet = this._dic.getLabelSet();
        for (String string2 : cRFLabelSet.getUserLabels()) {
            Type type;
            if (!string2.startsWith("B-") || (type = this._typeSystem.getType(string2.substring(2))) == null) continue;
            arrayList.add(type);
        }
        this._objTypes = new ArrayList<Type>();
        Iterator iterator = this._typeSystem.getTypeIterator();
        while (iterator.hasNext()) {
            string2 = (Type)iterator.next();
            if (!typeSystemUtil.isSubType(arrayList, (Type)string2)) continue;
            this._objTypes.add((Type)string2);
        }
        this._extTypes = new ArrayList<Type>();
        iterator = this._typeSystem.getTypeIterator();
        while (iterator.hasNext()) {
            string2 = (Type)iterator.next();
            if (this.isReservedType((Type)string2)) continue;
            this._extTypes.add((Type)string2);
        }
        this._typeMap = typeSystemUtil.getTypeMap(this._extTypes);
        this._dic.setAttributeList((Object)Parameter.ExtTokenType.caps(), typeSystemUtil.getTypeNameList(this._extTypes));
        if (this._blockType == null && this._logger.isLoggable(Level.WARNING)) {
            this._logger.log(Level.WARNING, Messages.getFormattedMessage("EntityExtractor.Warning_parameter_not_found", new Object[]{this._language.getFullLanguage(), Parameter.BlockTokenType}));
        }
        if (this._baseType == null && this._logger.isLoggable(Level.WARNING)) {
            this._logger.log(Level.WARNING, Messages.getFormattedMessage("EntityExtractor.Warning_parameter_not_found", new Object[]{this._language.getFullLanguage(), Parameter.BaseTokenType}));
        }
        if (this._objTypes.isEmpty() && this._logger.isLoggable(Level.WARNING)) {
            this._logger.log(Level.WARNING, Messages.getFormattedMessage("EntityExtractor.Warning_parameter_not_found", new Object[]{this._language.getFullLanguage(), Parameter.ObjectiveTokenType}));
        }
        assert (this._extTypes != null);
        assert (this._typeMap != null);
    }

    @Override
    void process(CAS cAS) throws DLTException {
        assert (cAS != null);
        assert (cAS.getTypeSystem() == this._typeSystem);
        if (this._blockType == null) {
            return;
        }
        if (this._baseType == null) {
            return;
        }
        if (this._objTypes.isEmpty()) {
            return;
        }
        LowLevelCAS lowLevelCAS = cAS.getLowLevelCAS();
        LowLevelIndexRepository lowLevelIndexRepository = lowLevelCAS.ll_getIndexRepository();
        LowLevelIterator lowLevelIterator = lowLevelIndexRepository.ll_getIndex("AnnotationIndex", this._llTypeSystem.ll_getCodeForType(this._blockType)).ll_iterator(false);
        LowLevelSubIterator lowLevelSubIterator = new LowLevelSubIterator(cAS, this._baseType);
        LowLevelSubIterator lowLevelSubIterator2 = new LowLevelSubIterator(cAS, this._extTypes);
        LowLevelSubIterator lowLevelSubIterator3 = new LowLevelSubIterator(cAS, this._objTypes, true);
        while (lowLevelIterator.isValid()) {
            int n;
            int n2;
            int n3 = lowLevelIterator.ll_get();
            CASFeatureTable cASFeatureTable = new CASFeatureTable(this._dic.getFeaturePathList(), null, (FeatureMapping)this._dic.getFeatureMapping());
            cASFeatureTable.setHandler(this._dic.getFeatureHandlerList());
            cASFeatureTable.setCas(cAS);
            FeatureValueMapping featureValueMapping = this._dic.getFeatureMapping();
            int n4 = featureValueMapping.addFeature((CharSequence)"__nil__");
            int n5 = cASFeatureTable.getColumnIndex("/:coveredType()");
            lowLevelSubIterator.moveTo(n3);
            while (lowLevelSubIterator.isValid()) {
                n2 = lowLevelSubIterator.ll_get();
                n = cASFeatureTable.addToken(n2);
                cASFeatureTable.setLabel(n, "__nil__");
                lowLevelSubIterator.moveToNext();
            }
            if (!cASFeatureTable.isEmpty()) {
                int n6;
                if (n5 >= 0) {
                    BitSet bitSet;
                    int n7;
                    n2 = 0;
                    n = 0;
                    lowLevelSubIterator2.moveTo(n3);
                    while (lowLevelSubIterator2.isValid()) {
                        n6 = lowLevelSubIterator2.ll_get();
                        n7 = this._typeMap[lowLevelCAS.ll_getFSRefType(n6)];
                        if (n7 >= 0) {
                            if ((n2 = cASFeatureTable.indexOfBegin(n2, lowLevelCAS.ll_getIntValue(n6, this._featureCodeBegin))) >= 0 && (n = cASFeatureTable.indexOfEnd(n2, lowLevelCAS.ll_getIntValue(n6, this._featureCodeEnd))) >= n2) {
                                while (n2 <= n) {
                                    bitSet = cASFeatureTable.getTypeSet(n2++);
                                    bitSet.set(n7);
                                }
                            }
                            n2 = Math.max(n2, 0);
                        }
                        lowLevelSubIterator2.moveToNext();
                    }
                    n6 = cASFeatureTable.getRowSize();
                    for (n7 = 0; n7 < n6; ++n7) {
                        bitSet = cASFeatureTable.getTypeSet(n7);
                        if (bitSet.isEmpty()) {
                            cASFeatureTable.setFeature(n7, n5, n4);
                            continue;
                        }
                        cASFeatureTable.setFeature(n7, n5, featureValueMapping.addFeature((NetGeneric.IndexIterator)new BitIndexIterator(bitSet)));
                        bitSet.clear();
                    }
                }
                n2 = 0;
                n = 0;
                lowLevelSubIterator3.moveTo(lowLevelCAS.ll_getIntValue(n3, this._featureCodeBegin), lowLevelCAS.ll_getIntValue(n3, this._featureCodeEnd));
                while (lowLevelSubIterator3.isValid()) {
                    n6 = lowLevelSubIterator3.ll_get();
                    if ((n2 = cASFeatureTable.indexOfBegin(n2, lowLevelCAS.ll_getIntValue(n6, this._featureCodeBegin))) >= 0 && (n = cASFeatureTable.indexOfEnd(n2, lowLevelCAS.ll_getIntValue(n6, this._featureCodeEnd))) >= n2) {
                        String string = this._llTypeSystem.ll_getTypeForCode(lowLevelCAS.ll_getFSRefType(n6)).getName();
                        cASFeatureTable.setLabel(n2, "B-" + string);
                        while (++n2 <= n) {
                            cASFeatureTable.setLabel(n2, "I-" + string);
                        }
                    }
                    n2 = Math.max(n2, 0);
                    lowLevelSubIterator3.moveToNext();
                }
                this._tableList.add((FeatureTable)cASFeatureTable);
            }
            lowLevelIterator.moveToNext();
        }
    }

    @Override
    void collectionProcessComplete() throws DLTException {
        try {
            CRFLearningRate cRFLearningRate = this._dic.getLearningRate();
            cRFLearningRate.reset();
            if (this._recipe.containsKey(Parameter.LearningC.id())) {
                cRFLearningRate.C(this._recipe.getDouble(Parameter.LearningC.id()));
            }
            if (this._recipe.containsKey(Parameter.LearningEta0.id())) {
                cRFLearningRate.eta0(this._recipe.getDouble(Parameter.LearningEta0.id()));
            }
            if (this._recipe.containsKey(Parameter.LearningAlpha.id())) {
                cRFLearningRate.alpha(this._recipe.getDouble(Parameter.LearningAlpha.id()));
            }
            this._trainer.process(this._tableList, this._recipe.getInteger(Parameter.LearningIteration.id(), 1));
            this._dic.trimToSize().save(this._buildHistory.entrySet());
        }
        catch (IOException iOException) {
            throw new DLTException((Throwable)iOException);
        }
        finally {
            this._tableList.clear();
        }
    }

    private boolean isReservedType(Type type) {
        TypeSystemUtil typeSystemUtil = new TypeSystemUtil(this._typeSystem);
        if (!typeSystemUtil.isSubType("uima.tcas.Annotation", type, false)) {
            return true;
        }
        if (typeSystemUtil.isSubType("uima.tcas.DocumentAnnotation", type)) {
            return true;
        }
        if (typeSystemUtil.isSubType("com.ibm.langware.reserved.NonMappingAnnotation", type)) {
            return true;
        }
        if (typeSystemUtil.isSubType("uima.tt.TTAnnotation", type) && !typeSystemUtil.isSubType("uima.tt.DictionaryEntryAnnotation", type, false)) {
            return true;
        }
        if (typeSystemUtil.isSubType(this._baseType, type)) {
            return true;
        }
        if (typeSystemUtil.isSubType(this._blockType, type)) {
            return true;
        }
        return typeSystemUtil.isSubType(this._objTypes, type);
    }
}

