/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.flow;

import com.ibm.dltj.uima_annotator.flow.IFlowCondition;
import com.ibm.langware.annotator.Copyright;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.LowLevelTypeSystem;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class FeatureFlowCondition
implements IFlowCondition {
    private final String _type;
    private final String _feature;
    private final String[] _matches;
    private int _typeCode = 0;
    private int _featureCode = 0;

    public FeatureFlowCondition(String string, String string2, String[] stringArray) {
        this._type = string;
        this._feature = string2;
        this._matches = stringArray;
    }

    public String getType() {
        return this._type;
    }

    public String getFeature() {
        return this._feature;
    }

    public String[] getMatches() {
        return this._matches;
    }

    private void initialise(CAS cAS) throws AnalysisEngineProcessException {
        TypeSystem typeSystem = cAS.getTypeSystem();
        Type type = typeSystem.getType(this._type);
        if (type == null) {
            throw new AnalysisEngineProcessException("annotator_ex_type_not_found", new Object[]{FeatureFlowCondition.class.getName(), this._type});
        }
        Feature feature = type.getFeatureByBaseName(this._feature);
        if (feature == null) {
            throw new AnalysisEngineProcessException("annotator_ex_feature_not_found", new Object[]{FeatureFlowCondition.class.getName(), this._feature});
        }
        LowLevelCAS lowLevelCAS = cAS.getLowLevelCAS();
        LowLevelTypeSystem lowLevelTypeSystem = lowLevelCAS.ll_getTypeSystem();
        this._typeCode = lowLevelTypeSystem.ll_getCodeForType(type);
        this._featureCode = lowLevelTypeSystem.ll_getCodeForFeature(feature);
    }

    @Override
    public boolean testCondition(CAS cAS) throws AnalysisEngineProcessException {
        if (this._typeCode == 0) {
            this.initialise(cAS);
        }
        LowLevelCAS lowLevelCAS = cAS.getLowLevelCAS();
        LowLevelIndex lowLevelIndex = lowLevelCAS.ll_getIndexRepository().ll_getIndex("AnnotationIndex", this._typeCode);
        LowLevelIterator lowLevelIterator = lowLevelIndex.ll_iterator();
        while (lowLevelIterator.isValid()) {
            int n = lowLevelIterator.ll_get();
            String string = ((CASImpl)cAS).getFeatureValueAsString(n, this._featureCode);
            if (this.matches(string)) {
                return true;
            }
            lowLevelIterator.moveToNext();
        }
        return false;
    }

    private boolean matches(String string) {
        for (String string2 : this._matches) {
            if (!this.match(string2, string)) continue;
            return true;
        }
        return false;
    }

    private boolean match(String string, String string2) {
        char c = string.charAt(0);
        string = string.substring(1);
        switch (c) {
            case '=': {
                return string.equals(string2);
            }
            case '+': {
                return string.equalsIgnoreCase(string2);
            }
            case '!': {
                return !string.equals(string2);
            }
            case '\u00ac': {
                return !string.equalsIgnoreCase(string2);
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("feature condition ").append(this._type).append(' ').append(this._feature);
        for (String string : this._matches) {
            stringBuilder.append(" match " + string);
        }
        return stringBuilder.toString();
    }
}

