/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.flow;

import com.ibm.dltj.uima_annotator.flow.ChunkFlowStage;
import com.ibm.dltj.uima_annotator.flow.FixedFlowStage;
import com.ibm.dltj.uima_annotator.flow.IFlowStage;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMA_UnsupportedOperationException;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.flow.CasFlow_ImplBase;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.SimpleStep;
import org.apache.uima.flow.Step;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class LrwFlow
extends CasFlow_ImplBase {
    private final List<IFlowStage> _stages;
    private final boolean _internallyProducedCAS;
    private boolean _wasPassedToMerger;
    private int _currStageIndex;
    private final Logger _logger;

    public LrwFlow(LrwFlow lrwFlow) {
        this(lrwFlow._logger, new ArrayList<IFlowStage>(), 0, null);
    }

    public LrwFlow(Logger logger) {
        this(logger, new ArrayList<IFlowStage>(), 0, null);
    }

    private LrwFlow(Logger logger, List<IFlowStage> list, int n, CAS cAS) {
        this._logger = logger;
        this._stages = list;
        this._currStageIndex = n;
        boolean bl = this._internallyProducedCAS = cAS != null;
        if (cAS != null) {
            super.setCas(cAS);
        }
        this._logger.log(Level.FINE, Messages.getFormattedMessage("LrwFlow.construct", this._currStageIndex, this._internallyProducedCAS));
    }

    public void addFlowStage(IFlowStage iFlowStage) {
        this._stages.add(iFlowStage);
    }

    public void addFlowStages(List<IFlowStage> list) {
        this._stages.addAll(list);
    }

    public IFlowStage getLastFlowStage() {
        if (this._stages.isEmpty()) {
            return null;
        }
        return this._stages.get(this._stages.size() - 1);
    }

    public List<IFlowStage> flowStages() {
        return this._stages;
    }

    void computeFlow(CAS cAS) {
        super.setCas(cAS);
        this._logger.log(Level.CONFIG, Messages.getMessage("LrwFlow.config"));
        this._currStageIndex = 0;
        this._wasPassedToMerger = false;
        for (IFlowStage iFlowStage : this._stages) {
            iFlowStage.reset();
            iFlowStage.describe(0, this._logger);
        }
    }

    public Step next() throws AnalysisEngineProcessException {
        this._logger.log(Level.FINE, Messages.getMessage("LrwFlow.next"));
        if (this._wasPassedToMerger) {
            this._logger.log(Level.FINE, Messages.getFormattedMessage("LrwFlow.finalstep", this._internallyProducedCAS));
            return new FinalStep(this._internallyProducedCAS);
        }
        CAS cAS = this.getCas();
        while (this._currStageIndex < this._stages.size()) {
            IFlowStage iFlowStage = this._stages.get(this._currStageIndex);
            this._logger.log(Level.FINE, Messages.getMessage("LrwFlow.currstage") + iFlowStage);
            if (iFlowStage.hasNext(cAS)) {
                String string = iFlowStage.next();
                this._logger.log(Level.FINE, Messages.getMessage("LrwFlow.nextid") + string);
                this.checkForMerger(iFlowStage, string);
                return new SimpleStep(string);
            }
            ++this._currStageIndex;
        }
        this._logger.log(Level.FINE, Messages.getMessage("LrwFlow.final"));
        return new FinalStep();
    }

    private void checkForMerger(IFlowStage iFlowStage, String string) {
        if (iFlowStage instanceof ChunkFlowStage) {
            ChunkFlowStage chunkFlowStage = (ChunkFlowStage)iFlowStage;
            this._wasPassedToMerger = string.equals(chunkFlowStage.getMergerId());
        }
    }

    protected Flow newCasProduced(CAS cAS, String string) throws AnalysisEngineProcessException {
        this._logger.log(Level.FINE, Messages.getFormattedMessage("LrwFlow.newcas", string));
        if (this._currStageIndex < this._stages.size()) {
            IFlowStage iFlowStage = this._stages.get(this._currStageIndex);
            if (iFlowStage instanceof ChunkFlowStage) {
                ((ChunkFlowStage)iFlowStage).newCasProduced(string, this._logger);
                return new LrwFlow(this._logger, this._stages, this._currStageIndex, cAS);
            }
            if (iFlowStage instanceof FixedFlowStage) {
                ((FixedFlowStage)iFlowStage).newCasProduced(string, this._logger);
                return new LrwFlow(this._logger, this._stages, this._currStageIndex, cAS);
            }
        }
        throw new UIMA_UnsupportedOperationException("cas_multiplier_not_supported", new Object[]{((Object)((Object)this)).getClass().getName()});
    }
}

