/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.flow;

import com.ibm.dltj.uima_annotator.flow.LrwCasCopier;
import com.ibm.langware.annotator.Copyright;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasMultiplier_ImplBase;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class MergerAnnotator
extends CasMultiplier_ImplBase {
    private CAS _mergedCas;
    private boolean _completedCas;
    private String _language;
    private final StringBuilder _documentBuffer = new StringBuilder();
    private final Set<String> _discardTypes = new HashSet<String>();
    private String _stateType;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        String[] stringArray;
        super.initialize(uimaContext);
        this._stateType = (String)uimaContext.getConfigParameterValue("StateType");
        for (String string : stringArray = (String[])uimaContext.getConfigParameterValue("DiscardTypes")) {
            this._discardTypes.add(string);
        }
    }

    public void process(CAS cAS) {
        int n;
        TypeSystem typeSystem = cAS.getTypeSystem();
        Type type = typeSystem.getType(this._stateType);
        AnnotationFS annotationFS = null;
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(type);
        if (annotationIndex.size() == 0) {
            n = 4;
        } else {
            Feature feature;
            FSIterator fSIterator = annotationIndex.iterator();
            annotationFS = (AnnotationFS)fSIterator.next();
            n = annotationFS.getIntValue(feature = type.getFeatureByBaseName("segmentState"));
            if (n == 0) {
                n = 4;
            }
        }
        if (this._mergedCas == null) {
            this._mergedCas = this.getEmptyCAS();
            this._language = cAS.getDocumentLanguage();
        }
        int n2 = this._documentBuffer.length();
        this._documentBuffer.append(cAS.getDocumentText());
        this.copyAnnotations(cAS, n2, annotationFS);
        if ((n & 4) == 4) {
            this._completedCas = true;
            this._mergedCas.setDocumentLanguage(this._language);
            this._mergedCas.setDocumentText(this._documentBuffer.toString());
        }
    }

    private void copyAnnotations(CAS cAS, int n, AnnotationFS annotationFS) {
        LrwCasCopier lrwCasCopier = new LrwCasCopier(cAS, this._mergedCas);
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(cAS.getDocumentAnnotation());
        if (annotationFS != null) {
            hashSet.add(annotationFS);
        }
        TypeSystem typeSystem = this._mergedCas.getTypeSystem();
        Feature feature = typeSystem.getFeatureByFullName("uima.tcas.Annotation:begin");
        Feature feature2 = typeSystem.getFeatureByFullName("uima.tcas.Annotation:end");
        for (FeatureStructure featureStructure : cAS.getAnnotationIndex()) {
            if (this._discardTypes.contains(featureStructure.getType().getName()) || hashSet.contains(featureStructure)) continue;
            hashSet.add(featureStructure);
            FeatureStructure featureStructure2 = lrwCasCopier.copyFS(featureStructure);
            featureStructure2.setIntValue(feature, featureStructure2.getIntValue(feature) + n);
            featureStructure2.setIntValue(feature2, featureStructure2.getIntValue(feature2) + n);
            this._mergedCas.addFsToIndexes(featureStructure2);
        }
    }

    public boolean hasNext() {
        return this._completedCas;
    }

    public AbstractCas next() {
        CAS cAS = this._mergedCas;
        this.reset();
        return cAS;
    }

    private void reset() {
        this._mergedCas = null;
        this._language = null;
        this._documentBuffer.setLength(0);
        this._completedCas = false;
    }
}

