/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.implBase;

import com.ibm.dltj.uima_annotator.AnalyzerContext;
import com.ibm.dltj.uima_annotator.ConfigurationManager;
import com.ibm.dltj.uima_annotator.ResultSpecManager;
import com.ibm.dltj.uima_annotator.TypeSystemManager;
import com.ibm.langware.annotator.Copyright;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public abstract class AnalyzerContext_ImplBase
implements AnalyzerContext {
    private final UimaContext mUimaContext;
    private final Logger mLogger;
    private final boolean mTraceEnabled;
    private final ConfigurationManager mConfigMgr;
    private final TypeSystemManager mTSMgr;
    private final ResultSpecManager mRsltSpecMgr;

    public AnalyzerContext_ImplBase(UimaContext uimaContext) throws ResourceInitializationException {
        this.mUimaContext = uimaContext;
        this.mConfigMgr = this.getNewConfigMgrInstance(uimaContext);
        this.mTSMgr = this.getNewTypeSystemMgrInstance();
        this.mRsltSpecMgr = this.getNewResultSpecMgrInstance();
        this.mLogger = uimaContext.getLogger();
        this.mTraceEnabled = this.mLogger.isLoggable(Level.FINEST);
        this.mConfigMgr.readConfigValues();
    }

    @Override
    public final void setTypeSystem(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mTSMgr.setTypeSystem(typeSystem);
        this.mRsltSpecMgr.setTypeSystem(typeSystem);
        this.mTSMgr.initTypeSystem();
    }

    @Override
    public final void setResultSpec(ResultSpecification resultSpecification) {
        this.mRsltSpecMgr.setResultSpecification(resultSpecification);
    }

    @Override
    public final UimaContext getUimaContext() {
        return this.mUimaContext;
    }

    @Override
    public final ConfigurationManager getConfigurationManager() {
        return this.mConfigMgr;
    }

    @Override
    public final TypeSystemManager getTypeSystemManager() {
        return this.mTSMgr;
    }

    @Override
    public final ResultSpecManager getResultSpecManager() {
        return this.mRsltSpecMgr;
    }

    @Override
    public final boolean isTraceEnabled() {
        return this.mTraceEnabled;
    }

    @Override
    public final void log(Level level, String string) {
        this.mLogger.log(level, string);
    }

    @Override
    public final void logError(Level level, String string, Exception exception) {
        this.mLogger.log(level, string, (Throwable)exception);
    }

    @Override
    public final void logErrorMsg(Level level, String string, String string2, String string3, Exception exception) {
        this.mLogger.logrb(level, string, string2, "com.ibm.langware.annotator.messages", string3, (Throwable)exception);
    }

    @Override
    public final void logMsg(Level level, String string, String string2, String string3) {
        this.mLogger.logrb(level, string, string2, "com.ibm.langware.annotator.messages", string3);
    }

    @Override
    public final void logMsg(Level level, String string, String string2, String string3, Object object) {
        this.mLogger.logrb(level, string, string2, "com.ibm.langware.annotator.messages", string3, object);
    }

    @Override
    public final void logMsg(Level level, String string, String string2, String string3, Object object, Object object2) {
        this.mLogger.logrb(level, string, string2, "com.ibm.langware.annotator.messages", string3, new Object[]{object, object2});
    }

    @Override
    public final void logMsg(Level level, String string, String string2, String string3, Object object, Object object2, Object object3) {
        this.mLogger.logrb(level, string, string2, "com.ibm.langware.annotator.messages", string3, new Object[]{object, object2, object3});
    }

    @Override
    public final void logMsg(Level level, String string, String string2, String string3, Object[] objectArray) {
        this.mLogger.logrb(level, string, string2, "com.ibm.langware.annotator.messages", string3, objectArray);
    }

    protected abstract ConfigurationManager getNewConfigMgrInstance(UimaContext var1);

    protected abstract TypeSystemManager getNewTypeSystemMgrInstance();

    protected abstract ResultSpecManager getNewResultSpecMgrInstance();
}

