/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.util;

import com.ibm.dltj.UniLexAnalyzerConstants;
import com.ibm.icu.util.ULocale;
import com.ibm.langware.annotator.Copyright;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public final class Language {
    private String mISOLangNormalized;
    private String mISOLangNoTerritory;
    private String mISOTerritory;
    private final LanguageType mLangType;

    public Language(String string) {
        this.normalizeLangName(string);
        this.mLangType = Language.determineLangType(this.mISOLangNoTerritory, this.mISOTerritory);
    }

    public String getLanguageFullName() {
        return this.mISOLangNormalized;
    }

    public final String getLanguageWithNoTerritory() {
        return this.mISOLangNoTerritory;
    }

    public final String getTerritory() {
        return this.mISOTerritory;
    }

    public final boolean hasTerritoryInformation() {
        return this.mISOTerritory.length() > 0;
    }

    public final LanguageType getLanguageType() {
        return this.mLangType;
    }

    public final boolean isLanguageOfType(LanguageType languageType) {
        return this.mLangType == languageType;
    }

    public String toString() {
        return this.getLanguageFullName();
    }

    private void normalizeLangName(String string) {
        org.apache.uima.cas.text.Language language = new org.apache.uima.cas.text.Language(string);
        this.mISOLangNoTerritory = language.getLanguagePart().toLowerCase();
        this.mISOTerritory = language.getTerritoryPart() == null ? "" : language.getTerritoryPart().toUpperCase();
        this.mISOLangNormalized = this.mISOLangNoTerritory;
        if (this.mISOTerritory.length() > 0) {
            this.mISOLangNormalized = this.mISOLangNormalized + '-' + this.mISOTerritory;
        }
    }

    private static LanguageType determineLangType(String string, String string2) {
        for (LanguageType languageType : LanguageType.values()) {
            String string3 = ULocale.getLanguage((String)string).toUpperCase();
            if (!languageType.name().equals(string3)) continue;
            if (languageType == LanguageType.KO && string2.toUpperCase().indexOf(UniLexAnalyzerConstants.KOREAN_LEGACY.getVariant()) >= 0) {
                return LanguageType.EU;
            }
            return languageType;
        }
        return LanguageType.EU;
    }

    public static enum LanguageType {
        EU,
        JA,
        ZH,
        KO;

    }
}

