/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.impl;

import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.qa.api.Interpretation;
import com.ibm.smarts.qa.api.InterpretationUnit;
import com.ibm.smarts.qa.api.SemanticAnnotation;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.MatchedEntity;
import com.ibm.smarts.schema.MatchedFeature;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.SemanticSearchResult;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.semanticsearch.impl.AbstractSemanticSearchHandler;
import com.ibm.smarts.semanticsearch.impl.NLUEntityContext;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.impl.SemanticQueryType;
import com.ibm.smarts.semanticsearch.pipeline.AggregateConceptResults;
import com.ibm.smarts.semanticsearch.pipeline.AggregateLexicalAndLemmaResults;
import com.ibm.smarts.semanticsearch.pipeline.ConceptAnnotator;
import com.ibm.smarts.semanticsearch.pipeline.DataValueAnnotator;
import com.ibm.smarts.semanticsearch.pipeline.LemmaSearchAnnotator;
import com.ibm.smarts.semanticsearch.pipeline.LexicalSearchAnnotator;
import com.ibm.smarts.semanticsearch.pipeline.NlpAnnotator;
import com.ibm.smarts.semanticsearch.pipeline.OneQueryConceptSearchAnnotator;
import com.ibm.smarts.semanticsearch.pipeline.TimeAnnotator;
import com.ibm.smarts.semanticsearch.pipeline.ValueQuerySearchAnnotator;
import com.ibm.smarts.semanticsearch.util.SemanticSearchHelper;
import com.ibm.smarts.store.api.provider.IFeatureStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.api.query.IStoreQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticSearchHandler
extends AbstractSemanticSearchHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SemanticSearchHandler.class);
    private static final String ITEM = "item";

    public SemanticSearchHandler(IStoreProvider storeProvider) {
        super(storeProvider);
    }

    public SemanticSearchResult searchWithNluEntities(SearchContext searchContext) {
        searchContext.setStoreProvider(this.storeProvider);
        List<Entity> filteredEntities = searchContext.getNluEntities().stream().filter(entity -> entity.getId().equals("column") || entity.getId().equals("filter") || entity.getId().equals(ITEM)).collect(Collectors.toList());
        Consumer<NLUEntityContext> pipeline = this.buildPipeline(searchContext);
        filteredEntities.forEach(nluEntity -> {
            NLUEntityContext entityContext = searchContext.getEntityContextMap().get(nluEntity);
            pipeline.accept(entityContext);
        });
        return searchContext.getSemanticSearchResult();
    }

    private Consumer<NLUEntityContext> buildPipeline(SearchContext searchContext) {
        return new NlpAnnotator(searchContext).andThen(new LexicalSearchAnnotator(searchContext)).andThen(new LemmaSearchAnnotator(searchContext)).andThen(new AggregateLexicalAndLemmaResults(searchContext)).andThen(new ConceptAnnotator(searchContext)).andThen(new OneQueryConceptSearchAnnotator(searchContext)).andThen(new AggregateConceptResults(searchContext)).andThen(new DataValueAnnotator(searchContext)).andThen(new TimeAnnotator(searchContext)).andThen(new ValueQuerySearchAnnotator(searchContext));
    }

    @Deprecated
    public SemanticSearchResult search(RequestContext req, Interpretation interpretation, String assetTypes, String ... assetRefs) {
        IFeatureStore featureStore = this.storeProvider.getFeatureStore(req);
        IntrimSearchResult intrimResult = this.searchByLexical(req, interpretation, featureStore, assetTypes, assetRefs);
        this.searchByConcept(req, intrimResult, featureStore, assetTypes, assetRefs);
        return this.organizeSearchResult(intrimResult);
    }

    private SemanticSearchResult organizeSearchResult(IntrimSearchResult intrimResult) {
        SemanticSearchResult result = new SemanticSearchResult();
        intrimResult.getIuResults().forEach(iiu -> {
            MatchedEntity entity;
            MatchedEntity matchedEntity = entity = iiu.hasSubPhrase() ? this.constructMatchedEntity((IntrimSearchResultPerIU)iiu) : this.constructMatchedEntity(iiu.getInterpretationUnit());
            if (!iiu.isStopWord() && iiu.hasMatchedFeatures()) {
                List mfs = iiu.getMatchedFeatures().stream().sorted((f1, f2) -> {
                    int r = Float.compare(f2.getScore(), f1.getScore());
                    if (r == 0) {
                        Feature ff1 = f1.getFeature();
                        Feature ff2 = f2.getFeature();
                        r = ff1.getFeatureKey().compareTo(ff2.getFeatureKey());
                        if (r == 0 && (r = Long.compare(ff2.getCreationDate(), ff1.getCreationDate())) == 0) {
                            r = Long.compare(ff2.getLastModifiedDate(), ff1.getLastModifiedDate());
                        }
                    }
                    return r;
                }).collect(Collectors.toList());
                entity.getMatchedFeatures().addAll(mfs);
            }
            result.getMatchedEntity().add(entity);
        });
        return result;
    }

    private IntrimSearchResult searchByLexical(RequestContext req, Interpretation interpretation, IFeatureStore featureStore, String assetTypes, String ... assetRefs) {
        IntrimSearchResult result = new IntrimSearchResult();
        interpretation.getUnits().forEach(unit -> {
            IntrimSearchResultPerIU iiu = new IntrimSearchResultPerIU((InterpretationUnit)unit);
            if (!unit.isStopWord()) {
                String queryString = this.expandQuery(unit.getPhraseInfo(), req);
                IStoreQuery query = SemanticSearchHelper.buildQuery(req, featureStore, queryString, assetTypes, false, SemanticQueryType.ORIG, assetRefs);
                List featureHits = featureStore.executeSearch(query);
                SemanticSearchHelper.debugRawFeatureHits(featureHits, LOGGER, String.format("searchByLexical with query: [%s]", queryString));
                featureHits.forEach(hit -> {
                    MatchedFeature aMatch = this.convertToMatchedFeature((IRecordResult<Feature>)hit);
                    aMatch.setMatchReason(this.evaluateMatchReason(unit.getPhraseInfo(), aMatch.getFeature()));
                    iiu.addMatchedFeature(this.adjustScore(aMatch, queryString, req.locale));
                });
            }
            result.addIntrimSearchResultPerIU(iiu);
        });
        return result;
    }

    private MatchedFeature adjustScore(MatchedFeature aMatch, String queryString, Locale locale) {
        if (aMatch.getMatchReason() == MatchReason.FULL) {
            aMatch.setConfidence(1.0f);
        } else {
            if (MatchReason.PARTIAL_CONCEPT == aMatch.getMatchReason() && FeatureType.COLUMN_NAME == aMatch.getFeatureType()) {
                String query = queryString.toLowerCase(locale);
                try {
                    ColumnInfo col = (ColumnInfo)JAXBHelper.unmarshalFromJSON(ColumnInfo.class, (String)aMatch.getFeature().getColumnInfo());
                    col.getSemanticInfo().getConcepts().stream().filter(c -> query.contains(ConceptsUtil.getConceptName((ConceptInfo)c).toLowerCase(locale))).findFirst().ifPresent(c -> aMatch.setScore(aMatch.getScore() * c.getConfidence()));
                }
                catch (Exception e) {
                    LOGGER.error("unable to unmarshal columnInfo for {}", (Object)aMatch.getFeature().getFeatureKey());
                }
            }
            aMatch.setConfidence((float)(1.0 - Math.exp(-aMatch.getScore())));
        }
        return aMatch;
    }

    private MatchedFeature convertToMatchedFeature(IRecordResult<Feature> hit) {
        MatchedFeature aMatch = new MatchedFeature();
        aMatch.setFeature((Feature)hit.getRecord().getRecord());
        aMatch.setFeatureType(aMatch.getFeature().getFeatureType());
        aMatch.setScore(hit.getScore());
        return aMatch;
    }

    private IntrimSearchResult searchByConcept(RequestContext req, IntrimSearchResult intrimResult, IFeatureStore featureStore, String assetTypes, String ... assetRefs) {
        ArrayList<IntrimSearchResultPerIU> additional = new ArrayList<IntrimSearchResultPerIU>();
        intrimResult.getIuResults().stream().filter(iiu -> iiu.requireSearchByConcept()).forEach(iiu -> {
            List<SemanticAnnotation> saList = SemanticSearchHelper.getSearchableSemanticAnnotations(iiu.getInterpretationUnit());
            saList.forEach(sa -> {
                IStoreQuery query;
                List featureHits;
                String queryString = SemanticSearchHelper.toSearchableQuery(sa);
                if (StringUtils.isNotBlank((CharSequence)queryString) && !(featureHits = featureStore.executeSearch(query = SemanticSearchHelper.buildQuery(req, featureStore, queryString, assetTypes, true, SemanticQueryType.CONCEPT, assetRefs))).isEmpty()) {
                    SemanticSearchHelper.debugRawFeatureHits(featureHits, LOGGER, String.format("searchByConcept with query: [%s]", queryString));
                    IntrimSearchResultPerIU subIiu = new IntrimSearchResultPerIU(iiu.getInterpretationUnit(), sa.getPhraseInfo());
                    featureHits.forEach(hit -> {
                        MatchedFeature aMatch = this.convertToMatchedFeature((IRecordResult<Feature>)hit);
                        aMatch.setMatchReason(MatchReason.PARTIAL_CONCEPT);
                        subIiu.addMatchedFeature(this.adjustScore(aMatch, queryString, req.locale));
                    });
                    additional.add(subIiu);
                }
            });
        });
        if (!additional.isEmpty()) {
            intrimResult.addAllIntrimSearchResultPerIU(additional);
        }
        return intrimResult;
    }

    String expandQuery(PhraseInfo phrase, RequestContext req) {
        String query = phrase.getText();
        if (!this.sameTokenizedToConveredText(phrase, req)) {
            query = String.join((CharSequence)" ", query, phrase.getTokens().stream().map(t -> t.getText()).collect(Collectors.joining(" ")));
        }
        return phrase.getTokens().stream().filter(t -> !t.getText().equalsIgnoreCase(t.getLemma())).map(t -> t.getLemma()).reduce(query, (s1, s2) -> String.join((CharSequence)" ", s1, s2)).trim();
    }

    private boolean sameTokenizedToConveredText(PhraseInfo phrase, RequestContext req) {
        String phraseTextLC = phrase.getText().toLowerCase(req.locale);
        return phrase.getTokens().stream().allMatch(t -> phraseTextLC.contains(t.getText().toLowerCase(req.locale)));
    }

    MatchReason evaluateMatchReason(PhraseInfo phraseInfo, Feature feature) {
        if (!StringUtils.isBlank((CharSequence)phraseInfo.getText()) && phraseInfo.getText().equalsIgnoreCase(feature.getFeatureKey())) {
            return MatchReason.FULL;
        }
        if (phraseInfo.getTokens().stream().anyMatch(t -> SemanticSearchHelper.hasMatchedByToken(feature, t.getText()))) {
            return MatchReason.PARTIAL_NAME;
        }
        if (phraseInfo.getTokens().stream().anyMatch(t -> SemanticSearchHelper.hasMatchedByLemma(feature, t.getLemma()))) {
            return MatchReason.PARTIAL_LEMMA;
        }
        if (phraseInfo.getTokens().stream().anyMatch(t -> SemanticSearchHelper.hasMatchedByConcept(feature, t))) {
            return MatchReason.PARTIAL_CONCEPT;
        }
        return MatchReason.NOT_MATCH;
    }

    private MatchedEntity constructMatchedEntity(IntrimSearchResultPerIU iiu) {
        MatchedEntity matchedEntity = new MatchedEntity();
        matchedEntity.setCoveredText(iiu.getSingleTokenPhrase().getText());
        TokenInfo token = (TokenInfo)iiu.getSingleTokenPhrase().getTokens().get(0);
        int position = token.getPositionInPhrase();
        matchedEntity.setTokenBegin(position);
        matchedEntity.setTokenEnd(position);
        matchedEntity.setCharOffsetBegin(token.getCharOffsetBegin());
        matchedEntity.setCharOffsetEnd(token.getCharOffsetEnd());
        return matchedEntity;
    }

    private MatchedEntity constructMatchedEntity(InterpretationUnit unit) {
        MatchedEntity matchedEntity = new MatchedEntity();
        matchedEntity.setCoveredText(unit.getText());
        matchedEntity.setTokenBegin(unit.getStartIndex());
        matchedEntity.setTokenEnd(unit.getEndIndex());
        matchedEntity.setCharOffsetBegin(unit.getCharOffsetBegin());
        matchedEntity.setCharOffsetEnd(unit.getCharOffsetEnd());
        return matchedEntity;
    }

    private class IntrimSearchResultPerIU {
        private InterpretationUnit iu;
        private PhraseInfo singleTokenPhrase;
        private List<MatchedFeature> matchedFeatures;

        IntrimSearchResultPerIU(InterpretationUnit iu) {
            this.iu = iu;
        }

        public IntrimSearchResultPerIU(InterpretationUnit iu, PhraseInfo phrase) {
            this.iu = iu;
            this.singleTokenPhrase = phrase;
        }

        InterpretationUnit getInterpretationUnit() {
            return this.iu;
        }

        List<MatchedFeature> getMatchedFeatures() {
            return this.matchedFeatures;
        }

        boolean hasSubPhrase() {
            return null != this.singleTokenPhrase;
        }

        boolean isStopWord() {
            return this.iu.isStopWord();
        }

        boolean hasMatchedFeatures() {
            return null != this.matchedFeatures && !this.matchedFeatures.isEmpty();
        }

        boolean requireSearchByConcept() {
            return (!this.hasMatchedFeatures() || this.hasMatchedFeatures() && this.matchedFeatures.stream().noneMatch(m -> MatchReason.FULL == m.getMatchReason())) && SemanticSearchHelper.hasSearchableConcept(this.iu);
        }

        void addMatchedFeature(MatchedFeature f) {
            if (null == this.matchedFeatures) {
                this.matchedFeatures = new ArrayList<MatchedFeature>();
            }
            this.matchedFeatures.add(f);
        }

        PhraseInfo getSingleTokenPhrase() {
            return this.singleTokenPhrase;
        }
    }

    private class IntrimSearchResult {
        private List<IntrimSearchResultPerIU> iuResults = new ArrayList<IntrimSearchResultPerIU>();

        IntrimSearchResult() {
        }

        void addIntrimSearchResultPerIU(IntrimSearchResultPerIU iiu) {
            this.iuResults.add(iiu);
        }

        void addAllIntrimSearchResultPerIU(List<IntrimSearchResultPerIU> iius) {
            this.iuResults.addAll(iius);
        }

        List<IntrimSearchResultPerIU> getIuResults() {
            return this.iuResults;
        }
    }
}

