/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.impl;

import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.core.lifecycle.IComponentLifecycle;
import com.ibm.smarts.core.lifecycle.IComponentLifecycleOperations;
import com.ibm.smarts.core.lifecycle.ILifecycleManager;
import com.ibm.smarts.core.lifecycle.IManagedLifecycle;
import com.ibm.smarts.core.lifecycle.LifecycleManager;
import com.ibm.smarts.core.util.Ensure;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.nlp.core.utility.CharsUtils;
import com.ibm.smarts.ontology.service.KnowledgeDiscoveryService;
import com.ibm.smarts.qa.api.Interpretation;
import com.ibm.smarts.qa.api.QuestionAnalyzer;
import com.ibm.smarts.schema.SemanticSearchResult;
import com.ibm.smarts.semanticsearch.api.SemanticSearchService;
import com.ibm.smarts.semanticsearch.impl.DeepSemanticSearchHandler;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.impl.SemanticSearchContext;
import com.ibm.smarts.semanticsearch.impl.SemanticSearchHandler;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticSearchServiceImpl
implements SemanticSearchService,
IComponentLifecycle,
IManagedLifecycle {
    private LifecycleManager clh;
    private QuestionAnalyzer questionAnalyzer;
    private SemanticSearchHandler semanticSearchHandler;
    private DeepSemanticSearchHandler deepSemanticSearchHandler;
    private SmartNLP nlp;
    private KnowledgeDiscoveryService knowledgeDiscoveryService;
    private static final Logger LOGGER = LoggerFactory.getLogger(SemanticSearchServiceImpl.class);

    public SemanticSearchServiceImpl(QuestionAnalyzer qa, IStoreProvider aStoreProvider) {
        this.questionAnalyzer = qa;
        this.semanticSearchHandler = new SemanticSearchHandler(aStoreProvider);
        this.deepSemanticSearchHandler = new DeepSemanticSearchHandler(aStoreProvider);
        this.clh = new LifecycleManager((IComponentLifecycle)this, new IComponentLifecycleOperations[0]);
    }

    public SemanticSearchServiceImpl(QuestionAnalyzer qa, IStoreProvider aStoreProvider, SmartNLP nlp, KnowledgeDiscoveryService knowledgeDiscoveryService) {
        this.questionAnalyzer = qa;
        this.semanticSearchHandler = new SemanticSearchHandler(aStoreProvider);
        this.deepSemanticSearchHandler = new DeepSemanticSearchHandler(aStoreProvider);
        this.nlp = nlp;
        this.knowledgeDiscoveryService = knowledgeDiscoveryService;
        this.clh = new LifecycleManager((IComponentLifecycle)this, new IComponentLifecycleOperations[0]);
    }

    @Override
    public SemanticSearchResult deepSearch(@Nonnull RequestContext req, @Nonnull String question, @Nullable String assetTypes, String ... assetRefs) {
        Ensure.notNull((String)"request context", (Object)req);
        if (StringUtils.isBlank((CharSequence)question)) {
            return new SemanticSearchResult();
        }
        String questionNoSpecialChar = CharsUtils.preProcessString((String)question);
        String cleanedQuestion = questionNoSpecialChar.trim();
        List interpretations = this.questionAnalyzer.analyze(req, cleanedQuestion);
        if (interpretations != null && !interpretations.isEmpty()) {
            SemanticSearchContext ssc = new SemanticSearchContext(req, cleanedQuestion, (Interpretation)interpretations.get(0), assetTypes, assetRefs);
            SemanticSearchResult result = this.deepSemanticSearchHandler.search(ssc);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Semantic Search NER result for question [{}]\n{}", (Object)cleanedQuestion, (Object)CommonJAXBHelper.marshalToJSON((Object)result, (boolean)true));
            }
            return result;
        }
        LOGGER.error("No interpretation for question [{}]", (Object)cleanedQuestion);
        return new SemanticSearchResult();
    }

    @Override
    public SemanticSearchResult search(RequestContext req, String question, String assetTypes, String ... assetRefs) {
        Ensure.notNull((String)"request context", (Object)req);
        if (StringUtils.isBlank((CharSequence)question)) {
            return new SemanticSearchResult();
        }
        List interpretations = this.questionAnalyzer.analyze(req, question);
        if (interpretations != null && !interpretations.isEmpty()) {
            SemanticSearchResult result = this.semanticSearchHandler.search(req, (Interpretation)interpretations.get(0), assetTypes, assetRefs);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Semantic Search result for question [{}]\n{}", (Object)question, (Object)CommonJAXBHelper.marshalToJSON((Object)result, (boolean)true));
            }
            return result;
        }
        LOGGER.error("No interpretation for question [{}]", (Object)question);
        return new SemanticSearchResult();
    }

    @Override
    public SemanticSearchResult searchWithNluEntities(@Nonnull RequestContext requestContext, @Nonnull List<Entity> nluEntities, @Nullable String assetTypes, String ... assetRefs) {
        Ensure.notNull((String)"request context", (Object)requestContext);
        if (nluEntities.isEmpty()) {
            return new SemanticSearchResult();
        }
        SearchContext searchContext = new SearchContext(requestContext, nluEntities, assetTypes, assetRefs);
        searchContext.setNlp(this.nlp);
        searchContext.setKnowledgeDiscoveryService(this.knowledgeDiscoveryService);
        SemanticSearchResult result = this.semanticSearchHandler.searchWithNluEntities(searchContext);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Semantic Search result for nlu entities]\n{}", (Object)CommonJAXBHelper.marshalToJSON((Object)result, (boolean)true));
        }
        return result;
    }

    public ILifecycleManager getLifecycleManager() {
        return this.clh;
    }

    public void initialize(RequestContext rc) {
        LOGGER.info("<TCL> Component initialize SemanticSearchService");
    }

    public void shutDown(RequestContext rc) {
        LOGGER.info("<TCL> Component shutdown SemanticSearchService");
    }

    QuestionAnalyzer getQuestionAnalyzer() {
        return this.questionAnalyzer;
    }

    public SemanticSearchHandler getSemanticSearchHandler() {
        return this.semanticSearchHandler;
    }

    DeepSemanticSearchHandler getDeepSemanticSearchHandler() {
        return this.deepSemanticSearchHandler;
    }
}

