/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.pipeline;

import com.ibm.smarts.nlp.api.grammar.PartOfSpeech;
import com.ibm.smarts.nlp.api.grammar.Significance;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.semanticsearch.impl.NLUEntityContext;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.pipeline.IAnnotator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptAnnotator
implements IAnnotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConceptAnnotator.class);
    private SearchContext searchContext;

    public ConceptAnnotator(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    public TextInfo toTextInfo(NLUEntityContext nluContext) {
        TextInfo ti = new TextInfo();
        ti.setLanguage(this.searchContext.getReqCtx().locale.getLanguage());
        ti.getPhrases().add(nluContext.getNluPhraseInfo());
        return ti;
    }

    @Override
    public void accept(NLUEntityContext nluContext) {
        boolean requireSemanticAnalysis;
        PhraseInfo phraseInfo = nluContext.getNluPhraseInfo();
        boolean isStopWord = phraseInfo.getTokens().size() == 1 && ((TokenInfo)phraseInfo.getTokens().get(0)).getSignificance() <= Significance.LOW;
        boolean isDidit = phraseInfo.getTokens().size() == 1 && PartOfSpeech.CD.name().equals(((TokenInfo)phraseInfo.getTokens().get(0)).getPOSlocal());
        boolean bl = requireSemanticAnalysis = !isStopWord && !isDidit;
        if (requireSemanticAnalysis) {
            TextInfo textInfo = this.toTextInfo(nluContext);
            List<ConceptInfo> concepts = this.searchContext.getKnowledgeDiscoveryService().getTextConceptClassifier().classify(this.searchContext.getReqCtx(), textInfo).stream().flatMap(Collection::stream).collect(Collectors.toList());
            nluContext.setConcepts(concepts);
        }
    }
}

