/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.pipeline;

import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.MatchedFeature;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.semanticsearch.impl.NLUEntityContext;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.impl.SemanticQueryType;
import com.ibm.smarts.semanticsearch.pipeline.IAnnotator;
import com.ibm.smarts.semanticsearch.util.SemanticSearchHelper;
import com.ibm.smarts.store.api.provider.IFeatureStore;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.api.query.IStoreQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueQuerySearchAnnotator
implements IAnnotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueQuerySearchAnnotator.class);
    private SearchContext searchContext;
    private static final float FEATURE_SCORE_WEIGHT = 0.25f;
    private static final String GEOGRAPHY_CONCEPT = "Geography";
    private static final float MAX_CONFIDENCE = 1.0f;
    private static final String SPACE = " ";
    Predicate<IRecordResult<Feature>> isValidFilter = feature -> {
        String colInfoString = ((Feature)feature.getRecord().getRecord()).getColumnInfo();
        boolean isValid = true;
        try {
            if (((Feature)feature.getRecord().getRecord()).getSearchableConcepts().contains(GEOGRAPHY_CONCEPT)) {
                ColumnInfo columnInfo = (ColumnInfo)JAXBHelper.unmarshalFromJSON(ColumnInfo.class, (String)colInfoString);
                isValid = columnInfo.getDataType().isString();
            }
        }
        catch (IOException exc) {
            LOGGER.error("Error in geography isString filter");
        }
        return isValid;
    };

    public ValueQuerySearchAnnotator(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    @Override
    public void accept(NLUEntityContext entityContext) {
        String text = String.join((CharSequence)SPACE, entityContext.getHighestConceptScoreMap().keySet());
        LOGGER.info("value to question ==> " + text);
        if (StringUtils.isBlank((CharSequence)text)) {
            return;
        }
        EnumMap<SemanticSearchHelper.QueryFields, Float> boostFactorMap = ValueQuerySearchAnnotator.getOverrideBoostFactors();
        IFeatureStore featureStore = this.searchContext.getStoreProvider().getFeatureStore(this.searchContext.getReqCtx());
        IStoreQuery query = SemanticSearchHelper.buildQuery(this.searchContext.getReqCtx(), featureStore, text, this.searchContext.getAssetTypes(), this.searchContext.isInDataValue(), SemanticQueryType.VALUE, this.searchContext.getAssetRefs(), boostFactorMap);
        List<IRecordResult<Feature>> featureHits = featureStore.executeSearch(query).stream().filter(f -> ((Feature)f.getRecord().getRecord()).getFeatureType().equals((Object)FeatureType.COLUMN_NAME) && this.isValidFilter.test((IRecordResult<Feature>)f)).collect(Collectors.toList());
        SemanticSearchHelper.debugRawFeatureHits(featureHits, LOGGER, String.format("querySearch with query: [%s]", text));
        if (featureHits.isEmpty()) {
            return;
        }
        ArrayList<MatchedFeature> allMatchedFeatures = new ArrayList<MatchedFeature>();
        for (int i = 0; i < featureHits.size(); ++i) {
            MatchedFeature aMatch = SemanticSearchHelper.convertToMatchedFeature(featureHits.get(i));
            aMatch.setMatchReason(MatchReason.DATA_VALUE);
            aMatch.setScore(featureHits.get(i).getScore());
            aMatch.setConfidence(this.adjustConfidence(SemanticSearchHelper.normalize(aMatch.getScore()), ((Feature)featureHits.get(i).getRecord().getRecord()).getSearchableConcepts(), entityContext.getHighestConceptScoreMap()));
            allMatchedFeatures.add(aMatch);
        }
        entityContext.getMatchedFeatures().addAll(allMatchedFeatures);
    }

    private float adjustConfidence(float normalizedHitScore, List<String> searchableConceptsForHit, Map<String, Float> highestConceptScoreMap) {
        float adjustedConfidence = normalizedHitScore;
        Optional<String> conceptMatch = searchableConceptsForHit.stream().filter(highestConceptScoreMap::containsKey).findFirst();
        if (conceptMatch.isPresent()) {
            adjustedConfidence = 0.25f * normalizedHitScore + 0.75f * highestConceptScoreMap.get(conceptMatch.get()).floatValue();
        }
        return Math.min(adjustedConfidence, 1.0f);
    }

    private static EnumMap<SemanticSearchHelper.QueryFields, Float> getOverrideBoostFactors() {
        EnumMap<SemanticSearchHelper.QueryFields, Float> overrideMap = new EnumMap<SemanticSearchHelper.QueryFields, Float>(SemanticSearchHelper.QueryFields.class);
        overrideMap.put(SemanticSearchHelper.QueryFields.FEATUREKEY, Float.valueOf(1.0f));
        overrideMap.put(SemanticSearchHelper.QueryFields.FEATUREKEY_TOKENIZED, Float.valueOf(1.0f));
        overrideMap.put(SemanticSearchHelper.QueryFields.FEATUREKEY_LEMMA, Float.valueOf(1.0f));
        overrideMap.put(SemanticSearchHelper.QueryFields.FEATUREKEY_LC, Float.valueOf(1.0f));
        overrideMap.put(SemanticSearchHelper.QueryFields.SEARCHABLE_CONCEPTS, Float.valueOf(2.0f));
        return overrideMap;
    }
}

