/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.recommendationmodel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.ibm.bi.recommendationmodel.Concept;
import com.ibm.bi.recommendationmodel.StatisticBucket;
import com.ibm.bi.recommendationmodel.StatisticBucketRange;
import com.ibm.bi.recommendationmodel.StatisticType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Column {
    private List<StatisticBucket> distinctCount = new ArrayList<StatisticBucket>();
    private List<StatisticBucket> density = new ArrayList<StatisticBucket>();
    private List<StatisticBucket> min = new ArrayList<StatisticBucket>();
    private List<StatisticBucket> max = new ArrayList<StatisticBucket>();
    private Map<String, Concept> conceptMapping;
    private int conceptHierarchyFrequency;
    private int columnCount;
    private Map<Integer, Double> autoGrouping = new HashMap<Integer, Double>();

    protected Column() {
        this.conceptMapping = new HashMap<String, Concept>();
        this.conceptHierarchyFrequency = 0;
        this.columnCount = 0;
        this.autoGrouping = new HashMap<Integer, Double>();
        for (Map.Entry<Double, Double> entry : StatisticBucketRange.DISTINCT_COUNT.entrySet()) {
            this.distinctCount.add(new StatisticBucket(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<Double, Double> entry : StatisticBucketRange.DENSITY.entrySet()) {
            this.density.add(new StatisticBucket(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<Double, Double> entry : StatisticBucketRange.MIN.entrySet()) {
            this.min.add(new StatisticBucket(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<Double, Double> entry : StatisticBucketRange.MAX.entrySet()) {
            this.max.add(new StatisticBucket(entry.getKey(), entry.getValue()));
        }
    }

    protected Column(Column column, Double freqWeight) {
        this.conceptHierarchyFrequency = (int)Math.round((double)column.getConceptHierarchyFrequency() * freqWeight);
        this.columnCount = column.getColumnCount();
        this.conceptMapping = new HashMap<String, Concept>();
        this.autoGrouping = new HashMap<Integer, Double>();
        for (Concept concept : column.getConcepts()) {
            String string = concept.getConceptId();
            Concept concept2 = new Concept(concept, freqWeight);
            this.conceptMapping.putIfAbsent(string, concept2);
        }
        List<StatisticBucket> distinctCountBucket = column.getDistinctCount();
        this.distinctCount = new ArrayList<StatisticBucket>();
        if (distinctCountBucket != null) {
            for (StatisticBucket statisticBucket : distinctCountBucket) {
                this.distinctCount.add(new StatisticBucket(statisticBucket, freqWeight));
            }
        }
        List<StatisticBucket> list = column.getDensity();
        this.density = new ArrayList<StatisticBucket>();
        if (list != null) {
            for (StatisticBucket statisticBucket : list) {
                this.density.add(new StatisticBucket(statisticBucket, freqWeight));
            }
        }
        List<StatisticBucket> list2 = column.getMin();
        this.min = new ArrayList<StatisticBucket>();
        if (list2 != null) {
            for (StatisticBucket mn : list2) {
                this.min.add(new StatisticBucket(mn, freqWeight));
            }
        }
        List<StatisticBucket> list3 = column.getMax();
        this.max = new ArrayList<StatisticBucket>();
        if (list3 != null) {
            for (StatisticBucket statisticBucket : list3) {
                this.max.add(new StatisticBucket(statisticBucket, freqWeight));
            }
        }
        if (column.getAutoGrouping() != null) {
            for (Map.Entry entry : column.getAutoGrouping().entrySet()) {
                this.autoGrouping.put((Integer)entry.getKey(), (Double)entry.getValue() * freqWeight);
            }
        }
    }

    public void incrementStatistic(StatisticType statisticType, Double value) {
        if (statisticType != null) {
            switch (statisticType) {
                case DISTINCT_COUNT: {
                    this.incrementBucketFrequency(value, this.distinctCount);
                    break;
                }
                case DENSITY: {
                    this.incrementBucketFrequency(value, this.density);
                    break;
                }
                case MIN_VALUE: {
                    this.incrementBucketFrequency(value, this.min);
                    break;
                }
                case MAX_VALUE: {
                    this.incrementBucketFrequency(value, this.max);
                    break;
                }
            }
        }
    }

    private void incrementBucketFrequency(Double statistic, List<StatisticBucket> buckets) {
        if (statistic == null) {
            return;
        }
        for (StatisticBucket bucket : buckets) {
            if (!bucket.isValueWithinRange(statistic).booleanValue()) continue;
            bucket.incrementFrequency();
            break;
        }
    }

    protected void setDistinctCount(List<StatisticBucket> distinctCount) {
        this.distinctCount = distinctCount;
    }

    protected void setDensity(List<StatisticBucket> density) {
        this.density = density;
    }

    protected void setMin(List<StatisticBucket> min) {
        this.min = min;
    }

    protected void setMax(List<StatisticBucket> max) {
        this.max = max;
    }

    public void addConcepts(List<String> conceptIds) {
        for (String conceptId : conceptIds) {
            if (this.conceptMapping.putIfAbsent(conceptId, new Concept(conceptId)) == null) continue;
            this.conceptMapping.get(conceptId).incrementFrequency();
        }
    }

    private void addConcept(Concept concept) {
        this.conceptMapping.putIfAbsent(concept.getConceptId(), concept);
    }

    private Concept getConcept(String conceptId) {
        return this.conceptMapping.get(conceptId);
    }

    public void incrementConceptHierarchyFrequency() {
        ++this.conceptHierarchyFrequency;
    }

    protected void setColumnCount(int count) {
        this.columnCount = count;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    @JsonCreator
    protected Column(@JsonProperty(value="distinctCount") List<StatisticBucket> distinctCount, @JsonProperty(value="density") List<StatisticBucket> density, @JsonProperty(value="min") List<StatisticBucket> min, @JsonProperty(value="max") List<StatisticBucket> max, @JsonProperty(value="conceptHierarchyFrequency") int conceptHierarchyFrequency) {
        if (distinctCount != null) {
            this.distinctCount = distinctCount;
        }
        if (density != null) {
            this.density = density;
        }
        if (min != null) {
            this.min = min;
        }
        if (max != null) {
            this.max = max;
        }
        this.conceptHierarchyFrequency = conceptHierarchyFrequency;
        this.conceptMapping = new HashMap<String, Concept>();
        this.autoGrouping = new HashMap<Integer, Double>();
    }

    @JsonGetter
    public List<StatisticBucket> getDistinctCount() {
        return this.distinctCount;
    }

    @JsonGetter
    public List<StatisticBucket> getDensity() {
        return this.density;
    }

    @JsonGetter
    public List<StatisticBucket> getMin() {
        return this.min;
    }

    @JsonGetter
    public List<StatisticBucket> getMax() {
        return this.max;
    }

    @JsonGetter
    public Collection<Concept> getConcepts() {
        return this.conceptMapping.values();
    }

    @JsonGetter
    public int getConceptHierarchyFrequency() {
        return this.conceptHierarchyFrequency;
    }

    @JsonSetter(value="concepts")
    protected void setConceptMapping(List<Concept> concepts) {
        for (Concept concept : concepts) {
            this.conceptMapping.putIfAbsent(concept.getConceptId(), concept);
        }
    }

    public void addAutoGroupingEntry(int groupCount) {
        this.addAutoGroupingEntry(groupCount, 1.0);
    }

    protected void addAutoGroupingEntry(int groupCount, double frequency) {
        Double existingFrequency = this.autoGrouping.get(groupCount);
        if (existingFrequency == null) {
            this.autoGrouping.put(groupCount, frequency);
        } else {
            this.autoGrouping.put(groupCount, (double)existingFrequency.intValue() + frequency);
        }
    }

    @JsonGetter
    public Map<Integer, Double> getAutoGrouping() {
        return this.autoGrouping;
    }

    protected void setConceptHierarchyFrequency(int conceptHierarchyFrequency) {
        this.conceptHierarchyFrequency = conceptHierarchyFrequency;
    }

    protected void merge(Column sourceColumns) {
        for (Concept concept : sourceColumns.getConcepts()) {
            Concept targetConcept = this.getConcept(concept.getConceptId());
            if (targetConcept != null) {
                targetConcept.merge(concept);
                continue;
            }
            this.addConcept(concept);
        }
        this.mergeColumnStatBuckets(this.getDistinctCount(), sourceColumns.getDistinctCount());
        this.mergeColumnStatBuckets(this.getMax(), sourceColumns.getMax());
        this.mergeColumnStatBuckets(this.getMin(), sourceColumns.getMin());
        this.mergeColumnStatBuckets(this.getDensity(), sourceColumns.getDensity());
        this.conceptHierarchyFrequency += sourceColumns.getConceptHierarchyFrequency();
        for (Map.Entry entry : sourceColumns.getAutoGrouping().entrySet()) {
            this.addAutoGroupingEntry((Integer)entry.getKey(), (Double)entry.getValue());
        }
    }

    private void mergeColumnStatBuckets(List<StatisticBucket> targetBucketList, List<StatisticBucket> sourceBucketList) {
        for (StatisticBucket sourceStatisticBucket : sourceBucketList) {
            StatisticBucket mergeCandidate = this.getEqualStatisticBucket(sourceStatisticBucket, targetBucketList);
            if (mergeCandidate != null) {
                mergeCandidate.merge(sourceStatisticBucket);
                continue;
            }
            targetBucketList.add(sourceStatisticBucket);
        }
    }

    private StatisticBucket getEqualStatisticBucket(StatisticBucket statisticBucket, List<StatisticBucket> targetStatisticBuckets) {
        for (StatisticBucket targetStatisticBucket : targetStatisticBuckets) {
            if (!targetStatisticBucket.isEqual(statisticBucket).booleanValue()) continue;
            return targetStatisticBucket;
        }
        return null;
    }
}

