/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.stages.SimpleStageExecutor;

public class ReasonerFactory {
    static final Logger LOGGER_ = Logger.getLogger(ReasonerFactory.class);
    static final ReasonerStageExecutor DEFAULT_STAGE_EXECUTOR = new SimpleStageExecutor();

    public Reasoner createReasoner(AxiomLoader axiomLoader) {
        return this.createReasoner(axiomLoader, DEFAULT_STAGE_EXECUTOR, ReasonerConfiguration.getConfiguration());
    }

    public Reasoner createReasoner(AxiomLoader axiomLoader, ReasonerStageExecutor stageExecutor) {
        return this.createReasoner(axiomLoader, stageExecutor, ReasonerConfiguration.getConfiguration());
    }

    public Reasoner createReasoner(AxiomLoader axiomLoader, ReasonerStageExecutor stageExecutor, ReasonerConfiguration config) {
        return this.createReasoner(axiomLoader, stageExecutor, Executors.newCachedThreadPool(), config);
    }

    public Reasoner createReasoner(AxiomLoader axiomLoader, ReasonerStageExecutor stageExecutor, ExecutorService executor, ReasonerConfiguration config) {
        Reasoner reasoner = new Reasoner(axiomLoader, stageExecutor, executor);
        reasoner.setConfigurationOptions(config);
        return reasoner;
    }
}

