/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.IConfiguration;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.res.MessageSet;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class CAMStatusHandler {
    static IPFTraceLogger caTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CA");
    private static CAMStatusHandler singleton = null;
    private Properties defaults;
    private Properties current;
    private static String STATUS_FILENAME;

    private CAMStatusHandler() throws CAMCryptoException {
        caTraceLogger.logEnter();
        IConfiguration config = Configuration.getInstance();
        if (config == null) {
            config = Configuration.getInstanceWithDefaultConfig(false);
        }
        String statusFileLocation = config.getCertificateDirectory() + File.separator + "CAMCrypto.status";
        STATUS_FILENAME = CCLConfigurationFactory.getInstance().resolveEffectivePath(statusFileLocation);
        this.defaults = new Properties();
        this.defaults.put("version", "1");
        this.defaults.put("keystoreFreshness.value", "0");
        this.current = new Properties();
        try {
            this.current.load(new BufferedInputStream(new FileInputStream(STATUS_FILENAME)));
        }
        catch (Exception e) {
            this.current = this.defaults;
            this.writeStatusFile();
        }
        caTraceLogger.logExit(true);
    }

    public static synchronized CAMStatusHandler getInstance() throws CAMCryptoException {
        caTraceLogger.logEnter();
        if (singleton == null) {
            singleton = new CAMStatusHandler();
        }
        caTraceLogger.logExit(true);
        return singleton;
    }

    public synchronized Integer getKeystoreFreshness() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Integer i = null;
        try {
            String fStr = this.current.getProperty("keystoreFreshness.value");
            i = new Integer(fStr);
        }
        catch (NumberFormatException nfe) {
            caTraceLogger.fatalException("CAMStatusHandler.getKeystoreFreshness: problem loading keystore freshness file. Reverting to defaults and resaving.", nfe);
            this.current = this.defaults;
            this.writeStatusFile();
            String fStr = this.current.getProperty("keystoreFreshness.value");
            i = fStr != null ? new Integer(fStr) : Integer.valueOf(0);
        }
        caTraceLogger.logExit(i.toString());
        return i;
    }

    public synchronized void addKeystoreFreshness() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Integer keystoreFreshness = this.getKeystoreFreshness();
        Integer newKeystoreFreshness = keystoreFreshness + 1;
        String szFreshness = newKeystoreFreshness.toString();
        this.current.setProperty("keystoreFreshness.value", szFreshness);
        this.writeStatusFile();
        caTraceLogger.logExit(true);
    }

    private synchronized void writeStatusFile() throws CAMCryptoException {
        caTraceLogger.logEnter();
        try {
            File fCam;
            File f = new File(STATUS_FILENAME);
            if (!f.exists() && !(fCam = f.getParentFile()).exists()) {
                File fTemp = fCam.getParentFile();
                if (!fTemp.exists()) {
                    fTemp.mkdir();
                }
                fCam.mkdir();
            }
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_fresh_setupwrite_error"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        try {
            FileOutputStream fos = new FileOutputStream(STATUS_FILENAME);
            this.current.store(fos, "CAM Status");
            fos.close();
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_fresh_write_error"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        caTraceLogger.logExit(true);
    }
}

