/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.utilities;

import com.cognos.accman.jcam.crypto.BATrustedRequestSession;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.utilities.CAMHttpClient;
import com.cognos.accman.jcam.utilities.EnvironmentChecks;
import com.cognos.accman.jcam.utilities.FileSignerTool;
import com.cognos.accman.jcam.utilities.JCAMEchoClient;
import com.cognos.accman.jcam.utilities.JCAMEchoServer;
import com.cognos.accman.jcam.utilities.KeyStoreTools;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;

public class JCAMToolbox {
    public static final String CSK_KEYS = "CSK Keys";
    public static final String CSK_KEYS_description = "List up all the names of CSK keys in your local CSK key store\n";
    public static final String CA_CERTS = "CA certificates";
    public static final String CA_CERTS_description = "List up all trusted CA certificates in your trust store.\n";
    public static final String ENC_CERTS = "Encryption certificates";
    public static final String ENC_CERTS_description = "Show encryption certificate or certificate chain. The encryption certificates are used for SSL and requesting newest CSK from Content Manager.\n";
    public static final String SIGN_CERTS = "Signing certificates";
    public static final String SIGN_CERTS_decription = "Show signing certificate or certificate chain. The signing certificates are used for requesting newest CSK from Content Manager.\n";
    public static final String CHECK_URLS = "Check Cognos Analytics connection URLs";
    public static final String CHECK_URLS_description = "Check connection URLs in configuration XML.\n";
    public static final String LOAD_LIBRARY = "Load CAM libraries";
    public static final String LOAD_JNI_LIBRARY_description = "Load and check CAMCrypto JNI libiary.\n";
    public static final String RUN_ALL = "Run all above commands";
    public static final String RUN_ALL_description = "Run all diagnose tests and save the results to a text file named 'camcrypto_diagnose.txt' at the same location of the CAMTool command. This may take several minutes.\n";

    private static void printUsage() {
        System.out.println("\nJCAMToolbox Usage::\n    -CSKKeys                 :List up all the names of CSK keys in your local CSK key store\n    -CACertificates          :List up all trusted CA certificates in your trust store.\n    -EncryptionCertificates  :Show encryption certificate or certificate chain. The encryption certificates are used for SSL and requesting newest CSK from Content Manager.\n    -SigningCertificates     :Show signing certificate or certificate chain. The signing certificates are used for requesting newest CSK from Content Manager.\n    -CheckConnectionURLs     :Check connection URLs in configuration XML.\n    -LoadJNILibrary          :Load and check CAMCrypto JNI libiary.\n    -RunAll                  :Run all diagnose tests and save the results to a text file named 'camcrypto_diagnose.txt' at the same location of the CAMTool command. This may take several minutes.\n    -signfile file keystore  : sign a text file using the private key in keystore\n    -createkeystores [true]  : creare CAM key stores, overwrite files = true, over keypairs = false\n    -createAndAddNewCACert   : create and add a new CA certificate into jCAKeystore\n    -JCAMEchoServer url      : run JCAMEchoServer to test SSL\n    -JCAMEchoClient url      : run JCAMEchoClient to connect to JCAMEchoServer to test SSL\n    -checkCertificateTrusted : check certificate is trusted\n    -checkTrustToken         : check a trust token generated by jcam in commons-core jar is trusted\n\nExamples:\n    JCAMToolbox.bat -CSKKeys\n    JCAMToolbox.bat -CheckConnectionURLs\n    JCAMToolbox.bat -checkCertificateTrusted pem.cer\n    JCAMToolbox.bat -createkeystores true\n    JCAMToolbox.bat -checkTrustToken TrustedToken.txt\n    JCAMToolbox.bat -JCAMEchoServer https://localhost:9301/\n    JCAMToolbox.bat -JCAMEchoClient https://localhost:9301/\n\n");
    }

    public static void main(String[] args) {
        block93: {
            String filename;
            URL url;
            KeyStoreTools keystoreTools;
            String arg1 = "";
            String arg2 = "";
            String arg3 = "";
            String arg4 = "";
            if (args.length == 1) {
                arg1 = new String(args[0]);
            } else if (args.length == 2) {
                arg1 = new String(args[0]);
                arg2 = new String(args[1]);
            } else if (args.length == 3) {
                arg1 = new String(args[0]);
                arg2 = new String(args[1]);
                arg3 = new String(args[2]);
            } else if (args.length == 4) {
                arg1 = new String(args[0]);
                arg2 = new String(args[1]);
                arg3 = new String(args[2]);
                arg4 = new String(args[3]);
            } else {
                JCAMToolbox.printUsage();
                return;
            }
            System.out.println("**  Start JCAM Toolbox ...");
            boolean bCAMToolCommand = false;
            StringBuffer ret = new StringBuffer();
            if (arg1.compareTo("-CSKKeys") == 0 || arg1.compareTo("-RunAll") == 0) {
                if (args.length != 1) {
                    JCAMToolbox.printUsage();
                    return;
                }
                bCAMToolCommand = true;
                try {
                    keystoreTools = new KeyStoreTools();
                    String jCSKKeys = keystoreTools.getAllCSKKeysFromjCSKKeystore();
                    String cCSKKeys = keystoreTools.getAllCSKKeysFromCAMCSKKeystore();
                    if (arg1.compareTo("-RunAll") == 0) {
                        JCAMToolbox.appendTitle(CSK_KEYS, ret);
                    }
                    ret.append("\nCSK keys in Java CSK keystore (jCSKKeystore)\n");
                    ret.append(jCSKKeys);
                    ret.append("\nCSK keys in CAM CSK keystore (cCSKKeystore)\n");
                    ret.append(cCSKKeys);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (arg1.compareTo("-CACertificates") == 0 || arg1.compareTo("-RunAll") == 0) {
                if (args.length != 1) {
                    JCAMToolbox.printUsage();
                    return;
                }
                bCAMToolCommand = true;
                try {
                    keystoreTools = new KeyStoreTools();
                    String caCerts = keystoreTools.getCACertificates();
                    if (arg1.compareTo("-RunAll") == 0) {
                        JCAMToolbox.appendTitle(CA_CERTS, ret);
                    }
                    ret.append(caCerts);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (arg1.compareTo("-EncryptionCertificates") == 0 || arg1.compareTo("-RunAll") == 0) {
                if (args.length != 1) {
                    JCAMToolbox.printUsage();
                    return;
                }
                bCAMToolCommand = true;
                try {
                    keystoreTools = new KeyStoreTools();
                    String encCerts = keystoreTools.getEncCertificates();
                    if (arg1.compareTo("-RunAll") == 0) {
                        JCAMToolbox.appendTitle(ENC_CERTS, ret);
                    }
                    ret.append(encCerts);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (arg1.compareTo("-SigningCertificates") == 0 || arg1.compareTo("-RunAll") == 0) {
                if (args.length != 1) {
                    JCAMToolbox.printUsage();
                    return;
                }
                bCAMToolCommand = true;
                try {
                    keystoreTools = new KeyStoreTools();
                    String signCerts = keystoreTools.getSignCertificates();
                    if (arg1.compareTo("-RunAll") == 0) {
                        JCAMToolbox.appendTitle(SIGN_CERTS, ret);
                    }
                    ret.append(signCerts);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (arg1.compareTo("-CheckConnectionURLs") == 0 || arg1.compareTo("-RunAll") == 0) {
                String urlString = "";
                if (args.length != 1) {
                    if (args.length == 2) {
                        urlString = arg2;
                    } else {
                        JCAMToolbox.printUsage();
                        return;
                    }
                }
                bCAMToolCommand = true;
                try {
                    CAMHttpClient camHttpClient = new CAMHttpClient();
                    String checkResult = camHttpClient.testSendingFreshnessRequest();
                    if (arg1.compareTo("-RunAll") == 0) {
                        JCAMToolbox.appendTitle(CHECK_URLS, ret);
                    }
                    ret.append(checkResult);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (arg1.compareTo("-LoadJNILibrary") == 0 || arg1.compareTo("-RunAll") == 0) {
                if (args.length != 1) {
                    JCAMToolbox.printUsage();
                    return;
                }
                bCAMToolCommand = true;
                try {
                    EnvironmentChecks environmentChecks = new EnvironmentChecks();
                    String checkResult = environmentChecks.loadLibraries();
                    if (arg1.compareTo("-RunAll") == 0) {
                        JCAMToolbox.appendTitle(LOAD_LIBRARY, ret);
                    }
                    ret.append(checkResult);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (bCAMToolCommand) {
                if (arg1.compareTo("-RunAll") == 0) {
                    JCAMToolbox.printToFile(ret);
                    System.out.println("Diagnose results have been written to file named 'camcrypto_diagnose.txt'. \n");
                } else {
                    System.out.print(ret);
                }
                return;
            }
            if (arg1.compareTo("-signfile") == 0) {
                if (args.length != 4) {
                    JCAMToolbox.printUsage();
                    return;
                }
                FileSignerTool fileSigner = new FileSignerTool();
                try {
                    fileSigner.signFile(arg2, arg3, arg4);
                    fileSigner.verifyFile(arg2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (arg1.compareTo("-JCAMEchoServer") == 0) {
                url = null;
                if (args.length == 2) {
                    try {
                        url = new URL(arg2);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                } else {
                    JCAMToolbox.printUsage();
                    return;
                }
                JCAMEchoServer jcamEchoServer = new JCAMEchoServer();
                try {
                    jcamEchoServer.start(url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (arg1.compareTo("-JCAMEchoClient") == 0) {
                url = null;
                if (args.length == 2) {
                    try {
                        url = new URL(arg2);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                } else {
                    JCAMToolbox.printUsage();
                    return;
                }
                JCAMEchoClient jcamEchoClient = new JCAMEchoClient();
                try {
                    jcamEchoClient.start(url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (arg1.compareTo("-createkeystores") == 0) {
                boolean overideCurrentKeyPairs = false;
                boolean overwriteCurrentFiles = true;
                if (args.length != 1) {
                    if (args.length == 2) {
                        overideCurrentKeyPairs = arg1.compareToIgnoreCase("true") == 0;
                    } else if (args.length == 3) {
                        overideCurrentKeyPairs = arg2.compareToIgnoreCase("true") == 0;
                        overwriteCurrentFiles = arg3.compareToIgnoreCase("true") == 0;
                    } else {
                        JCAMToolbox.printUsage();
                        return;
                    }
                }
                KeyStoreTools keystoreTools2 = new KeyStoreTools();
                try {
                    keystoreTools2.createNewKeystores(overideCurrentKeyPairs, overwriteCurrentFiles);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (arg1.compareTo("-createAndAddNewCACert") == 0) {
                if (args.length != 1) {
                    JCAMToolbox.printUsage();
                    return;
                }
                keystoreTools = new KeyStoreTools();
                try {
                    keystoreTools.createNewCACertAndAddToKeystores();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (arg1.compareTo("-checkCertificateTrusted") == 0) {
                if (args.length != 2) {
                    JCAMToolbox.printUsage();
                    return;
                }
                filename = arg2;
                KeyStoreTools keystoreTools3 = new KeyStoreTools();
                try {
                    boolean isTrusted;
                    Collection certs = CAMCryptoUtilities.getCertificatesFromFile(filename);
                    Iterator thisCert = certs.iterator();
                    X509Certificate cert = null;
                    if (thisCert.hasNext()) {
                        cert = (X509Certificate)thisCert.next();
                    }
                    if (isTrusted = keystoreTools3.checkCertificateTrusted(cert)) {
                        System.out.print("\n\n");
                        System.out.print(cert.toString());
                        System.out.println("\n\n       @@@@@@@@@@@@@@@@@@@@ Certificate is trusted @@@@@@@@@@@@@@@@@@@@\n\n");
                        break block93;
                    }
                    System.out.print("\n\n");
                    System.out.println("Certificate is not trusted:");
                    System.out.println("\n\n       ???????????????????? Certificate is not trusted ????????????????????\n\n");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (arg1.compareTo("-checkTrustToken") == 0) {
                if (args.length != 2) {
                    JCAMToolbox.printUsage();
                    return;
                }
                filename = arg2;
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(filename));
                    String token = reader.readLine();
                    while (token != null) {
                        CAMFactory cf = new CAMFactory();
                        cf.initialize("<initializeDocument><serviceID>CAM</serviceID></initializeDocument>".getBytes());
                        BATrustedRequestSession bats = cf.createBATrustedSession();
                        boolean isTrusted = bats.verifyToken(token);
                        if (isTrusted) {
                            System.out.println("The token is trusted: " + token);
                        } else {
                            System.out.println("The token is not trusted: " + token);
                        }
                        token = reader.readLine();
                    }
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                JCAMToolbox.printUsage();
            }
        }
    }

    public static void appendTitle(String title, StringBuffer ret) {
        ret.append("\n\n\n---------------------- " + title + " ----------------------\n\n");
    }

    public static void printToFile(StringBuffer ret) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Calendar cal = Calendar.getInstance();
            try {
                int c;
                FileOutputStream fo = new FileOutputStream("camcrypto_diagnose.txt");
                PrintWriter pw = new PrintWriter(fo);
                pw.println(dateFormat.format(cal.getTime()));
                ByteArrayInputStream in = new ByteArrayInputStream(ret.toString().getBytes());
                StringBuffer line = new StringBuffer();
                while ((c = in.read()) != -1) {
                    if (c != 10) {
                        line.append((char)c);
                        continue;
                    }
                    pw.println(new String(line));
                    line.delete(0, line.length());
                }
                pw.close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

