/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.questionanalyzer.core.workflow;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.ontology.service.KnowledgeDiscoveryService;
import com.ibm.smarts.questionanalyzer.core.assembler.Assembler;
import com.ibm.smarts.questionanalyzer.core.interpretation.InterpretationBoard;
import com.ibm.smarts.questionanalyzer.core.log.Report;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.Locale;

public class AnalyzerContext {
    private RequestContext reqCtx;
    private final InterpretationBoardAccessor mIBAccessor;
    private Locale mLocale;
    private final SmartNLP nlp;
    private Report report;
    public final IStoreProvider storeProvider;
    private final KnowledgeDiscoveryService ontology;
    private Assembler assembler;

    public AnalyzerContext(RequestContext ctx, InterpretationBoard board, SmartNLP nlp, IStoreProvider storeProvider, KnowledgeDiscoveryService ontology, Assembler assembler) {
        this.mIBAccessor = new InterpretationBoardAccessor(board);
        this.nlp = nlp;
        this.reqCtx = ctx;
        this.mLocale = ctx.locale;
        this.report = new Report();
        this.storeProvider = storeProvider;
        this.ontology = ontology;
        this.setAssembler(assembler);
    }

    public InterpretationBoardAccessor getInterpretationBoardAccessor() {
        return this.mIBAccessor;
    }

    public String getQuestion() {
        return this.getInterpretationBoardAccessor().getQuestion();
    }

    public SmartNLP getNLP() {
        return this.nlp;
    }

    public Report getReport() {
        return this.report;
    }

    public RequestContext getRequestContext() {
        return this.reqCtx;
    }

    public KnowledgeDiscoveryService getOntology() {
        return this.ontology;
    }

    public Assembler getAssembler() {
        return this.assembler;
    }

    public void setAssembler(Assembler assembler) {
        this.assembler = assembler;
    }

    public final class InterpretationBoardAccessor {
        private final InterpretationBoard mBoard;

        public InterpretationBoardAccessor(InterpretationBoard board) {
            this.mBoard = board;
        }

        public String getQuestion() {
            return this.mBoard.getQuestion();
        }
    }
}

