/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.questionanalyzer.core.workflow;

import com.ibm.smarts.questionanalyzer.core.annotator.IAnnotator;
import com.ibm.smarts.questionanalyzer.core.arbitrator.IArbitrator;
import com.ibm.smarts.questionanalyzer.core.interpretation.Interpretation;
import com.ibm.smarts.questionanalyzer.core.interpretation.InterpretationBoard;
import com.ibm.smarts.questionanalyzer.core.tokenizer.ITokenizer;
import com.ibm.smarts.questionanalyzer.core.workflow.AnalysisStep;
import com.ibm.smarts.questionanalyzer.core.workflow.AnalyzerContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerWorkflow {
    private static final String XML_ATTR_NAME = "name";
    private static final String XML_ATTR_CLASS = "class";
    private static final String XML_ATTR_ID = "id";
    private static final String XML_ELEM_TOKENIZERS = "tokenizers";
    private static final String XML_ELEM_ARBITRATORS = "arbitrators";
    private static final String XML_ELEM_ANNOTATORS = "annotators";
    private static final String XML_ELEM_STEPS = "steps";
    private List<AnalysisStep> mSteps;
    private final String name;
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzerWorkflow.class);

    AnalyzerWorkflow(String path) {
        this.name = path;
        this.mSteps = new ArrayList<AnalysisStep>();
        this.init(this.getName());
    }

    private void init(String path) {
        System.out.println(new File(path).getAbsolutePath());
        InputStream is = null;
        try {
            SAXReader reader = new SAXReader();
            is = AnalyzerWorkflow.class.getResourceAsStream(path);
            Document document = reader.read(is);
            this.mSteps = AnalyzerWorkflow.parse(document);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to load question analyzer workflow.", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException reader) {}
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public AnalyzerWorkflow(String name, List<AnalysisStep> steps) {
        this.mSteps = steps;
        this.name = name;
    }

    public List<AnalysisStep> getSteps() {
        return this.mSteps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(AnalyzerContext ctx, InterpretationBoard board) throws Exception {
        for (AnalysisStep analysisStep : this.mSteps) {
            ctx.getReport().enterStep(analysisStep.getName());
            long b4 = System.nanoTime();
            try {
                Interpretation basis = null;
                for (ITokenizer tokenizer : analysisStep.getTokenizers()) {
                    long tokenizerB4 = System.nanoTime();
                    try {
                        basis = tokenizer.tokenize(ctx, board.getQuestion());
                    }
                    catch (Throwable e) {
                        LOGGER.error(e.getLocalizedMessage(), e);
                        ctx.getReport().logErrorOutput(tokenizer.getIdentifier(), "annotator", e.toString());
                    }
                    finally {
                        if (null != basis) {
                            ctx.getReport().logOutput(tokenizer.getIdentifier(), "annotator", basis, System.nanoTime() - tokenizerB4);
                            continue;
                        }
                        LOGGER.error("Interpretation after tokenization is NULL for question [{}]", (Object)board.getQuestion());
                    }
                }
                List<Interpretation> newInterpretations = new ArrayList<Interpretation>();
                if (basis != null) {
                    newInterpretations.add(basis);
                }
                for (IAnnotator annotator : analysisStep.getAnnotators()) {
                    long annotatorB4 = System.nanoTime();
                    try {
                        for (Interpretation interpretation : board.getInterpretations()) {
                            List<Interpretation> list = annotator.annotate(ctx, interpretation);
                            if (list == null) continue;
                            ctx.getReport().logOutput(annotator.getIdentifier(), "annotator", interpretation, list, System.nanoTime() - annotatorB4);
                            newInterpretations.addAll(list);
                            if (!LOGGER.isDebugEnabled()) continue;
                            newInterpretations.stream().forEach(i -> LOGGER.debug(i.toString()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ctx.getReport().logErrorOutput(annotator.getIdentifier(), "annotator", e.toString());
                        if (!annotator.isMandatory()) continue;
                        throw e;
                    }
                }
                for (IArbitrator arbitrator : analysisStep.getAggregators()) {
                    long arbitratorB4 = System.nanoTime();
                    try {
                        newInterpretations = arbitrator.resolve(ctx, newInterpretations.isEmpty() ? board.getInterpretations() : newInterpretations);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ctx.getReport().logErrorOutput(arbitrator.getIdentifier(), "arbitrator", e.toString());
                        throw e;
                    }
                    finally {
                        ctx.getReport().logOutput(arbitrator.getIdentifier(), "arbitrator", newInterpretations, System.nanoTime() - arbitratorB4);
                    }
                }
                if (newInterpretations.isEmpty()) continue;
                board.setActiveInterpretations(newInterpretations);
            }
            finally {
                ctx.getReport().logTime(System.nanoTime() - b4);
            }
        }
    }

    private static List<AnalysisStep> parse(Document doc) {
        ArrayList<AnalysisStep> list = new ArrayList<AnalysisStep>();
        Element workflow = doc.getRootElement();
        for (Element step : AnalyzerWorkflow.getCollection(workflow, XML_ELEM_STEPS)) {
            Object annotator2;
            ArrayList<ITokenizer> tokenizers = new ArrayList<ITokenizer>();
            for (Element element : AnalyzerWorkflow.getCollection(step, XML_ELEM_TOKENIZERS)) {
                ITokenizer anInstance = (ITokenizer)AnalyzerWorkflow.createInstance(element.attributeValue(XML_ATTR_ID), element.attributeValue(XML_ATTR_CLASS));
                if (anInstance == null) continue;
                tokenizers.add(anInstance);
            }
            ArrayList<IAnnotator> annotators = new ArrayList<IAnnotator>();
            for (Object annotator2 : AnalyzerWorkflow.getCollection(step, XML_ELEM_ANNOTATORS)) {
                IAnnotator anInstance = (IAnnotator)AnalyzerWorkflow.createInstance(annotator2.attributeValue(XML_ATTR_ID), annotator2.attributeValue(XML_ATTR_CLASS));
                if (anInstance == null) continue;
                annotators.add(anInstance);
            }
            ArrayList<IArbitrator> arrayList = new ArrayList<IArbitrator>();
            annotator2 = AnalyzerWorkflow.getCollection(step, XML_ELEM_ARBITRATORS).iterator();
            while (annotator2.hasNext()) {
                Element arbitrator = (Element)annotator2.next();
                IArbitrator anInstance = (IArbitrator)AnalyzerWorkflow.createInstance(arbitrator.attributeValue(XML_ATTR_ID), arbitrator.attributeValue(XML_ATTR_CLASS));
                if (anInstance == null) continue;
                arrayList.add(anInstance);
            }
            String name = step.attributeValue(XML_ATTR_NAME);
            AnalysisStep aStep = new AnalysisStep(name, tokenizers, annotators, arrayList);
            list.add(aStep);
        }
        return list;
    }

    private static <T> T createInstance(String id, String impl) {
        if (impl != null) {
            try {
                Class<?> cls = Class.forName(impl);
                if (id == null || id.isEmpty()) {
                    return (T)cls.newInstance();
                }
                return (T)cls.getConstructor(String.class).newInstance(id);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to create instance for class " + id, e);
            }
        }
        return null;
    }

    private static List<Element> getCollection(Element e, String name) {
        List list;
        Element col = e.element(name);
        if (col != null && (list = col.elements(name.substring(0, name.length() - 1))) != null) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Object obj : list) {
                result.add((Element)obj);
            }
            return result;
        }
        return Collections.emptyList();
    }
}

