/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.function;

import com.ibm.smarts.core.util.Tuple2;
import java.util.HashSet;
import java.util.Set;

public class DdsExecutionUtil {
    public static final String EXCLUDE = "-";
    public static final String DELIMITER = ",";

    public static boolean isEnabled(String execution, String taskId) {
        Tuple2<Set<String>, Set<String>> extracted = DdsExecutionUtil.extractIncludesExcludes(execution);
        Set includes = (Set)extracted._1;
        Set excludes = (Set)extracted._2;
        return (includes.isEmpty() || includes.contains(taskId)) && !excludes.contains(taskId);
    }

    public static String adjustExecution(String execution, Set<String> include, Set<String> exclude) {
        Tuple2<Set<String>, Set<String>> extracted = DdsExecutionUtil.extractIncludesExcludes(execution);
        Set includes = (Set)extracted._1;
        Set excludes = (Set)extracted._2;
        if (include != null) {
            includes.addAll(include);
        }
        if (exclude != null) {
            excludes.addAll(exclude);
        }
        return DdsExecutionUtil.buildExecution(includes, excludes);
    }

    public static String buildExecution(Set<String> include, Set<String> exclude) {
        String includeString = DdsExecutionUtil.buildExecutionToInclude(include.toArray(new String[0]));
        String excludeString = DdsExecutionUtil.buildExecutionToExclude(exclude.toArray(new String[0]));
        StringBuilder result = new StringBuilder();
        if (includeString != null && !includeString.isEmpty()) {
            result.append(includeString);
            if (excludeString != null && !excludeString.isEmpty()) {
                result.append(DELIMITER);
            }
        }
        result.append(excludeString);
        return result.toString();
    }

    public static String buildExecutionToInclude(String ... include) {
        StringBuilder execution = new StringBuilder();
        for (int i = 0; i < include.length; ++i) {
            if (i > 0) {
                execution.append(DELIMITER);
            }
            execution.append(include[i]);
        }
        return execution.toString();
    }

    public static String buildExecutionToExclude(String ... exclude) {
        StringBuilder execution = new StringBuilder();
        for (int i = 0; i < exclude.length; ++i) {
            if (i > 0) {
                execution.append(DELIMITER);
            }
            execution.append(EXCLUDE);
            execution.append(exclude[i]);
        }
        return execution.toString();
    }

    private static Tuple2<Set<String>, Set<String>> extractIncludesExcludes(String execution) {
        String[] tasks;
        HashSet<String> includes = new HashSet<String>();
        HashSet<String> excludes = new HashSet<String>();
        Tuple2 result = new Tuple2(includes, excludes);
        if (execution == null || execution.isEmpty()) {
            return result;
        }
        for (String task : tasks = execution.split(DELIMITER)) {
            String trimmed = task.trim();
            boolean excluded = trimmed.startsWith(EXCLUDE);
            if (excluded) {
                trimmed = trimmed.substring(EXCLUDE.length(), trimmed.length());
                excludes.add(trimmed);
                continue;
            }
            includes.add(trimmed);
        }
        return result;
    }
}

