/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.numerics;

import com.ibm.smarts.dds.core.numerics.StatsKey;
import com.ibm.smarts.dds.core.numerics.util.DateUtil;
import com.ibm.smarts.dds.core.stats.strategy.StatsStrategy;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.value.BooleanValue;
import com.ibm.smarts.model.value.ByteValue;
import com.ibm.smarts.model.value.DecimalValue;
import com.ibm.smarts.model.value.DoubleValue;
import com.ibm.smarts.model.value.FloatValue;
import com.ibm.smarts.model.value.IntegerValue;
import com.ibm.smarts.model.value.LongValue;
import com.ibm.smarts.model.value.ShortValue;
import com.ibm.smarts.model.value.StringValue;
import com.ibm.smarts.model.value.Value;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Column
implements Comparable<Column> {
    private final String id;
    private List<Value> samples = null;
    private final List<String> rawSamples;
    private EnumMap<StatsKey, Value> statsMap = new EnumMap(StatsKey.class);
    private final DataType type;
    private boolean useful;
    private static final double MILLIS_PER_DAY = 8.64E7;
    private final StatsStrategy strategy;

    public Column(String id, DataType dataType, StatsStrategy strategy, List<String> rawSamples) {
        this.id = id;
        this.rawSamples = rawSamples;
        this.type = dataType;
        this.strategy = strategy;
    }

    public void calculateStats() {
        this.samples = this.transformSamples(this.rawSamples, this.getDataType());
        this.strategy.calculateStats(this);
    }

    private <T extends Value> T convertSampleHandler(String sample, Class<T> valueClass) {
        if (sample == null) {
            return null;
        }
        try {
            Value ret = (Value)valueClass.newInstance();
            ret.assignFrom(sample);
            return (T)ret;
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    private List<Value> transformSamples(List<String> samples2, DataType type) {
        switch (type.getBaseType()) {
            case BOOLEAN: {
                return samples2.stream().map(s -> s == null ? null : new BooleanValue(Boolean.parseBoolean(s))).collect(Collectors.toList());
            }
            case BYTE: {
                return samples2.stream().map(s -> this.convertSampleHandler((String)s, (Class)ByteValue.class)).collect(Collectors.toList());
            }
            case DATE: {
                return new DateUtil().getProcessedSamples(samples2);
            }
            case DECIMAL: {
                return samples2.stream().map(s -> this.convertSampleHandler((String)s, (Class)DecimalValue.class)).collect(Collectors.toList());
            }
            case DOUBLE: {
                return samples2.stream().map(s -> this.convertSampleHandler((String)s, (Class)DoubleValue.class)).collect(Collectors.toList());
            }
            case FLOAT: {
                return samples2.stream().map(s -> this.convertSampleHandler((String)s, (Class)FloatValue.class)).collect(Collectors.toList());
            }
            case INTEGER: {
                return samples2.stream().map(s -> this.convertSampleHandler((String)s, (Class)IntegerValue.class)).collect(Collectors.toList());
            }
            case LONG: {
                return samples2.stream().map(s -> this.convertSampleHandler((String)s, (Class)LongValue.class)).collect(Collectors.toList());
            }
            case SHORT: {
                return samples2.stream().map(s -> this.convertSampleHandler((String)s, (Class)ShortValue.class)).collect(Collectors.toList());
            }
            case STRING: {
                return samples2.stream().map(s -> s == null ? null : new StringValue(s)).collect(Collectors.toList());
            }
            case TIME: {
                return new DateUtil().getProcessedSamples(samples2);
            }
            case TIMESTAMP: {
                return new DateUtil().getProcessedSamples(samples2);
            }
            case UNKNOWN: {
                return samples2.stream().map(s -> s == null ? null : new StringValue(s)).collect(Collectors.toList());
            }
        }
        List<Value> dflt = Collections.emptyList();
        return dflt;
    }

    public String getId() {
        return this.id;
    }

    public Value getStat(StatsKey key) {
        return this.statsMap.get((Object)key);
    }

    public Map<StatsKey, Value> getStat() {
        return this.statsMap;
    }

    public Column setUnivariateStat(StatsKey key, Value val) {
        if (val == null) {
            this.statsMap.remove((Object)key);
        } else {
            this.statsMap.put(key, val);
        }
        return this;
    }

    public List<Value> getSamples() {
        return this.samples;
    }

    public int rowCount() {
        return this.samples.size();
    }

    public List<String> getSampleDistinctValues() {
        return this.strategy.getSampleDistinctValues();
    }

    public List<Integer> getSampleDistinctValuesCount() {
        return this.strategy.getSampleDistinctValuesCount();
    }

    public DataType getDataType() {
        return this.type;
    }

    public void setUseful(boolean useful) {
        this.useful = useful;
    }

    public boolean useful() {
        return this.useful;
    }

    public boolean isNumeric() {
        return this.strategy.isNumeric();
    }

    int groupCount() {
        return this.strategy.getGroupCount();
    }

    public Double toDouble(Value x) {
        if (this.getDataType().isNumeric()) {
            return x.doubleValue();
        }
        if (this.getDataType().isTemporal()) {
            return (double)x.dateValue().getTime() / 8.64E7;
        }
        return null;
    }

    public int groupOf(int row) {
        Value v = this.samples.get(row);
        if (v == null) {
            return -1;
        }
        if (this.type.isNumeric() || this.type.isTemporal()) {
            double q1 = this.statsMap.get((Object)StatsKey.q1).doubleValue();
            double q2 = this.statsMap.get((Object)StatsKey.median).doubleValue();
            double q3 = this.statsMap.get((Object)StatsKey.q3).doubleValue();
            double x = this.toDouble(v);
            if (x < q2) {
                return x < q1 ? 0 : 1;
            }
            return x < q3 ? 2 : 3;
        }
        return this.strategy.getCategoryIndex().getOrDefault(v.stringValue(), this.strategy.getCategoryCount() - 1);
    }

    public double standardized(int row) {
        Value v = this.samples.get(row);
        if (v != null && (this.type.isNumeric() || this.type.isTemporal())) {
            double mean = this.statsMap.get((Object)StatsKey.mean).doubleValue();
            double stddev = this.statsMap.get((Object)StatsKey.stddev).doubleValue();
            if (stddev != 0.0) {
                return (this.toDouble(v) - mean) / stddev;
            }
        }
        return 0.0;
    }

    @Override
    public int compareTo(Column o) {
        if (o.isNumeric() != this.isNumeric()) {
            return this.isNumeric() ? 1 : -1;
        }
        return Integer.compare(this.hashCode(), o.hashCode());
    }

    public String toString() {
        return this.id;
    }
}

