/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.stats.strategy;

import com.ibm.smarts.dds.core.numerics.Column;
import com.ibm.smarts.dds.core.numerics.StatsKey;
import com.ibm.smarts.dds.core.stats.strategy.StatsStrategy;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.value.FloatValue;
import com.ibm.smarts.model.value.LongValue;
import com.ibm.smarts.model.value.Value;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonStatsStrategy
implements StatsStrategy {
    private static final Logger logger = LoggerFactory.getLogger(CommonStatsStrategy.class);
    private List<String> sampleDistinctValues;
    private List<Integer> sampleDistinctValuesCount;

    @Override
    public void calculateStats(Column column) {
        if (column.getSamples().isEmpty()) {
            logger.info("There are no samples for column: {}, statistics will not be calculated", (Object)column.getId());
            return;
        }
        this.setCountStats(column);
        DataType dataType = column.getDataType();
        if (!dataType.isNumeric() && !dataType.isTemporal()) {
            List dataList = column.getSamples().stream().filter(Objects::nonNull).sorted().collect(Collectors.toList());
            if (dataList.isEmpty()) {
                return;
            }
            column.setUnivariateStat(StatsKey.min, (Value)dataList.get(0));
            column.setUnivariateStat(StatsKey.max, (Value)dataList.get(dataList.size() - 1));
        }
    }

    private void setCountStats(Column column) {
        long totalCount = column.getSamples().size();
        long nullCount = (int)column.getSamples().stream().filter(Objects::isNull).count();
        column.setUnivariateStat(StatsKey.N, (Value)new LongValue(totalCount));
        column.setUnivariateStat(StatsKey.nullCount, (Value)new LongValue(nullCount));
    }

    protected void setDensityEstimation(Column column) {
        int valid = column.getStat(StatsKey.valid).intValue();
        int totalCount = column.getStat(StatsKey.N).intValue();
        if (totalCount == 0) {
            logger.error("The total count was 0! Can't extimate density for column: {}", (Object)column.getId());
            return;
        }
        float densityEstimation = (float)valid / (float)totalCount;
        column.setUnivariateStat(StatsKey.DENSITY, (Value)new FloatValue(densityEstimation));
    }

    @Override
    public List<String> getSampleDistinctValues() {
        return this.sampleDistinctValues;
    }

    public void setSampleDistinctValues(List<String> sampleDistinctValues) {
        this.sampleDistinctValues = sampleDistinctValues;
    }

    @Override
    public List<Integer> getSampleDistinctValuesCount() {
        return this.sampleDistinctValuesCount;
    }

    public void setSampleDistinctValuesCount(List<Integer> sampleDistinctValuesCount) {
        this.sampleDistinctValuesCount = sampleDistinctValuesCount;
    }
}

