/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.tasks;

import com.ibm.smarts.common.mq.function.SmartsModuleFunctionResult;
import com.ibm.smarts.common.mq.function.SmartsModulePublishUtil;
import com.ibm.smarts.common.mq.progress.SmartsModuleProgressUtil;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.logging.PerformanceLogger;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.AnalysisPhase;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.AnalysisTask;
import com.ibm.smarts.schema.AnalysisTaskStatus;
import com.ibm.smarts.schema.CancelOption;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.FeatureUtil;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.schema.util.SmartsUtil;
import com.ibm.smarts.smartsmodule.builder.api.IFeatureExtractor;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingTaskImpl {
    public static final String SMARTS_MODULE_FUNCTION_RESULT = "result";
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishingTaskImpl.class);

    public void execute(SmartsTaskContext taskContext) {
        String smartsModuleId = taskContext.getSmartsModuleId();
        RequestContext rc = taskContext.getRequestContext();
        IStoreProvider storeProvider = taskContext.getStoreProvider();
        String datasetID = taskContext.getDatasetId();
        PerformanceLogger.get().info((Object)(smartsModuleId + "." + datasetID));
        String smartsResourceURI = taskContext.getResourceURI();
        CancelOption cancelOption = SmartsModuleProgressUtil.getCancelOption((RequestContext)rc, (IStoreProvider)storeProvider, (String)smartsModuleId);
        IInMemoryModuleStore inMemStore = storeProvider.getModuleStore(rc);
        SmartsModule module = inMemStore.getSmartsModulePart(smartsModuleId, datasetID);
        if (cancelOption == CancelOption.CANCEL_WITH_DELETE) {
            SmartsModulePublishUtil.deleteSmartsModule((RequestContext)rc, (IStoreProvider)storeProvider, (String)smartsModuleId);
            taskContext.setProperty(SMARTS_MODULE_FUNCTION_RESULT, (Object)new SmartsModuleFunctionResult());
            return;
        }
        DatasetInfo finishedDS = null;
        if (module != null && !module.getDatasets().isEmpty()) {
            finishedDS = (DatasetInfo)module.getDatasets().get(0);
        }
        if (finishedDS == null) {
            throw new InternalException("Dataset '" + datasetID + "' not found in Smarts module '" + smartsModuleId + "'", new Object[0]);
        }
        SmartsModuleUtil.getFlattenedColumns(finishedDS).forEach(c -> {
            c.getSamples().clear();
            c.getSampleDistinctValues().clear();
            c.getSampleDistinctValueCounts().clear();
        });
        boolean isSuccess = true;
        this.setAnalysisTaskStatus(finishedDS, isSuccess);
        StoreStatus status = SmartsModulePublishUtil.publish((RequestContext)rc, (IStoreProvider)storeProvider, (String)smartsModuleId, (SmartsModule)module, (DatasetInfo)finishedDS, (String)smartsResourceURI);
        if (status.isSuccess()) {
            this.extractStoreFeatures(rc, storeProvider, module, finishedDS);
            finishedDS.getItem().clear();
        }
        PerformanceLogger.get().info((Object)(smartsModuleId + "." + datasetID));
        if (!status.isSuccess()) {
            throw new InternalException(String.format("Failed to publish Dataset %s in SmartsModule %s caused by: %s", smartsModuleId, datasetID, status.getErrors()), new Object[0]);
        }
    }

    void extractStoreFeatures(RequestContext rc, IStoreProvider storeProvider, SmartsModule smartsModule, DatasetInfo dataset) {
        Object feObj = rc.getAttribute("smarts.feature.extractor");
        if (feObj != null) {
            IFeatureExtractor fe = (IFeatureExtractor)feObj;
            SmartsModule smartsModulePart = SmartsUtil.smartsModulePartFrom((SmartsModule)smartsModule, (DatasetInfo)dataset);
            List features = fe.extractFeature(rc, smartsModulePart, smartsModule.getId());
            LOGGER.debug("[{}] features extracted from smartsModule [{}] dataset [{}]", new Object[]{features.size(), smartsModule.getId(), dataset.getId()});
            ArrayList featureRecs = new ArrayList();
            features.forEach(f -> {
                String featureID = FeatureUtil.generateFeatureID((Feature)f);
                featureRecs.add(IRecord.create((Object)f, (String)featureID));
            });
            if (!featureRecs.isEmpty()) {
                LOGGER.debug("Indexing [{}] features from smartsModule [{}] dataset [{}]", new Object[]{features.size(), smartsModule.getId(), dataset.getId()});
                CompletableFuture.runAsync(() -> storeProvider.getFeatureStore(rc).store(featureRecs));
            }
        }
    }

    private void setAnalysisTaskStatus(DatasetInfo finishedDS, boolean isSuccess) {
        AnalysisTask analysisTask;
        AnalysisPhase phase = finishedDS.getAnalysisPhases().stream().filter(p -> p.getId().equals("smarts.analysis.phase.initial")).findFirst().orElse(null);
        if (phase != null && (analysisTask = (AnalysisTask)phase.getCompletedTasks().stream().filter(task -> task.getId().equals("PUBLISHING_TASK")).findFirst().orElse(null)) != null) {
            AnalysisTaskStatus analysisTaskStatus = new AnalysisTaskStatus();
            analysisTaskStatus.setSuccess(isSuccess);
            analysisTask.setStatus(analysisTaskStatus);
            if (phase.getAnalysisState().equals((Object)AnalysisStateType.IN_PROGRESS) || !isSuccess) {
                if (isSuccess) {
                    phase.setAnalysisState(AnalysisStateType.DONE);
                } else {
                    phase.setAnalysisState(AnalysisStateType.FAILED);
                }
            }
        }
    }
}

