/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.similarity.classifier.builder.tasks;

import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.logging.PerformanceLogger;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.ColumnEmbedding;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.similarity.classifier.builder.api.ValueToColumnEncoder;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnEmbeddingTaskImpl {
    private final Logger LOGGER = LoggerFactory.getLogger(ColumnEmbeddingTaskImpl.class);
    public static final String COLUMN_EMBEDDING_TASK_ID = ".columnEmbedding";
    public static final String COLUMN_EMBEDDING_TASK_NAME = "ColumnEmbedding";
    public static final String COLUMN_EMBEDDING_TASK_DESCRIPTION = "Adds word embedding for the columns in the SmartsModule, based on sample data.";

    public void execute(SmartsTaskContext taskContext) {
        String smartsId = taskContext.getSmartsModuleId();
        String datasetId = taskContext.getDatasetId();
        PerformanceLogger.get().info((Object)(smartsId + "." + datasetId));
        RequestContext requestContext = taskContext.getRequestContext();
        IStoreProvider storeProvider = taskContext.getStoreProvider();
        String taskId = COLUMN_EMBEDDING_TASK_ID;
        SmartsModule smartsModule = storeProvider.getModuleStore(requestContext).getSmartsModulePart(smartsId, datasetId);
        if (smartsModule == null) {
            this.LOGGER.error("SmartsModule not found for id: {}.", (Object)smartsId);
            throw new InternalException("SmartsModule not found for id: {0}.", new Object[]{smartsId});
        }
        DatasetInfo datasetInfo = smartsModule.getDatasets().stream().filter(ds -> ds.getId().equals(datasetId)).findAny().orElse(null);
        if (datasetInfo == null) {
            this.LOGGER.error("Dataset not found for the id: {}.", (Object)datasetId);
            throw new InternalException("Dataset not found for the id: {0}.", new Object[]{datasetId});
        }
        List columns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)datasetInfo);
        if (SmartsModuleUtil.logMissingData((String)smartsId, (String)datasetInfo.getId(), (List)columns, (String)taskId)) {
            this.LOGGER.error("Missing sample data for datasetId: {}.", (Object)datasetId);
            throw new InternalException("Missing sample data for datasetId: {0}.", new Object[]{datasetId});
        }
        List<ColumnEmbedding> generatedColumnEmbedding = ValueToColumnEncoder.encodeDataset(datasetInfo);
        List inheritedColumnEmbedding = datasetInfo.getColumnEmbeddings();
        if (inheritedColumnEmbedding != null && !inheritedColumnEmbedding.isEmpty()) {
            SmartsModuleUtil.appendFilteredColumnEmbedding(generatedColumnEmbedding, (List)inheritedColumnEmbedding);
        }
        datasetInfo.getColumnEmbeddings().clear();
        datasetInfo.getColumnEmbeddings().addAll(generatedColumnEmbedding);
        PerformanceLogger.get().info((Object)(smartsId + "." + datasetId));
    }
}

