/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value.decor;

import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import com.ibm.smarts.model.value.decor.CurrencyDecoration;
import com.ibm.smarts.model.value.decor.PercentDecoration;
import com.ibm.smarts.model.value.decor.ThousandsSeparatorDecoration;
import java.util.concurrent.ConcurrentHashMap;

public final class ValueDecorations {
    private static final ConcurrentHashMap<Currency, CurrencyDecoration> sCurrencyDecorPool = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Character, PercentDecoration> sPercentDecorPool = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Character, ThousandsSeparatorDecoration> sThousandsSepDecorPool = new ConcurrentHashMap();

    public static CurrencyDecoration getCurrencyDecoration(Currency currency) {
        CurrencyDecoration old;
        CurrencyDecoration decor = sCurrencyDecorPool.get(currency);
        if (null == decor && null != (old = sCurrencyDecorPool.putIfAbsent(currency, decor = new CurrencyDecoration(currency)))) {
            decor = old;
        }
        return decor;
    }

    public static PercentDecoration getPercentDecoration(char percentSymbol) {
        PercentDecoration decor = sPercentDecorPool.get(Character.valueOf(percentSymbol));
        if (null == decor) {
            decor = new PercentDecoration(percentSymbol);
            PercentDecoration old = sPercentDecorPool.putIfAbsent(Character.valueOf(percentSymbol), decor);
            if (null != old) {
                decor = old;
            }
        }
        return decor;
    }

    public static ThousandsSeparatorDecoration geThousandsSeparatorDecoration(char thousandsSepSymbol) {
        ThousandsSeparatorDecoration decor = sThousandsSepDecorPool.get(Character.valueOf(thousandsSepSymbol));
        if (null == decor) {
            decor = new ThousandsSeparatorDecoration(thousandsSepSymbol);
            ThousandsSeparatorDecoration old = sThousandsSepDecorPool.putIfAbsent(Character.valueOf(thousandsSepSymbol), decor);
            if (null != old) {
                decor = old;
            }
        }
        return decor;
    }

    private ValueDecorations() {
    }

    static {
        for (ULocale loc : Currency.getAvailableULocales()) {
            Currency cur = Currency.getInstance((ULocale)loc);
            if (null == cur || sCurrencyDecorPool.containsKey(cur)) continue;
            sCurrencyDecorPool.put(cur, new CurrencyDecoration(cur));
        }
        for (ULocale loc : DecimalFormatSymbols.getAvailableULocales()) {
            char percSym = DecimalFormatSymbols.getInstance((ULocale)loc).getPercent();
            if (sPercentDecorPool.containsKey(Character.valueOf(percSym))) continue;
            sPercentDecorPool.put(Character.valueOf(percSym), new PercentDecoration(percSym));
        }
    }
}

