/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.mq;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.common.mq.MessageGroupTask;
import com.ibm.smarts.common.mq.SmartsModuleMessageGroup;
import com.ibm.smarts.common.mq.message.SmartsModuleMessage;
import java.util.ArrayList;
import java.util.List;

public class SmartsModuleTask
extends MessageGroupTask {
    public final Scope scope;
    public final boolean applyOnSuccessOnly;

    public SmartsModuleTask(boolean hiddenTask, String id, String name, String description, Scope scope, List<String> incomingExchanges, String ... outgoingExchanges) {
        this(hiddenTask, id, name, description, scope, true, incomingExchanges, outgoingExchanges);
    }

    @JsonCreator
    public SmartsModuleTask(@JsonProperty(value="hiddenTask") boolean hiddenTask, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="scope") Scope scope, @JsonProperty(value="applyOnSuccessOnly") boolean applyOnSuccessOnly, @JsonProperty(value="incomingExchanges") List<String> incomingExchanges, String ... outgoingExchanges) {
        super(hiddenTask, id, name, description, incomingExchanges, outgoingExchanges);
        this.applyOnSuccessOnly = applyOnSuccessOnly;
        this.scope = scope;
    }

    @JsonIgnore
    public List<Class<? extends SmartsModuleMessage>> getExpectedMessageTypes() {
        ArrayList<Class<? extends SmartsModuleMessage>> result = new ArrayList<Class<? extends SmartsModuleMessage>>();
        this.incomingExchanges.forEach(e -> result.add(SmartsModuleMessageGroup.messageTypeFor(e)));
        return result;
    }

    @JsonIgnore
    public int getOutgoingMessageCount(int datasetCount) {
        int result;
        int outgoingCount = this.outgoingExchanges.length;
        switch (this.scope) {
            case MODULE: {
                result = outgoingCount;
                break;
            }
            case DATASET: {
                result = outgoingCount * datasetCount;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    public static enum Scope {
        MODULE,
        DATASET;

    }
}

