/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.mq.function;

import com.ibm.smarts.common.mq.progress.SmartsModuleCancel;
import com.ibm.smarts.common.mq.progress.SmartsModuleProgressUtil;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.qg.Question;
import com.ibm.smarts.schema.AnalysisPhase;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleFactory;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.schema.util.SmartsUtil;
import com.ibm.smarts.store.api.TypeNames;
import com.ibm.smarts.store.api.config.StoreConfig;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.io.IOException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsModulePublishUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsModulePublishUtil.class);
    public static final int MAX_TAG_LENGTH = 256;
    public static final int MAX_UNICODE_TAG_LENGTH = 85;

    private SmartsModulePublishUtil() {
    }

    public static StoreStatus publishSmartsModuleSkeleton(RequestContext requestContext, IStoreProvider storeProvider, String smartsModuleId, SmartsModule smartsModule, DatasetInfo dataset) {
        StoreConfig config = new StoreConfig(requestContext.locale, TypeNames.DDS);
        SmartsModule smartsModulePart = SmartsUtil.smartsModulePartFrom((SmartsModule)smartsModule, (DatasetInfo)dataset);
        StoreStatus status = storeProvider.getPersistenceProvider(config).createOrReplace(requestContext, dataset.getId() + "-SemanticInfo", IRecord.create((Object)smartsModulePart, (String)smartsModuleId), Collections.emptyList(), null);
        if (!status.isSuccess()) {
            String msg = "failed to store SmartsModule \"" + smartsModuleId + "\" into persistence.";
            throw new InternalException(msg, new Object[]{status});
        }
        return status;
    }

    public static StoreStatus publishMasterSmartsModule(RequestContext requestContext, IStoreProvider storeProvider, String smartsModuleId, SmartsModule smartsModule, String resourceUri) {
        SmartsModule masterSmartsModule = SmartsUtil.createMasterSmartsModule((SmartsModule)smartsModule);
        ArrayList<String> masterSmartsModuleTags = new ArrayList<String>();
        masterSmartsModuleTags.add("SmartsModule");
        StoreConfig config = new StoreConfig(requestContext.locale, TypeNames.DDS);
        StoreStatus status = storeProvider.getPersistenceProvider(config).createOrReplace(requestContext, "SmartsModule", IRecord.create((Object)masterSmartsModule, (String)smartsModuleId), masterSmartsModuleTags, resourceUri);
        return status;
    }

    public static StoreStatus publishQuestions(RequestContext requestContext, IStoreProvider storeProvider, String smartsModuleId, SmartsModule smartsModule, List<Question> questions) {
        SmartsModule questionsSmartsModule = SmartsModuleFactory.createSmartsModule();
        questionsSmartsModule.setId(smartsModule.getId());
        questionsSmartsModule.setName("Questions");
        try {
            SmartsModuleUtil.marshalQuestions((SmartsModule)questionsSmartsModule, questions);
        }
        catch (IOException e) {
            throw new InternalException("Error occurred while marshalling questions for smartsModuleId : {0}", new Object[]{smartsModuleId});
        }
        ArrayList<String> qTags = new ArrayList<String>();
        qTags.add("Questions");
        StoreConfig config = new StoreConfig(requestContext.locale, TypeNames.DDS);
        StoreStatus status = storeProvider.getPersistenceProvider(config).createOrReplace(requestContext, "Questions", IRecord.create((Object)questionsSmartsModule, (String)smartsModuleId), qTags, null);
        if (!status.isSuccess()) {
            String msg = "failed to store questionsSmartsModule \"" + smartsModuleId + "\" into persistence.";
            throw new InternalException(msg, new Object[]{status});
        }
        return status;
    }

    public static StoreStatus publish(RequestContext requestContext, IStoreProvider storeProvider, String smartsModuleId, SmartsModule smartsModule, DatasetInfo dataset, String resourceURI) {
        SmartsModulePublishUtil.processCancelOption(requestContext, storeProvider, smartsModuleId, dataset);
        SmartsModule smartsModulePart = SmartsUtil.smartsModulePartFrom((SmartsModule)smartsModule, (DatasetInfo)dataset);
        StoreConfig config = new StoreConfig(requestContext.locale, TypeNames.DDS);
        StoreStatus status = storeProvider.getPersistenceProvider(config).createOrReplace(requestContext, dataset.getId() + "-SemanticInfo", IRecord.create((Object)smartsModulePart, (String)smartsModuleId), SmartsModulePublishUtil.generateDataSetTags(dataset), resourceURI);
        if (!status.isSuccess()) {
            SmartsModule failedSmartModule = storeProvider.getModuleStore(requestContext).getSmartsModulePart(smartsModuleId, dataset.getId());
            DatasetInfo failedDataset = (DatasetInfo)failedSmartModule.getDatasets().get(0);
            List phases = failedDataset.getAnalysisPhases();
            for (AnalysisPhase phase : phases) {
                phase.setAnalysisState(AnalysisStateType.FAILED);
            }
            SmartsModule failedSmartsModulePart = SmartsUtil.smartsModulePartFrom((SmartsModule)failedSmartModule, (DatasetInfo)failedDataset);
            storeProvider.getPersistenceProvider(config).createOrReplace(requestContext, failedDataset.getId() + "-SemanticInfo", IRecord.create((Object)failedSmartsModulePart, (String)smartsModuleId), Collections.emptyList(), resourceURI);
            String msg = "failed to store SmartsModule \"" + smartsModuleId + "\" into persistence.";
            throw new InternalException(msg, new Object[]{status});
        }
        return status;
    }

    public static List<String> generateDataSetTags(DatasetInfo datasetInfo) {
        ArrayList<String> tags = new ArrayList<String>();
        String datasetId = datasetInfo.getId();
        tags.add(SmartsModulePublishUtil.truncateTag(datasetId));
        SmartsModuleUtil.getFlattenedColumns((BaseItemObject)datasetInfo).forEach(columnInfo -> {
            String idForExpression = columnInfo.getIdForExpression();
            if (StringUtils.isNotBlank((CharSequence)idForExpression)) {
                tags.add(SmartsModulePublishUtil.truncateTag(idForExpression));
            } else {
                LOGGER.warn("Dataset {} column {} should have valid idForExpression value", (Object)datasetId, (Object)columnInfo.getId());
            }
        });
        return tags;
    }

    public static String truncateTag(String tag) {
        CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
        return charsetEncoder.canEncode(tag) ? StringUtils.left((String)tag, (int)256).trim() : StringUtils.left((String)tag, (int)85).trim();
    }

    public static SmartsModuleCancel deleteSmartsModule(RequestContext requestContext, IStoreProvider storeProvider, String smartsModuleId) {
        StoreConfig config = new StoreConfig(requestContext.locale, TypeNames.DDS);
        StoreStatus status = storeProvider.getPersistenceProvider(config).delete(requestContext, smartsModuleId, "", Collections.emptyList());
        String errorMessage = "";
        boolean success = status.isSuccess();
        if (!success) {
            errorMessage = "Failed to delete SmartsModule \"" + smartsModuleId + "\" from persistence.";
        }
        return new SmartsModuleCancel(success, errorMessage);
    }

    private static void processCancelOption(RequestContext requestContext, IStoreProvider storeProvider, String smartsModuleId, DatasetInfo dataset) {
        if (SmartsModuleProgressUtil.isCancelled(requestContext, storeProvider, smartsModuleId)) {
            List phases = dataset.getAnalysisPhases();
            for (AnalysisPhase phase : phases) {
                if (phase.getAnalysisState() != AnalysisStateType.IN_PROGRESS) continue;
                phase.setAnalysisState(AnalysisStateType.CANCELED);
            }
        }
    }
}

