/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.pipeline;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DeltaAnalysisScope {
    private String datasetId;
    private ScopedTask scopedTask;
    private ScopedColumns scopedColumns;
    private Map<String, Set<ModifiableProperty>> columnPropertiesDelta = new HashMap<String, Set<ModifiableProperty>>();
    private Set<ModifiableProperty> datasetPropertiesDelta = new HashSet<ModifiableProperty>();

    public DeltaAnalysisScope(String datasetId, ScopedTask scopedTask, ScopedColumns scopedColumns) {
        this.datasetId = datasetId;
        this.scopedTask = scopedTask;
        this.scopedColumns = scopedColumns;
    }

    public DeltaAnalysisScope(String datasetId, ScopedTask scopedTask, Optional<String> columnIdForExpression, ModifiableProperty property) {
        this.datasetId = datasetId;
        this.scopedTask = scopedTask;
        this.addPropertyChange(scopedTask, columnIdForExpression, property);
    }

    public void addPropertyChange(ScopedTask scopedTask, Optional<String> columnIdForExpression, ModifiableProperty property) {
        if (columnIdForExpression.isPresent()) {
            this.scopedColumns = ScopedColumns.SOME;
            if (this.columnPropertiesDelta.containsKey(columnIdForExpression.get())) {
                this.columnPropertiesDelta.get(columnIdForExpression.get()).add(property);
            } else {
                HashSet<ModifiableProperty> propertyBag = new HashSet<ModifiableProperty>();
                this.columnPropertiesDelta.put(columnIdForExpression.get(), propertyBag);
                propertyBag.add(property);
            }
        } else {
            this.scopedColumns = this.columnPropertiesDelta.isEmpty() ? ScopedColumns.NONE : ScopedColumns.SOME;
            this.datasetPropertiesDelta.add(property);
        }
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public ScopedTask getScopedTask() {
        return this.scopedTask;
    }

    public void setScopedTask(ScopedTask scopedTask) {
        this.scopedTask = scopedTask;
    }

    public ScopedColumns getScopedColumns() {
        return this.scopedColumns;
    }

    public void setScopedColumns(ScopedColumns scopedColumns) {
        this.scopedColumns = scopedColumns;
    }

    public Set<ModifiableProperty> getDatasetPropertiesDelta() {
        return this.datasetPropertiesDelta;
    }

    public Map<String, Set<ModifiableProperty>> getColumnPropertiesDelta() {
        return this.columnPropertiesDelta;
    }

    public static enum ModifiableProperty {
        ALL,
        NAME,
        DESCRIPTION,
        COMMENT,
        DATATYPE,
        AGGREGATION,
        USAGE,
        CONCEPTS;

    }

    public static enum ScopedColumns {
        ALL,
        NONE,
        SOME;

    }

    public static enum ScopedTask {
        TOKENIZE,
        CLASSIFY,
        ALL;

    }
}

