/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.rest;

import com.ibm.smarts.common.mq.SmartsModuleException;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.ModuleInfo;
import com.ibm.smarts.model.builder.SamplingInfo;
import com.ibm.smarts.model.builder.SmartsModuleInfo;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.model.module.CreateSmartModuleResponse;
import com.ibm.smarts.model.progress.SmartsModuleProgressSummary;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.Response;

public class SmartsModuleRestClient
extends RestClient {
    public static final String SAMPLING_INFO = "samplingInfo";
    public static final String SM_OPTS = "smartsModuleOptions";
    public static final String ANALYSIS_SCOPE = "analysisScope";
    public static final String MODULE_INFO = "moduleInfo";

    public SmartsModuleRestClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        this(rccf, requestContext, uri, null);
    }

    public SmartsModuleRestClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri, Map<String, List<String>> headers) {
        super(rccf, requestContext, uri, headers);
    }

    public SmartsModule getSmartsModule(String smartsModuleUri, SmartsModuleOptions smartsModuleOptions, ModuleInfo moduleInfo, AnalysisScope analysisScope, SamplingInfo samplingInfo, boolean isModuleChanged) {
        String requestPath = smartsModuleUri;
        if (requestPath.startsWith(this.uri)) {
            requestPath = requestPath.substring(this.uri.length());
        }
        boolean createIfAbsent = moduleInfo != null && (moduleInfo.getModule() != null || moduleInfo.getModuleUri() != null);
        Response getResponse = this.getSmartsModule(smartsModuleUri, smartsModuleOptions, analysisScope);
        if (getResponse.getStatus() == 404 && !createIfAbsent) {
            throw new SmartsModuleException(this.requestContext.uuid.toString(), "Module not found.", new Object[0]);
        }
        SmartsModule smartsModule = this.getSmartsModuleFromResponse(getResponse);
        if (smartsModule == null) {
            if (createIfAbsent) {
                Response createResponse = this.postSmartsModule(requestPath, moduleInfo, analysisScope, samplingInfo);
                return this.getSmartsModuleFromResponse(createResponse);
            }
        } else if (isModuleChanged) {
            Response updateResponse = this.updateSmartsModule(requestPath, smartsModule, moduleInfo, analysisScope, samplingInfo);
            return this.getSmartsModuleFromResponse(updateResponse);
        }
        return smartsModule;
    }

    private SmartsModule getSmartsModuleFromResponse(Response response) {
        SmartsModule smartsModule = null;
        if (response.getStatus() == 404) {
            return null;
        }
        if (response.getStatus() == 200 || response.getStatus() == 201) {
            String json = SmartsModuleRestClient.getJson((Response)response);
            if (json == null || json.trim().isEmpty()) {
                LOGGER.error("The Smarts Module response was null or empty.");
                return null;
            }
            try {
                smartsModule = (SmartsModule)JAXBHelper.unmarshalFromJSON(SmartsModule.class, (String)json);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create Smarts Module from json: {}", (Throwable)e);
                return null;
            }
        } else {
            String restFailMsg = String.format("There was an error generating/getting the smarts module. Rest response: %d", response.getStatus());
            LOGGER.error(restFailMsg);
            throw new SmartsModuleException(this.requestContext.uuid.toString(), restFailMsg, new Object[0]);
        }
        return smartsModule;
    }

    private void addQueryParam(RestClient.QueryParams queryParams, String paramName, String value) {
        if (value != null) {
            queryParams.add(paramName, new String[]{value});
        }
    }

    private Response getSmartsModule(String resourceUri, SmartsModuleOptions smartsModuleOptions, AnalysisScope analysisScope) {
        String scope;
        String opts;
        try {
            opts = JAXBHelper.marshalToJSON((Object)smartsModuleOptions);
            scope = JAXBHelper.marshalToJSON((Object)analysisScope);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        this.addQueryParam(queryParams, ANALYSIS_SCOPE, scope);
        this.addQueryParam(queryParams, SM_OPTS, opts);
        return this.getResponse(resourceUri, queryParams);
    }

    private Response postSmartsModule(String path, ModuleInfo moduleInfo, AnalysisScope analysisScope, SamplingInfo samplingInfo) {
        String sInfo;
        String scope;
        String body;
        try {
            body = JAXBHelper.marshalToJSON((Object)moduleInfo);
            scope = JAXBHelper.marshalToJSON((Object)analysisScope);
            sInfo = JAXBHelper.marshalToJSON((Object)samplingInfo);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        this.addQueryParam(queryParams, ANALYSIS_SCOPE, scope);
        this.addQueryParam(queryParams, SAMPLING_INFO, sInfo);
        return this.postResponse(path, body, queryParams);
    }

    private Response updateSmartsModule(String path, SmartsModule smartsModule, ModuleInfo moduleInfo, AnalysisScope analysisScope, SamplingInfo samplingInfo) {
        String smInfo;
        String sInfo;
        String scope;
        String mInfo;
        SmartsModuleInfo smartsModuleInfo = new SmartsModuleInfo(null, smartsModule);
        try {
            mInfo = JAXBHelper.marshalToJSON((Object)moduleInfo);
            scope = JAXBHelper.marshalToJSON((Object)analysisScope);
            sInfo = JAXBHelper.marshalToJSON((Object)samplingInfo);
            smInfo = JAXBHelper.marshalToJSON((Object)smartsModuleInfo);
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        this.addQueryParam(queryParams, ANALYSIS_SCOPE, scope);
        this.addQueryParam(queryParams, SAMPLING_INFO, sInfo);
        this.addQueryParam(queryParams, MODULE_INFO, mInfo);
        return this.putResponse(path, smInfo, queryParams);
    }

    public CompletableFuture<SmartsModule> getSmartModuleAsync(String requestUri) {
        String request = requestUri;
        if (request.startsWith(this.uri)) {
            request = request.substring(this.uri.length());
        }
        request = this.adjustUriFor217958(request);
        return this.getAsync(request).thenApply(json -> CommonJAXBHelper.unmarshalFromJSON(SmartsModule.class, json));
    }

    public SmartsModule getSmartsModule(String uri) {
        CompletableFuture<SmartsModule> future = this.getSmartModuleAsync(uri);
        return (SmartsModule)this.get(future);
    }

    private CompletableFuture<SmartsModuleProgressSummary> getSmartModuleProgressSummaryAsync(String requestUri) {
        String request = requestUri;
        if (request.startsWith(this.uri)) {
            request = request.substring(this.uri.length());
        }
        request = this.adjustUriFor217958(request);
        return this.getAsync(request).thenApply(json -> CommonJAXBHelper.unmarshalFromJSON(SmartsModuleProgressSummary.class, json));
    }

    public SmartsModuleProgressSummary getSmartsModuleProgressSummary(String uri) {
        CompletableFuture<SmartsModuleProgressSummary> future = this.getSmartModuleProgressSummaryAsync(uri);
        return (SmartsModuleProgressSummary)this.get(future);
    }

    public CompletableFuture<CreateSmartModuleResponse> createSmartModuleAsync(String requestUri) {
        String request = requestUri;
        if (request.startsWith(this.uri)) {
            request = request.substring(this.uri.length());
        }
        request = this.adjustUriFor217958(request);
        return this.postAsync(request, "{}").thenApply(json -> CommonJAXBHelper.unmarshalFromJSON(CreateSmartModuleResponse.class, json));
    }

    public CreateSmartModuleResponse createSmartsModule(String uri) {
        CompletableFuture<CreateSmartModuleResponse> future = this.createSmartModuleAsync(uri);
        return (CreateSmartModuleResponse)this.get(future);
    }

    private String adjustUriFor217958(String uri) {
        if (uri.startsWith("/bi/v1/smarts/knowledge-discovery/smartsmodules")) {
            return uri.replaceFirst("knowledge-discovery/smartsmodules", "module");
        }
        return uri;
    }
}

