/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.parser;

import com.ibm.smarts.generated.parser.NLGParser;
import com.ibm.smarts.generated.parser.ParseException;
import com.ibm.smarts.generated.parser.SimpleNode;
import com.ibm.smarts.simpleNlg.NLGUtilities;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class NLGRealiserExpression
extends SimpleNode {
    private static final String DEFAULT_SEPARATOR = ", ";
    private static final String DEFAULT_END_SEPARATOR = " and ";
    private static final String reservedCharPattern = "[#(){}\\[\\]]";
    private static final String reservedStringsPattern = String.format("(\\b(%s)\\b)", String.join((CharSequence)"|", "plural", "pickRandomly", "numberToText", "list", "prettify", "count", "determiner"));
    private static final Pattern reservedTokenPattern = Pattern.compile(String.format("%s|%s", "[#(){}\\[\\]]", reservedStringsPattern));
    private static final String RESERVED_TOKEN_ESCAPE_PATTERN = "\\\\$0";
    private static final Charset charset = StandardCharsets.UTF_8;

    public NLGRealiserExpression(int i) {
        super(i);
    }

    public static NLGRealiserExpression create(String expressionString, Map<String, NLGRealiserExpression> argMap) throws ParseException {
        ByteArrayInputStream targetStream = new ByteArrayInputStream(expressionString.getBytes(charset));
        NLGParser parser = new NLGParser(targetStream, charset.name());
        if (argMap != null) {
            parser.args = argMap;
        }
        return parser.Start();
    }

    public static NLGRealiserExpression create(String expressionString) throws ParseException {
        return NLGRealiserExpression.create(expressionString, null);
    }

    public static NLGRealiserExpression decorateArgument(String arg) throws ParseException {
        return NLGRealiserExpression.create("(" + NLGRealiserExpression.escape(arg) + ")");
    }

    protected static String escape(String arg) {
        return reservedTokenPattern.matcher(arg).replaceAll(RESERVED_TOKEN_ESCAPE_PATTERN);
    }

    private static String plural(long val, String plural) {
        return NLGUtilities.plural(val, plural);
    }

    private static String plural(long val, String plural, String lexicalCategory) {
        return NLGUtilities.plural(val, plural, lexicalCategory);
    }

    private static String list(String[] list) {
        return NLGRealiserExpression.list(list, DEFAULT_END_SEPARATOR);
    }

    private static String list(String[] list, String endSep) {
        return NLGRealiserExpression.list(list, endSep, DEFAULT_SEPARATOR);
    }

    private static String list(String[] list, String endSep, String delim) {
        return NLGUtilities.list(list, delim, endSep);
    }

    private static String pickRandomly(String[] randomStrings) {
        return NLGUtilities.pickRandomly(randomStrings);
    }

    private static String numberToText(long number, long ceiling, String pre) {
        return NLGUtilities.numberToText(number, ceiling, pre);
    }

    private static String numberToText(long number, long ceiling) {
        return NLGUtilities.numberToText(number, ceiling);
    }

    private static String numberToText(long number) {
        return NLGUtilities.numberToText(number);
    }

    private static String prettify(String phrase) {
        return NLGUtilities.prettify(phrase);
    }

    private static String determiner(String determiner, String subject) {
        return NLGUtilities.determiner(determiner, subject);
    }

    private static String determiner(String determiner, String subject, long count) {
        return NLGUtilities.determiner(determiner, subject, count);
    }

    public String stringify() {
        return this.stringify(this);
    }

    private String plural(NLGRealiserExpression node) {
        NLGRealiserExpression[] methodArgs = this.getChildArgNodes(node);
        NLGRealiserExpression pluralizer = methodArgs[0];
        NLGRealiserExpression toPluralize = methodArgs[1];
        String lexicalCategory = methodArgs.length == 3 ? this.stringify(methodArgs[2]) : null;
        long pluralCount = (long)Math.ceil(Double.parseDouble(this.stringify(pluralizer)));
        String toPluralizeString = this.stringify(toPluralize);
        return lexicalCategory == null ? NLGRealiserExpression.plural(pluralCount, toPluralizeString) : NLGRealiserExpression.plural(pluralCount, toPluralizeString, lexicalCategory);
    }

    private String list(NLGRealiserExpression node) {
        String finalString;
        NLGRealiserExpression[] argsNodes = this.getChildArgNodes(node);
        NLGRealiserExpression[] firstArgArga = this.getArgNodes(argsNodes[0]);
        int numListArgs = firstArgArga.length;
        int numArgs = argsNodes.length;
        String[] listArgsString = new String[numListArgs];
        for (int i = 0; i < numListArgs; ++i) {
            listArgsString[i] = this.stringify(firstArgArga[i]);
        }
        if (numArgs == 1) {
            finalString = NLGRealiserExpression.list(listArgsString);
        } else if (numArgs == 2) {
            String endSep = this.stringify(argsNodes[1]);
            finalString = NLGRealiserExpression.list(listArgsString, endSep);
        } else {
            String delim = this.stringify(argsNodes[1]);
            String endSep = this.stringify(argsNodes[2]);
            finalString = NLGRealiserExpression.list(listArgsString, delim, endSep);
        }
        return finalString;
    }

    private String numberToText(NLGRealiserExpression node) {
        String finalString;
        NLGRealiserExpression[] methodArgs = this.getChildArgNodes(node);
        long numArgs = methodArgs.length;
        long number = Long.parseLong(this.stringify(methodArgs[0]));
        if (numArgs == 1L) {
            finalString = NLGRealiserExpression.numberToText(number);
        } else if (numArgs == 2L) {
            long ceiling = Long.parseLong(this.stringify(methodArgs[1]));
            finalString = NLGRealiserExpression.numberToText(number, ceiling);
        } else {
            long ceiling = Long.parseLong(this.stringify(methodArgs[1]));
            String pre = this.stringify(methodArgs[2]);
            finalString = NLGRealiserExpression.numberToText(number, ceiling, pre);
        }
        return finalString;
    }

    private String prettify(NLGRealiserExpression node) {
        NLGRealiserExpression[] methodArgs = this.getChildArgNodes(node);
        return NLGRealiserExpression.prettify(this.stringify(methodArgs[0]));
    }

    private String pickRandomly(NLGRealiserExpression node) {
        NLGRealiserExpression[] methodArgs = this.getChildArgNodes(node);
        int numArgs = methodArgs.length;
        String[] pickRandomArgsString = new String[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            pickRandomArgsString[i] = this.stringify(methodArgs[i]);
        }
        return NLGRealiserExpression.pickRandomly(pickRandomArgsString);
    }

    private String count(NLGRealiserExpression node) {
        NLGRealiserExpression[] argsNodes = this.getChildArgNodes(node);
        if (argsNodes.length == 0) {
            throw new IllegalArgumentException("#count method requires at least one argument");
        }
        int allArgs = this.getArgNodes(node).length;
        int numListArgs = allArgs > argsNodes.length ? allArgs - argsNodes.length : argsNodes.length;
        return String.valueOf(numListArgs);
    }

    private String determiner(NLGRealiserExpression node) {
        String finalString;
        NLGRealiserExpression[] methodArgs = this.getChildArgNodes(node);
        if (methodArgs.length < 2) {
            throw new IllegalArgumentException("#determiner method requires 2 arguments");
        }
        String determiner = this.stringify(methodArgs[0]);
        String subject = this.stringify(methodArgs[1]);
        if (methodArgs.length == 2) {
            finalString = NLGRealiserExpression.determiner(determiner, subject);
        } else {
            long count = Long.parseLong(this.stringify(methodArgs[2]));
            finalString = NLGRealiserExpression.determiner(determiner, subject, count);
        }
        return finalString;
    }

    private String stringify(NLGRealiserExpression node) {
        StringBuilder builder = new StringBuilder();
        if (node.jjtGetNumChildren() > 0) {
            switch (node.getId()) {
                case 7: {
                    builder.append(this.plural(node));
                    break;
                }
                case 13: {
                    builder.append(this.list(node));
                    break;
                }
                case 14: {
                    builder.append(this.pickRandomly(node));
                    break;
                }
                case 15: {
                    builder.append(this.numberToText(node));
                    break;
                }
                case 16: {
                    builder.append(this.prettify(node));
                    break;
                }
                case 12: {
                    builder.append(this.count(node));
                    break;
                }
                case 8: {
                    builder.append(this.determiner(node));
                    break;
                }
                case 20: {
                    break;
                }
                default: {
                    for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                        NLGRealiserExpression childNode = (NLGRealiserExpression)node.jjtGetChild(i);
                        builder.append(this.stringify(childNode));
                    }
                }
            }
        } else {
            builder.append(node.jjtGetValue());
        }
        return builder.toString();
    }

    private NLGRealiserExpression[] getArgNodes(NLGRealiserExpression node) {
        List<NLGRealiserExpression> argsList = this.getArgList(node);
        NLGRealiserExpression[] args = new NLGRealiserExpression[argsList.size()];
        return argsList.toArray(args);
    }

    private NLGRealiserExpression getArgsNodeFromMethodNode(NLGRealiserExpression node) {
        return (NLGRealiserExpression)node.jjtGetChild(0).jjtGetChild(0);
    }

    private NLGRealiserExpression[] getChildArgNodes(NLGRealiserExpression node) {
        List<NLGRealiserExpression> argsList = this.getChildArgList(this.getArgsNodeFromMethodNode(node));
        NLGRealiserExpression[] args = new NLGRealiserExpression[argsList.size()];
        return argsList.toArray(args);
    }

    private List<NLGRealiserExpression> getChildArgList(NLGRealiserExpression node) {
        int numChild = node.jjtGetNumChildren();
        ArrayList<NLGRealiserExpression> stringArgs = new ArrayList<NLGRealiserExpression>();
        for (int i = 0; i < numChild; ++i) {
            NLGRealiserExpression child = (NLGRealiserExpression)node.jjtGetChild(i);
            if (child.getId() != 11 && child.getId() != 18 && child.getId() != 19) continue;
            stringArgs.add(child);
        }
        return stringArgs;
    }

    private List<NLGRealiserExpression> getArgList(NLGRealiserExpression node) {
        int numChild = node.jjtGetNumChildren();
        ArrayList<NLGRealiserExpression> stringArgs = new ArrayList<NLGRealiserExpression>();
        if (node.getId() == 5) {
            return stringArgs;
        }
        for (int i = 0; i < numChild; ++i) {
            NLGRealiserExpression child = (NLGRealiserExpression)node.jjtGetChild(i);
            if (child.getId() == 11) {
                stringArgs.add(child);
            }
            stringArgs.addAll(this.getArgList(child));
        }
        return stringArgs;
    }
}

