/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.provider;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.LearnableUserAction;
import com.ibm.smarts.store.api.IStoreFactory;
import com.ibm.smarts.store.api.ITypedStore;
import com.ibm.smarts.store.api.config.StoreConfig;
import com.ibm.smarts.store.api.provider.IUserActionStore;
import com.ibm.smarts.store.api.provider.InvalidStoreAccessException;
import com.ibm.smarts.store.api.provider.UserActionStorable;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SmartsInMemUserActionStore
implements IUserActionStore {
    private ITypedStore<List<LearnableUserAction>> storeByUserId;
    private ITypedStore<List<LearnableUserAction>> storeByActionType;
    private ITypedStore<List<LearnableUserAction>> storeByActionTypeAndUserId;
    private HashMap<String, ITypedStore<UserActionStorable>> storeByConsumerKey = new HashMap();
    private IStoreFactory consumerKeyStorageFactory = null;
    private StoreConfig config = null;
    private RequestContext requestContext = null;
    private final UserActionStorable emptyStats = new UserActionStorable();
    private Map<String, Map<String, JSONObject>> jsonBlobByUser = new HashMap<String, Map<String, JSONObject>>();

    public SmartsInMemUserActionStore(ITypedStore<List<LearnableUserAction>> it, ITypedStore<List<LearnableUserAction>> it2, ITypedStore<List<LearnableUserAction>> it3) {
        this.storeByUserId = it;
        this.storeByActionType = it2;
        this.storeByActionTypeAndUserId = it3;
    }

    public void setConsumerKeyStorageFactory(IStoreFactory factory, StoreConfig config, RequestContext requestContext) {
        this.consumerKeyStorageFactory = factory;
        this.config = config;
        this.requestContext = requestContext;
    }

    @Override
    public StoreStatus store(IRecord<LearnableUserAction> userAction) {
        String key = ((LearnableUserAction)userAction.getRecord()).getUserId();
        this.store(this.storeByUserId, key, userAction);
        key = ((LearnableUserAction)userAction.getRecord()).getActionType();
        this.store(this.storeByActionType, key, userAction);
        key = this.getCompositeKey(((LearnableUserAction)userAction.getRecord()).getUserId(), ((LearnableUserAction)userAction.getRecord()).getActionType());
        this.store(this.storeByActionTypeAndUserId, key, userAction);
        return new StoreStatus(true, null);
    }

    private String getCompositeKey(String userId, String actionType) {
        if (userId != null && actionType != null) {
            return userId + "|" + actionType;
        }
        return null;
    }

    private void store(ITypedStore<List<LearnableUserAction>> hashMap, String key, IRecord<LearnableUserAction> userAction) {
        if (key != null && !key.isEmpty()) {
            IRecord newListRecord = null;
            List existingList = (List)hashMap.getById(key);
            if (existingList == null) {
                ArrayList<Object> newList = new ArrayList<Object>();
                newList.add(userAction.getRecord());
                newListRecord = IRecord.create(newList, (String)key);
            } else {
                existingList.add(userAction.getRecord());
                newListRecord = IRecord.create((Object)existingList, (String)key);
            }
            hashMap.store(newListRecord, true);
        }
    }

    @Override
    public List<LearnableUserAction> getByUserId(String userId) {
        if (userId != null && !userId.isEmpty()) {
            return (List)this.storeByUserId.getById(userId);
        }
        return new ArrayList<LearnableUserAction>();
    }

    @Override
    public List<LearnableUserAction> getByUserId(String userId, String actionType) {
        String key = this.getCompositeKey(userId, actionType);
        if (key != null && !key.isEmpty()) {
            return (List)this.storeByActionTypeAndUserId.getById(key);
        }
        return new ArrayList<LearnableUserAction>();
    }

    @Override
    public List<LearnableUserAction> getByActionType(String actionType) {
        if (actionType != null && !actionType.isEmpty()) {
            return (List)this.storeByActionType.getById(actionType);
        }
        return new ArrayList<LearnableUserAction>();
    }

    @Override
    public StoreStatus deleteByUserId(String userId) {
        List<LearnableUserAction> userActions = this.getByUserId(userId);
        if (userActions != null && !userActions.isEmpty()) {
            HashSet<String> alreadyCleanedActionTypes = new HashSet<String>();
            for (LearnableUserAction action : userActions) {
                if (alreadyCleanedActionTypes.contains(action.getActionType())) continue;
                List listByActionType = (List)this.storeByActionType.getById(action.getActionType());
                ArrayList<LearnableUserAction> replacementList = new ArrayList<LearnableUserAction>();
                for (LearnableUserAction subAction : listByActionType) {
                    if (subAction.getUserId().equals(userId)) continue;
                    replacementList.add(subAction);
                }
                if (replacementList.isEmpty()) {
                    this.storeByActionType.deleteById(action.getActionType());
                } else {
                    IRecord newList = IRecord.create(replacementList, (String)action.getActionType());
                    this.storeByActionType.store(newList, true);
                }
                this.storeByActionTypeAndUserId.deleteById(this.getCompositeKey(userId, action.getActionType()));
                alreadyCleanedActionTypes.add(action.getActionType());
            }
            this.storeByUserId.deleteById(userId);
        }
        return new StoreStatus(true, null);
    }

    @Override
    public StoreStatus increment(String keySet, String key, int k) {
        if (this.consumerKeyStorageFactory == null) {
            throw new InvalidStoreAccessException("consumerKeyStorageFactory");
        }
        ITypedStore currentStore = null;
        if (!this.storeByConsumerKey.containsKey(keySet)) {
            currentStore = this.consumerKeyStorageFactory.getStore(this.config, this.requestContext, UserActionStorable.class, true);
            this.storeByConsumerKey.put(keySet, (ITypedStore<UserActionStorable>)currentStore);
        } else {
            currentStore = this.storeByConsumerKey.get(keySet);
        }
        UserActionStorable stats = (UserActionStorable)currentStore.getById(key);
        IRecord record = null;
        if (stats == null) {
            stats = new UserActionStorable();
        }
        stats.incrementBy(k);
        record = IRecord.create((Object)stats, (String)key);
        return currentStore.store(record, true);
    }

    @Override
    public UserActionStorable getStats(String keySet, String key) {
        if (this.consumerKeyStorageFactory == null) {
            throw new InvalidStoreAccessException("consumerKeyStorageFactory");
        }
        ITypedStore<UserActionStorable> currentStore = null;
        if (!this.storeByConsumerKey.containsKey(keySet)) {
            return this.emptyStats;
        }
        currentStore = this.storeByConsumerKey.get(keySet);
        UserActionStorable stats = (UserActionStorable)currentStore.getById(key);
        if (stats == null) {
            return this.emptyStats;
        }
        return stats;
    }

    @Override
    public StoreStatus storeJSONBlob(RequestContext context, JSONObject jsonBlob, String itemType) {
        String userId = context.getCredentials().getUserId();
        if (!this.jsonBlobByUser.containsKey(userId)) {
            this.jsonBlobByUser.put(userId, new HashMap());
        }
        Map<String, JSONObject> jsonMap = this.jsonBlobByUser.get(userId);
        jsonMap.put(itemType, jsonBlob);
        return new StoreStatus(true, null);
    }

    @Override
    public JSONObject getJSONBlob(RequestContext context, String itemType) {
        Map<String, JSONObject> jsonMap;
        String userId = context.getCredentials().getUserId();
        if (this.jsonBlobByUser.containsKey(userId) && (jsonMap = this.jsonBlobByUser.get(userId)).containsKey(itemType)) {
            return jsonMap.get(itemType);
        }
        return null;
    }

    @Override
    public StoreStatus deleteJSONBlobs(RequestContext context, String itemType) {
        String userId = context.getCredentials().getUserId();
        if (this.jsonBlobByUser.containsKey(userId)) {
            Map<String, JSONObject> usersMap = this.jsonBlobByUser.get(userId);
            usersMap.remove(itemType);
        }
        return new StoreStatus(true, null);
    }
}

