/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu.schema.entity;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;

public class DucklingEntity
extends Entity {
    private String startTime;
    private String endTime;
    private String grain;

    public DucklingEntity(JSONObject entity) {
        super(entity);
    }

    @Override
    protected void readValue(JSONObject json) {
        this.text = (String)json.get((Object)"text");
        this.value = json.get((Object)"value");
        if (this.isTime()) {
            Object value = this.getValue();
            if (value instanceof JSONObject) {
                this.startTime = (String)((JSONObject)value).get((Object)"from");
                this.endTime = (String)((JSONObject)value).get((Object)"to");
            } else if (value instanceof String) {
                this.startTime = (String)value;
                JSONObject additionalInfo = (JSONObject)json.get((Object)"additional_info");
                if (additionalInfo != null) {
                    this.grain = (String)additionalInfo.get((Object)"grain");
                }
            }
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.grain != null) {
            JSONObject additionalInfo = new JSONObject();
            additionalInfo.put((Object)"grain", (Object)this.grain);
            json.put((Object)"additional_info", (Object)additionalInfo);
        }
        return json;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getGrain() {
        return this.grain;
    }

    public boolean isTimeRange() {
        return this.startTime != null && this.endTime != null;
    }
}

