/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pipeline.internal;

import com.ibm.smarts.pipeline.apis.FlowExecutor;
import com.ibm.smarts.pipeline.apis.IContext;
import com.ibm.smarts.pipeline.dag.Flow;
import com.ibm.smarts.pipeline.dag.Node;
import com.ibm.smarts.pipeline.dag.TaskDependencyGraphBuilder;
import com.ibm.smarts.pipeline.internal.ExecutionPlan;
import com.ibm.smarts.pipeline.internal.Task;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class TaskExecutionPlanner {
    public ExecutionPlan plan(String planId, FlowExecutor flowExecutor, Task ... tasks) {
        return this.plan(planId, flowExecutor, Arrays.asList(tasks));
    }

    public ExecutionPlan plan(String planId, FlowExecutor flowExecutor, List<Task> tasks) {
        Flow<String> masterDagCopy = TaskDependencyGraphBuilder.getMasterDagCopy();
        Flow subFlow = new Flow(this.walk(masterDagCopy.getRoot(), tasks, new ArrayList<Node<Task>>(), null));
        return new ExecutionPlan(planId, flowExecutor, subFlow);
    }

    public <T extends IContext> ExecutionPlan plan(String planId, FlowExecutor<T> flowExecutor, List<Task> tasks, Task initialTask, Task finalTask) {
        Flow<String> masterDagCopy = TaskDependencyGraphBuilder.getMasterDagCopy();
        Flow subFlow = new Flow(this.walk(masterDagCopy.getRoot(), tasks, new ArrayList<Node<Task>>(), null));
        return new ExecutionPlan<T>(planId, flowExecutor, subFlow, initialTask, finalTask);
    }

    public List<Node<Task>> walk(Node<String> node, List<Task> tasks, List<Node<Task>> subNodes, Node<Task> parentNode) {
        block7: {
            Task matchingTask;
            block6: {
                matchingTask = this.findTaskById(tasks, node.getData());
                if (matchingTask != null) break block6;
                if (node.getSuccessors() == null) break block7;
                for (Node<String> successor : node.getSuccessors()) {
                    successor.getInDegree().decrementAndGet();
                    this.walk(successor, tasks, subNodes, parentNode);
                }
                break block7;
            }
            Node<Task> currentNode = null;
            Optional<Node> subNode = subNodes.stream().filter(n -> ((Task)n.getData()).id.equals(node.getData())).findFirst();
            if (subNode.isPresent()) {
                currentNode = subNode.get();
            } else {
                currentNode = new Node<Task>(matchingTask);
                subNodes.add(currentNode);
            }
            if (parentNode != null && parentNode.getSuccessor(currentNode.getData()) == null) {
                parentNode.add(currentNode);
            }
            if (node.getSuccessors() != null) {
                for (Node<String> successor : node.getSuccessors()) {
                    this.walk(successor, tasks, subNodes, currentNode);
                }
            }
        }
        return subNodes;
    }

    private Task findTaskById(List<Task> tasks, String id) {
        for (Task task : tasks) {
            if (!id.equals(task.id)) continue;
            return task;
        }
        return null;
    }
}

