/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.lifecycle;

import com.ibm.smarts.core.lifecycle.IComponentLifecycle;
import com.ibm.smarts.core.lifecycle.IComponentLifecycleOperations;
import com.ibm.smarts.core.lifecycle.ILifecycleManager;
import com.ibm.smarts.core.util.RequestContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleManager
implements ILifecycleManager {
    private final List<IComponentLifecycleOperations> components = new ArrayList<IComponentLifecycleOperations>();
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleManager.class);
    private final IComponentLifecycle owner;
    private final OwnerState ownerState = new OwnerState();

    public LifecycleManager(IComponentLifecycle owner, IComponentLifecycleOperations ... comps) {
        this.owner = owner;
        this.addComponents(comps);
    }

    public void addComponents(IComponentLifecycleOperations ... comps) {
        for (IComponentLifecycleOperations comp : comps) {
            this.components.add(comp);
        }
    }

    @Override
    public ILifecycleManager getLifecycleManager() {
        return this;
    }

    private void log(String msg) {
        LOGGER.info("[ComponentLifecycle][" + this.owner.getClass().getName() + "] <TCL> " + msg);
    }

    @Override
    public void componentInitialize(RequestContext rc) {
        this.log("InitializeComponent...");
        this.fireInitialize(rc);
        if (!this.ownerState.initialized) {
            this.log("initializing component.");
            this.owner.initialize(rc);
            this.ownerState.initialized = true;
        } else {
            this.log("component previously initialized.");
        }
    }

    @Override
    public void componentShutdown(RequestContext rc) {
        this.log("shut down component...");
        if (!this.ownerState.shutDown) {
            this.log("shutting down component.");
            this.owner.shutDown(rc);
            this.ownerState.shutDown = true;
        } else {
            this.log("component previously shut down.");
        }
        this.fireShutdown(rc);
    }

    private void fireInitialize(RequestContext rc) {
        for (IComponentLifecycleOperations cl : this.components) {
            this.log("initializing dependent component " + cl.getClass().getName());
            cl.componentInitialize(rc);
        }
    }

    private void fireShutdown(RequestContext rc) {
        for (IComponentLifecycleOperations cl : this.components) {
            this.log("shutting dependent component " + cl.getClass().getName());
            cl.componentShutdown(rc);
        }
    }

    private static class OwnerState {
        public boolean initialized = false;
        public boolean shutDown = false;

        private OwnerState() {
        }
    }
}

