/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.api.IAssetPermissions;
import com.ibm.smarts.core.api.ICredentials;
import com.ibm.smarts.core.async.AsyncMetrics;
import com.ibm.smarts.core.i18n.NLS;
import com.ibm.smarts.core.util.Request;
import com.ibm.smarts.core.util.RequestMetrics;
import com.ibm.smarts.core.util.RestMetrics;
import com.ibm.smarts.core.util.StoreMetrics;
import com.ibm.smarts.core.util.ToString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class RequestContext {
    public final Request request;
    public final Map<String, Object> contextAttributes = new HashMap<String, Object>();
    public final RequestMetrics requestMetrics = new RequestMetrics();
    private static final AtomicLong callCounter = new AtomicLong(0L);
    public final UUID uuid;
    public final Locale locale;
    public final Locale productLocale;
    public final IAssetPermissions permissions;
    public final boolean isTracing;
    public static boolean __debug_cacheInstances = false;
    public static final ConcurrentHashMap<UUID, List<RequestMetrics>> __debug_instanceCache = new ConcurrentHashMap();

    public static void __debug_clearCache() {
        __debug_instanceCache.clear();
    }

    public static List<RequestMetrics> __debug_get(UUID key) {
        List<RequestMetrics> ret = __debug_instanceCache.get(key);
        if (ret == null) {
            ret = new ArrayList<RequestMetrics>();
        }
        return ret;
    }

    public RequestContext(RequestContext rc) {
        this.request = new Request(rc.request);
        this.contextAttributes.putAll(rc.contextAttributes);
        this.uuid = rc.uuid;
        this.locale = rc.locale;
        this.productLocale = rc.productLocale;
        this.permissions = rc.permissions;
        this.isTracing = rc.isTracing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestContext(Request request) {
        assert (request != null);
        this.request = request;
        this.uuid = request.uuid;
        this.locale = request.locale;
        this.productLocale = request.productLocale;
        this.permissions = request.permissions;
        this.isTracing = request.isTracing;
        if (__debug_cacheInstances) {
            List list;
            List list2 = list = __debug_instanceCache.computeIfAbsent(this.uuid, key -> new ArrayList());
            synchronized (list2) {
                list.add(this.requestMetrics);
            }
        }
    }

    public RequestContext(Locale locale, Locale productLocale) {
        this(new Request(locale, productLocale, null, null, false));
    }

    public RequestContext(Locale locale, Locale productLocale, boolean isTracing) {
        this(new Request(locale, productLocale, null, null, isTracing));
    }

    public RequestContext(Locale locale, Locale productLocale, ICredentials credentials, IAssetPermissions permissions) {
        this(new Request(locale, productLocale, credentials, permissions, false));
    }

    public RequestContext(Locale locale, Locale productLocale, ICredentials credentials, IAssetPermissions permissions, boolean isTracing) {
        this(new Request(UUID.randomUUID(), locale, productLocale, credentials, permissions, isTracing));
    }

    public RequestContext(UUID uuid, Locale locale, Locale productLocale, ICredentials credentials, IAssetPermissions permissions, boolean isTracing) {
        this(new Request(uuid, locale, productLocale, credentials, permissions, isTracing));
    }

    public String toString() {
        return ToString.with(this).field("request", this.request).get();
    }

    public ICredentials getCredentials() {
        return this.request.credentials;
    }

    public static void setCredentials(RequestContext rc, ICredentials creds) {
        rc.request.credentials = creds;
    }

    public long nextCallId() {
        return callCounter.incrementAndGet();
    }

    public AsyncMetrics asyncMetrics() {
        return this.requestMetrics.asyncMetrics;
    }

    public StoreMetrics storeMetrics() {
        return this.requestMetrics.storeMetrics;
    }

    public RestMetrics restMetrics() {
        return this.requestMetrics.restMetrics;
    }

    public <T extends NLS> T messages(Class<?> clazz) {
        Object ret = NLS.get(clazz, this.request.locale.toString());
        return ret;
    }

    public void setAttribute(String name, Object value) {
        this.contextAttributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.contextAttributes.get(name);
    }

    public void removeAttribute(String name) {
        this.contextAttributes.remove(name);
    }

    public void setRequestAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public Object getRequestAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public void removeRequestAttribute(String name) {
        this.request.removeAttribute(name);
    }

    @Deprecated
    public Map<String, List<String>> getHttpHeaders() {
        return this.request.getHttpHeaders();
    }
}

