/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.registry;

import com.ibm.smarts.schema.ConceptInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Concept {
    private static final int MAX_NUM_ANCESTORS = 1000;
    private static final String UNKNOWN_IRI = "Unknown";
    public static final Concept UNKNOWN_CONCEPT = new Concept("Unknown", "");
    private String name = "";
    private String iri = "";
    private String ontologyID = "";
    private boolean isVisible = true;
    private List<Concept> parents;
    private List<Concept> children;
    private Map<String, String> properties;

    public Concept(String iri, String name) {
        this.name = name;
        this.iri = iri;
    }

    public void addChild(Concept child) {
        if (this.children == null) {
            this.children = new ArrayList<Concept>();
        }
        this.children.add(child);
        child.addParent(this);
    }

    private void addParent(Concept parent) {
        if (this.parents == null) {
            this.parents = new ArrayList<Concept>();
        }
        this.parents.add(parent);
    }

    public List<Concept> getParents() {
        if (this.parents == null) {
            return Collections.emptyList();
        }
        return this.parents.stream().flatMap(p -> p.isVisible() ? Stream.of(p) : p.getParents().stream()).collect(Collectors.toList());
    }

    public Set<Concept> getAncestors() {
        return this.getAncestors(0);
    }

    private Set<Concept> getAncestors(int depth) {
        if (++depth > 1000) {
            return Collections.emptySet();
        }
        HashSet<Concept> ancestors = new HashSet<Concept>();
        for (Concept parent : this.getParents()) {
            ancestors.add(parent);
            ancestors.addAll(parent.getAncestors(depth));
        }
        return ancestors;
    }

    public List<Concept> getChildren() {
        return this.children == null ? Collections.emptyList() : this.children;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getIRI() {
        return this.iri;
    }

    public String getOntologyID() {
        if (this.name == null) {
            return "";
        }
        return this.ontologyID;
    }

    public void setOntologyID(String ontologyID) {
        this.ontologyID = ontologyID;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public ConceptInfo toConceptInfo(float confidence) {
        ConceptInfo c = new ConceptInfo();
        c.setConceptID(this.iri);
        c.setConfidence(confidence);
        return c;
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value);
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public String toString() {
        return this.name;
    }
}

