/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier;

import com.ibm.smarts.ontology.reasoner.ExistentialRestrictionCollector;
import com.ibm.smarts.schema.util.OntologyCommon;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;

public class ConceptClassificationCommon
extends OntologyCommon {
    public static final IRI VISIBLE_APP_CLASS_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#visibleAppClass");
    public static final IRI VISIBLE_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#visibleProperty");

    protected boolean isVisibleClass(IRI conceptID, boolean bDefault, OWLOntology owlOntology) {
        return this.getBooleanAnnotationValue(bDefault, owlOntology, VISIBLE_APP_CLASS_PROPERTY_IRI, (OWLAnnotationSubject)conceptID);
    }

    public boolean getBooleanAnnotationValue(boolean bDefault, OWLOntology owlOntology, IRI property, OWLAnnotationSubject entity) {
        Set axiom = owlOntology.getAxioms(OWLAnnotationAssertionAxiom.class, OWLAnnotationSubject.class, (OWLObject)entity, Imports.INCLUDED, Navigation.IN_SUB_POSITION);
        Optional<OWLAnnotationAssertionAxiom> visible = axiom.stream().filter(a -> a.getProperty().getIRI().equals((Object)property) && ((OWLLiteral)a.getValue().asLiteral().get()).isBoolean()).findFirst();
        if (!visible.isPresent()) {
            return bDefault;
        }
        return ((OWLLiteral)visible.get().getValue().asLiteral().get()).parseBoolean();
    }

    protected Set<OWLClass> getChildrenLevelConcepts(OWLClass cClass, OWLOntology ontology, IRI propertyIRI) {
        ExistentialRestrictionCollector restrictionVisitor = new ExistentialRestrictionCollector(Collections.singleton(ontology), Collections.singletonList(propertyIRI), false);
        cClass.accept((OWLClassExpressionVisitor)restrictionVisitor);
        return restrictionVisitor.getRestrictedProperties().stream().filter(c -> c instanceof OWLClass).map(c -> (OWLClass)c).collect(Collectors.toSet());
    }

    protected Set<OWLNamedIndividual> getPropertyValues(OWLClass cClass, OWLOntology ontology, IRI propertyIRI) {
        ExistentialRestrictionCollector restrictionVisitor = new ExistentialRestrictionCollector(Collections.singleton(ontology), Collections.singletonList(propertyIRI), true);
        cClass.accept((OWLClassExpressionVisitor)restrictionVisitor);
        return restrictionVisitor.getRestrictedProperties().stream().filter(c -> c instanceof OWLNamedIndividual).map(c -> (OWLNamedIndividual)c).collect(Collectors.toSet());
    }
}

