/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.Relation;
import com.ibm.smarts.schema.RelationType;
import com.ibm.smarts.schema.SemanticInfo;
import java.util.Optional;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.IRI;

public class PreEnsemble
extends AbstractSmartsModuleClassificationStep {
    protected PreEnsemble(RequestContext requestContext) {
        super(requestContext);
    }

    @Override
    public void execute(SmartsModuleClassificationPkg pkg) {
        pkg.getDatasetClassificationPkgs().forEach(dp -> dp.getInScopeColumnClassificationPkgs().stream().filter(cp -> !cp.getConcepts().isEmpty()).forEach(cp -> {
            SemanticInfo si = new SemanticInfo();
            if (cp.getColumnInfo().getSemanticInfo() != null) {
                si.setOverwrites(cp.getColumnInfo().getSemanticInfo().getOverwrites());
            }
            si.getConcepts().addAll(cp.getConcepts().stream().filter(c -> !c.getConceptID().startsWith("http://www.ibm.com/ontologies/waca/application") || this.isVisibleClass((ConceptInfo)c, false)).collect(Collectors.toList()));
            this.addHasAttributeRelation(si, (SmartsModuleClassificationPkg.ColumnClassificationPkg)cp);
            si.setUsage(cp.getUsage());
            si.setDefaultAggregation(cp.getDefaultAggregation());
            cp.getColumnInfo().setSemanticInfo(si);
        }));
    }

    private void addHasAttributeRelation(SemanticInfo si, SmartsModuleClassificationPkg.ColumnClassificationPkg cp) {
        cp.getConcepts().forEach(c -> cp.getEntityCandidates(new SmartsModuleClassificationPkg.Candidate(IRI.create((String)c.getConceptID())).setRelevance(0.0f)).stream().filter(e -> !e.getConceptID().isThing() && this.isVisibleClass(e.getConceptID(), true)).forEach(e -> {
            ConceptInfo eConcept = null;
            Optional<ConceptInfo> existingConcept = si.getConcepts().stream().filter(ec -> IRI.create((String)ec.getConceptID()).equals((Object)e.getConceptID())).findAny();
            if (existingConcept.isPresent()) {
                eConcept = existingConcept.get();
            } else {
                eConcept = this.createConceptInfo((SmartsModuleClassificationPkg.Candidate)e);
                si.getConcepts().add(eConcept);
            }
            Relation relation = this.objFactory.createRelation();
            relation.setRelationType(RelationType.HAS_ATTRIBUTE);
            relation.setEndFrom(eConcept);
            relation.setEndTo(c);
            si.getRelations().add(relation);
        }));
    }
}

