/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier.smartsmodule;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.smartsmodule.AbstractSmartsModuleClassificationStep;
import com.ibm.smarts.ontology.classifier.smartsmodule.SmartsModuleClassificationPkg;
import com.ibm.smarts.ontology.reasoner.ClassCollector;
import com.ibm.smarts.ontology.reasoner.DataHintEvaluator;
import com.ibm.smarts.ontology.reasoner.ExistentialRestrictionCollector;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.ConceptInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;

public class RelevanceScoreAdjustment
extends AbstractSmartsModuleClassificationStep {
    private List<Ontology<OWLOntology>> mOntologies = null;

    RelevanceScoreAdjustment(List<Ontology<OWLOntology>> ontologies, RequestContext requestContext) {
        super(requestContext);
        this.mOntologies = ontologies;
    }

    @Override
    public void execute(SmartsModuleClassificationPkg smPkg) {
        smPkg.getDatasetClassificationPkgs().forEach(this::classify);
        this.clearMDC();
    }

    private void classify(SmartsModuleClassificationPkg.DatasetClassificationPkg dsPkg) {
        this.mdcDSInfo(dsPkg);
        List<SmartsModuleClassificationPkg.ColumnClassificationPkg> inScopeColPkgs = dsPkg.getInScopeColumnClassificationPkgs();
        if (inScopeColPkgs.isEmpty()) {
            return;
        }
        if (this.isExecParallel()) {
            IntStream.range(0, inScopeColPkgs.size()).parallel().forEach(i -> this.classify(i, (SmartsModuleClassificationPkg.ColumnClassificationPkg)inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope()));
        } else {
            IntStream.range(0, inScopeColPkgs.size()).forEach(i -> this.classify(i, (SmartsModuleClassificationPkg.ColumnClassificationPkg)inScopeColPkgs.get(i), dsPkg.getDelatAnalysisScope()));
        }
    }

    private void classify(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, DeltaAnalysisScope deltaAnalysisScope) {
        if (this.shouldExecute(columnPkg, deltaAnalysisScope, DeltaAnalysisScope.ModifiableProperty.ALL, DeltaAnalysisScope.ModifiableProperty.NAME)) {
            this.mdcColInfo(index, columnPkg);
            this.mOntologies.forEach(o -> this.classify(index, columnPkg, (Ontology<OWLOntology>)o));
        }
    }

    private void classify(int index, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology) {
        LOGGER.info("Classify column [{}]:{}", (Object)index, (Object)columnPkg.getColumnInfo().getId());
        OWLReasoner reasoner = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getReasoner(ontology);
        this.adjustScoreRevelanceScore(columnPkg, ontology, reasoner);
    }

    private void adjustScoreRevelanceScore(SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology, OWLReasoner reasoner) {
        OWLDataFactory factory = ((OWLOntology)ontology.getValue()).getOWLOntologyManager().getOWLDataFactory();
        columnPkg.getCandidates().forEach(c -> {
            this.adjustRelevanceAccordingToDataHint((SmartsModuleClassificationPkg.Candidate)c, columnPkg, ontology, factory);
            this.adjustRelevanceAccordingToBoostFactors((SmartsModuleClassificationPkg.Candidate)c, columnPkg, ontology, reasoner, factory);
        });
    }

    private void adjustRelevanceAccordingToBoostFactors(SmartsModuleClassificationPkg.Candidate c, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology, OWLReasoner reasoner, OWLDataFactory factory) {
        OWLClass cClass = factory.getOWLClass(c.getConceptID());
        ExistentialRestrictionCollector restrictionVisitor = new ExistentialRestrictionCollector(Collections.singleton(ontology.getValue()), Collections.singletonList(HAS_BOOST_FACTOR_PROPERTY_IRI), false);
        cClass.accept((OWLClassExpressionVisitor)restrictionVisitor);
        restrictionVisitor.getRestrictedProperties().forEach(boostFactor -> {
            final Pair factorWeight = new Pair(Optional.empty(), Optional.empty());
            OWLObjectVisitorAdapter v = new OWLObjectVisitorAdapter(){

                public void visit(OWLObjectIntersectionOf ce) {
                    ce.getOperandsAsList().forEach(o -> o.accept((OWLObjectVisitor)this));
                }

                public void visit(OWLDataHasValue ce) {
                    if (ce.getProperty().asOWLDataProperty().getIRI().equals((Object)AbstractSmartsModuleClassificationStep.BOOST_FACTOR_WEIGHT_PROPERTY_IRI)) {
                        factorWeight.setSecond(Optional.of(ce.getFiller()));
                    }
                }

                public void visit(OWLObjectAllValuesFrom ce) {
                    if (ce.getProperty().asOWLObjectProperty().getIRI().equals((Object)AbstractSmartsModuleClassificationStep.HAS_PATTERN_PROPERTY_IRI)) {
                        factorWeight.setFirst(Optional.of(ce));
                    }
                }

                public void visit(OWLObjectSomeValuesFrom ce) {
                    if (ce.getProperty().asOWLObjectProperty().getIRI().equals((Object)AbstractSmartsModuleClassificationStep.HAS_PATTERN_PROPERTY_IRI)) {
                        factorWeight.setFirst(Optional.of(ce));
                    }
                }
            };
            boostFactor.accept((OWLObjectVisitor)v);
            if (factorWeight.getFirst().isPresent()) {
                Map<IRI, List<OWLLiteral>> dataPropertyValues = columnPkg.getDataPropertyValues();
                HashMap<IRI, List<ConceptInfo>> propertyValues = new HashMap<IRI, List<ConceptInfo>>();
                propertyValues.put(HAS_PATTERN_PROPERTY_IRI, columnPkg.getConcepts());
                float result = ((Float)((OWLClassExpression)factorWeight.getFirst().get()).accept((OWLObjectVisitorEx)new DataHintEvaluator((OWLOntology)ontology.getValue(), reasoner, propertyValues, dataPropertyValues, Collections.emptyList(), this.currentReqCtx))).floatValue();
                if (Float.compare(result, 0.0f) > 0) {
                    float boostScore = 0.01f;
                    if (factorWeight.getSecond().isPresent()) {
                        boostScore = ((OWLLiteral)factorWeight.getSecond().get()).parseFloat();
                    }
                    if (Float.compare(c.getLexicalRelevance(), 0.0f) > 0) {
                        boostScore *= c.getLexicalRelevance();
                    }
                    c.setRelevance(c.getRelevance() + boostScore);
                    LOGGER.info("adjusted score {} for {} due to boostFactor {}", new Object[]{Float.valueOf(boostScore), c.getConceptID().getShortForm(), boostFactor.toString()});
                }
            }
        });
    }

    private void adjustRelevanceAccordingToDataHint(SmartsModuleClassificationPkg.Candidate c, SmartsModuleClassificationPkg.ColumnClassificationPkg columnPkg, Ontology<OWLOntology> ontology, OWLDataFactory factory) {
        OWLClass cClass = factory.getOWLClass(c.getConceptID());
        Set applicationConcepts = columnPkg.getConcepts().stream().map(ac -> factory.getOWLClass(IRI.create((String)ac.getConceptID()))).collect(Collectors.toSet());
        ExistentialRestrictionCollector restrictionVisitor = new ExistentialRestrictionCollector(Collections.singleton(ontology.getValue()), Collections.singletonList(HAS_DATA_HINT_PROPERTY_IRI), true);
        cClass.accept((OWLClassExpressionVisitor)restrictionVisitor);
        restrictionVisitor.getRestrictedProperties().forEach(dataHint -> {
            Set<OWLClass> dependentApplicationConcepts = ClassCollector.collectClassesFromSignature(dataHint, "http://www.ibm.com/ontologies/waca/application#");
            dependentApplicationConcepts.forEach(da -> {
                if (applicationConcepts.contains(da)) {
                    Optional<ConceptInfo> cInfo = columnPkg.getConcepts().stream().filter(cpt -> cpt.getConceptID().equals(da.getIRI().toString())).findFirst();
                    LOGGER.debug("ConceptInfo in CandidateFiltering:" + CommonJAXBHelper.marshalToJSON((Object)cInfo.get()));
                    float adjustment = cInfo.isPresent() && Float.compare(cInfo.get().getConfidence(), 1.0f) < 0 ? 0.2f * cInfo.get().getConfidence() : 0.02f;
                    c.setRelevance(c.getRelevance() + (adjustment *= c.getRelevance()));
                    LOGGER.info("adjusted score {} for {} due to {} satisfies datahint {}", new Object[]{Float.valueOf(adjustment), c.getConceptID().getShortForm(), da.getIRI().getShortForm(), dataHint.toString()});
                }
            });
        });
    }
}

