/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pipeline.internal;

import com.ibm.smarts.pipeline.apis.IContext;
import com.ibm.smarts.pipeline.apis.ITask;
import com.ibm.smarts.pipeline.constants.ExecutionStatus;
import com.ibm.smarts.pipeline.internal.ExecutionPlan;
import com.ibm.smarts.pipeline.progress.TaskStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task<T extends IContext>
implements ITask {
    protected String id;
    private List<String> inputs;
    private List<String> outputs;
    private static final Logger LOGGER = LoggerFactory.getLogger(Task.class);

    public Task() {
    }

    public Task(String id) {
        this.id = id;
    }

    public Task(String id, List<String> inputs, List<String> outputs) {
        this.id = id;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    @Override
    public boolean isSuccessorOf(ITask task) {
        for (String input : this.inputs) {
            if (!task.getOutputs().contains(input)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPredecessorOf(ITask task) {
        for (String output : this.outputs) {
            if (!task.getInputs().contains(output)) continue;
            return true;
        }
        return false;
    }

    ExecutionStatus wrappedExecute(T data, ExecutionPlan<T> parentPlan) {
        TaskStatus taskStatus;
        this.sendUpdate(data, parentPlan, ExecutionStatus.IN_PROGRESS);
        try {
            taskStatus = this.execute(data);
        }
        catch (Exception e) {
            ArrayList<String> errorList = new ArrayList<String>(1);
            errorList.add(e.getMessage());
            taskStatus = new TaskStatus(errorList, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
            taskStatus.setStatus(ExecutionStatus.ERROR);
            this.handleError(e);
        }
        if (taskStatus.getStatus() != ExecutionStatus.ERROR && taskStatus.getStatus() != ExecutionStatus.CANCELLED) {
            taskStatus.setStatus(ExecutionStatus.COMPLETE);
        }
        this.sendUpdate(data, parentPlan, taskStatus);
        return taskStatus.getStatus();
    }

    @Override
    public List<String> getOutputs() {
        return this.outputs;
    }

    @Override
    public List<String> getInputs() {
        return this.inputs;
    }

    private void sendUpdate(T data, ExecutionPlan<T> parentPlan, TaskStatus taskStatus) {
        parentPlan.onUpdate(this.id, taskStatus, data);
    }

    void sendUpdate(T data, ExecutionPlan<T> parentPlan, ExecutionStatus status) {
        parentPlan.onUpdate(this.id, status, data);
    }

    public abstract TaskStatus execute(T var1) throws Exception;

    public boolean canceled() {
        return Thread.currentThread().isInterrupted();
    }

    public void handleError(Exception e) {
        LOGGER.error("An error occurred", (Throwable)e);
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }
}

